/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config.compat.v506;

import java.util.List;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.AbstractNVersionCompat;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.CompatUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.v506.NWorkspaceConfigBoot506;
import net.thevpc.nuts.security.NUserConfig;

public class NVersionCompat506
extends AbstractNVersionCompat {
    public NVersionCompat506(NVersion apiVersion) {
        super(apiVersion, 506);
    }

    @Override
    public NWorkspaceConfigBoot parseConfig(byte[] bytes) {
        return this.parseConfig506(bytes).toWorkspaceConfig();
    }

    @Override
    public NWorkspaceConfigApi parseApiConfig(NId nutsApiId) {
        NWorkspaceConfigApi cc = new NWorkspaceConfigApi();
        cc.setApiVersion(this.getApiVersion());
        NWorkspaceConfigBoot506 c = this.parseConfig506(CompatUtils.readAllBytes(NWorkspace.of().getWorkspaceLocation().toPath().get().resolve("nuts-workspace.json")));
        if (c != null) {
            cc.setApiVersion(c.getApiVersion());
            cc.setRuntimeId(c.getRuntimeId());
            cc.setJavaCommand(c.getJavaCommand());
            cc.setJavaOptions(c.getJavaOptions());
        }
        return cc;
    }

    @Override
    public NWorkspaceConfigRuntime parseRuntimeConfig() {
        NWorkspaceConfigRuntime cc = new NWorkspaceConfigRuntime();
        NWorkspaceConfigBoot506 c = this.parseConfig506(CompatUtils.readAllBytes(NWorkspace.of().getWorkspaceLocation().toPath().get().resolve("nuts-workspace.json")));
        if (c != null) {
            cc.setDependencies(c.getRuntimeDependencies());
            cc.setId(c.getRuntimeId());
        }
        return cc;
    }

    @Override
    public NWorkspaceConfigSecurity parseSecurityConfig(NId nutsApiId) {
        NWorkspaceConfigSecurity cc = new NWorkspaceConfigSecurity();
        NWorkspaceConfigBoot506 c = this.parseConfig506(CompatUtils.readAllBytes(NWorkspace.of().getWorkspaceLocation().toPath().get().resolve("nuts-workspace.json")));
        if (c != null) {
            cc.setSecure(c.isSecure());
            cc.setAuthenticationAgent(c.getAuthenticationAgent());
            List<NUserConfig> users = c.getUsers();
            cc.setUsers(CompatUtils.copyNutsUserConfigArray(users == null ? null : users.toArray(new NUserConfig[0])));
        }
        return cc;
    }

    @Override
    public NWorkspaceConfigMain parseMainConfig(NId nutsApiId) {
        NWorkspaceConfigMain cc = new NWorkspaceConfigMain();
        NWorkspaceConfigBoot506 c = this.parseConfig506(CompatUtils.readAllBytes(NWorkspace.of().getWorkspaceLocation().toPath().get().resolve("nuts-workspace.json")));
        if (c != null) {
            c.setRepositories(CompatUtils.copyNutsRepositoryRefList(c.getRepositories()));
            c.setCommandFactories(CompatUtils.copyNutsCommandAliasFactoryConfigList(c.getCommandFactories()));
            c.setEnv(CompatUtils.copyProperties(c.getEnv()));
            c.setSdk(CompatUtils.copyNutsSdkLocationList(c.getSdk()));
            c.setImports(CompatUtils.copyStringList(c.getImports()));
        }
        return cc;
    }

    private NWorkspaceConfigBoot506 parseConfig506(byte[] bytes) {
        return NElementParser.ofJson().parse(bytes, NWorkspaceConfigBoot506.class);
    }
}

