/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config.compat.v502;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NRepositoryRef;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.workspace.config.NStoreLocationsMap;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.util.NBlankable;

public class NRepositoryConfig502
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final NVersion CONFIG_VERSION_502 = NVersion.get("0.5.2").get();
    private String uuid;
    private String name;
    private String type;
    private String location;
    private String programsStoreLocation = null;
    private String configStoreLocation = null;
    private String varStoreLocation = null;
    private String libStoreLocation = null;
    private String logStoreLocation = null;
    private String tempStoreLocation = null;
    private String cacheStoreLocation = null;
    private String runStoreLocation = null;
    private NStoreStrategy storeLocationStrategy = null;
    private String groups;
    private Map<String, String> env;
    private List<NRepositoryRef> mirrors;
    private List<NUserConfig> users;
    private boolean indexEnabled;
    private String authenticationAgent;

    public NRepositoryConfig502() {
    }

    public NRepositoryConfig502(NRepositoryConfig502 other) {
        this.name = other.getName();
        this.uuid = other.getUuid();
        this.location = other.getLocation();
        this.type = other.getType();
        this.groups = other.getGroups();
        this.programsStoreLocation = other.programsStoreLocation;
        this.configStoreLocation = other.configStoreLocation;
        this.varStoreLocation = other.varStoreLocation;
        this.libStoreLocation = other.libStoreLocation;
        this.logStoreLocation = other.logStoreLocation;
        this.tempStoreLocation = other.tempStoreLocation;
        this.cacheStoreLocation = other.cacheStoreLocation;
        this.storeLocationStrategy = other.storeLocationStrategy;
        this.indexEnabled = other.indexEnabled;
        this.authenticationAgent = other.authenticationAgent;
        this.mirrors = other.getMirrors() == null ? null : new ArrayList<NRepositoryRef>(other.getMirrors());
        ArrayList<NUserConfig> arrayList = this.users = other.getUsers() == null ? null : new ArrayList<NUserConfig>(other.getUsers());
        if (other.getEnv() == null) {
            this.env = null;
        } else {
            this.env = new LinkedHashMap<String, String>();
            this.env.putAll(other.getEnv());
        }
    }

    public NRepositoryConfig502(String name, String location, String type) {
        this.name = name;
        this.location = location;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public NRepositoryConfig502 setName(String name) {
        this.name = name;
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public NRepositoryConfig502 setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public NRepositoryConfig502 setType(String type) {
        this.type = type;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public NRepositoryConfig502 setLocation(String location) {
        this.location = location;
        return this;
    }

    public String getProgramsStoreLocation() {
        return this.programsStoreLocation;
    }

    public NRepositoryConfig502 setProgramsStoreLocation(String programsStoreLocation) {
        this.programsStoreLocation = programsStoreLocation;
        return this;
    }

    public String getConfigStoreLocation() {
        return this.configStoreLocation;
    }

    public NRepositoryConfig502 setConfigStoreLocation(String configStoreLocation) {
        this.configStoreLocation = configStoreLocation;
        return this;
    }

    public String getVarStoreLocation() {
        return this.varStoreLocation;
    }

    public NRepositoryConfig502 setVarStoreLocation(String varStoreLocation) {
        this.varStoreLocation = varStoreLocation;
        return this;
    }

    public String getLibStoreLocation() {
        return this.libStoreLocation;
    }

    public NRepositoryConfig502 setLibStoreLocation(String libStoreLocation) {
        this.libStoreLocation = libStoreLocation;
        return this;
    }

    public String getLogStoreLocation() {
        return this.logStoreLocation;
    }

    public NRepositoryConfig502 setLogStoreLocation(String logStoreLocation) {
        this.logStoreLocation = logStoreLocation;
        return this;
    }

    public String getTempStoreLocation() {
        return this.tempStoreLocation;
    }

    public NRepositoryConfig502 setTempStoreLocation(String tempStoreLocation) {
        this.tempStoreLocation = tempStoreLocation;
        return this;
    }

    public String getCacheStoreLocation() {
        return this.cacheStoreLocation;
    }

    public NRepositoryConfig502 setCacheStoreLocation(String cacheStoreLocation) {
        this.cacheStoreLocation = cacheStoreLocation;
        return this;
    }

    public String getRunStoreLocation() {
        return this.runStoreLocation;
    }

    public NRepositoryConfig502 setRunStoreLocation(String runStoreLocation) {
        this.runStoreLocation = runStoreLocation;
        return this;
    }

    public NStoreStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public NRepositoryConfig502 setStoreLocationStrategy(NStoreStrategy storeLocationStrategy) {
        this.storeLocationStrategy = storeLocationStrategy;
        return this;
    }

    public String getGroups() {
        return this.groups;
    }

    public NRepositoryConfig502 setGroups(String groups) {
        this.groups = groups;
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public NRepositoryConfig502 setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public List<NRepositoryRef> getMirrors() {
        return this.mirrors;
    }

    public NRepositoryConfig502 setMirrors(List<NRepositoryRef> mirrors) {
        this.mirrors = mirrors;
        return this;
    }

    public NRepositoryConfig502 setUsers(List<NUserConfig> users) {
        this.users = users;
        return this;
    }

    public List<NUserConfig> getUsers() {
        return this.users;
    }

    public boolean isIndexEnabled() {
        return this.indexEnabled;
    }

    public NRepositoryConfig502 setIndexEnabled(boolean indexEnabled) {
        this.indexEnabled = indexEnabled;
        return this;
    }

    public String getAuthenticationAgent() {
        return this.authenticationAgent;
    }

    public NRepositoryConfig502 setAuthenticationAgent(String authenticationAgent) {
        this.authenticationAgent = authenticationAgent;
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.uuid);
        hash = 59 * hash + Objects.hashCode(this.name);
        hash = 59 * hash + Objects.hashCode(this.type);
        hash = 59 * hash + Objects.hashCode(this.location);
        hash = 59 * hash + Objects.hashCode(this.programsStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.configStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.varStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.libStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.logStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.tempStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.cacheStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.runStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.storeLocationStrategy);
        hash = 59 * hash + Objects.hashCode(this.groups);
        hash = 59 * hash + Objects.hashCode(this.env);
        hash = 59 * hash + Objects.hashCode(this.mirrors);
        hash = 59 * hash + Objects.hashCode(this.users);
        hash = 59 * hash + (this.indexEnabled ? 1 : 0);
        hash = 59 * hash + Objects.hashCode(this.authenticationAgent);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NRepositoryConfig502 other = (NRepositoryConfig502)obj;
        if (this.indexEnabled != other.indexEnabled) {
            return false;
        }
        if (!Objects.equals(this.uuid, other.uuid)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        if (!Objects.equals(this.programsStoreLocation, other.programsStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.configStoreLocation, other.configStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.varStoreLocation, other.varStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.libStoreLocation, other.libStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.logStoreLocation, other.logStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.tempStoreLocation, other.tempStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.cacheStoreLocation, other.cacheStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.runStoreLocation, other.runStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.groups, other.groups)) {
            return false;
        }
        if (!Objects.equals(this.authenticationAgent, other.authenticationAgent)) {
            return false;
        }
        if (this.storeLocationStrategy != other.storeLocationStrategy) {
            return false;
        }
        if (!Objects.equals(this.env, other.env)) {
            return false;
        }
        if (!Objects.equals(this.mirrors, other.mirrors)) {
            return false;
        }
        return Objects.equals(this.users, other.users);
    }

    public String toString() {
        return "NutsRepositoryConfig507{uuid=" + this.uuid + ", name=" + this.name + ", type=" + this.type + ", location=" + this.location + ", programsStoreLocation=" + this.programsStoreLocation + ", configStoreLocation=" + this.configStoreLocation + ", varStoreLocation=" + this.varStoreLocation + ", libStoreLocation=" + this.libStoreLocation + ", logStoreLocation=" + this.logStoreLocation + ", tempStoreLocation=" + this.tempStoreLocation + ", cacheStoreLocation=" + this.cacheStoreLocation + ", runStoreLocation=" + this.runStoreLocation + ", storeLocationStrategy=" + this.storeLocationStrategy + ", groups=" + this.groups + ", env=" + this.env + ", mirrors=" + this.mirrors + ", users=" + this.users + ", indexEnabled=" + this.indexEnabled + ", authenticationAgent=" + this.authenticationAgent + '}';
    }

    public NRepositoryConfig toRepositoryConfig() {
        NRepositoryConfig c = new NRepositoryConfig();
        c.setConfigVersion(CONFIG_VERSION_502);
        c.setAuthenticationAgent(this.authenticationAgent);
        c.setEnv(this.env);
        c.setGroups(this.groups);
        c.setIndexEnabled(this.indexEnabled);
        c.setMirrors(this.mirrors);
        c.setName(this.name);
        c.setStoreStrategy(this.storeLocationStrategy);
        NRepositoryLocation loc = NRepositoryLocation.of(this.location);
        if (!NBlankable.isBlank(this.type)) {
            loc = loc.setLocationType(this.type);
        }
        c.setLocation(NRepositoryLocation.of(loc.toString()));
        c.setStoreLocations(new NStoreLocationsMap(null).set(NStoreType.BIN, this.programsStoreLocation).set(NStoreType.CONF, this.configStoreLocation).set(NStoreType.VAR, this.varStoreLocation).set(NStoreType.LOG, this.logStoreLocation).set(NStoreType.TEMP, this.tempStoreLocation).set(NStoreType.CACHE, this.cacheStoreLocation).set(NStoreType.LIB, this.libStoreLocation).toMap());
        return c;
    }
}

