/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config.compat;

import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.v502.NVersionCompat502;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.v506.NVersionCompat506;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.v507.NVersionCompat507;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.v803.NVersionCompat803;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.v805.NVersionCompat805;

public interface NVersionCompat {
    public static NVersionCompat of(NVersion apiVersion) {
        int buildNumber = CoreNUtils.getApiVersionOrdinalNumber(apiVersion);
        if (buildNumber >= 805) {
            return new NVersionCompat805(apiVersion);
        }
        if (buildNumber >= 803) {
            return new NVersionCompat803(apiVersion);
        }
        if (buildNumber >= 507) {
            return new NVersionCompat507(apiVersion);
        }
        if (buildNumber >= 506) {
            return new NVersionCompat506(apiVersion);
        }
        return new NVersionCompat502(apiVersion);
    }

    public NWorkspaceConfigBoot parseConfig(byte[] var1);

    public NWorkspaceConfigApi parseApiConfig(NId var1);

    public NWorkspaceConfigRuntime parseRuntimeConfig();

    public NWorkspaceConfigSecurity parseSecurityConfig(NId var1);

    public NWorkspaceConfigMain parseMainConfig(NId var1);
}

