/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.Map;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NLocationKey;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NStoreLocationsMap;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNWorkspaceLocationModel {
    private final NWorkspace workspace;
    private final NPath workspaceLocation;

    public DefaultNWorkspaceLocationModel(NWorkspace workspace, String workspaceLocation) {
        this.workspace = workspace;
        this.workspaceLocation = NPath.of(workspaceLocation);
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    private DefaultNWorkspaceConfigModel cfg() {
        return ((DefaultNWorkspace)this.workspace).getConfigModel();
    }

    public void setHomeLocation(NHomeLocation homeType, String location) {
        this.cfg().onPreUpdateConfig("home-location");
        this.cfg().getStoreModelBoot().setHomeLocations(new NHomeLocationsMap(this.cfg().getStoreModelBoot().getHomeLocations()).set(homeType, location).toMapOrNull());
        this.cfg().onPostUpdateConfig("home-location");
    }

    public NPath getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public NPath getHomeLocation(NStoreType folderType) {
        return this.cfg().current().getHomeLocation(folderType);
    }

    public NPath getStoreLocation(NStoreType folderType) {
        try {
            return this.cfg().current().getStoreLocation(folderType);
        }
        catch (IllegalStateException stillInitializing) {
            NBootOptions info = NWorkspaceExt.of().getModel().bootModel.getBootUserOptions();
            String h = info.getStoreType(folderType).orNull();
            return h == null ? null : NPath.of(h);
        }
    }

    public void setStoreLocation(NStoreType folderType, String location) {
        NAssert.requireNonNull(folderType, "store root folder");
        this.cfg().onPreUpdateConfig("store-location");
        this.cfg().getStoreModelBoot().setStoreLocations(new NStoreLocationsMap(this.cfg().getStoreModelBoot().getStoreLocations()).set(folderType, location).toMapOrNull());
        this.cfg().onPostUpdateConfig("store-location");
    }

    public void setStoreStrategy(NStoreStrategy strategy) {
        if (strategy == null) {
            strategy = NStoreStrategy.EXPLODED;
        }
        this.cfg().onPreUpdateConfig("store-strategy");
        this.cfg().getStoreModelBoot().setStoreStrategy(strategy);
        this.cfg().onPostUpdateConfig("store-strategy");
    }

    public void setStoreLayout(NOsFamily layout) {
        this.cfg().onPreUpdateConfig("store-layout");
        this.cfg().getStoreModelBoot().setStoreLayout(layout);
        this.cfg().onPostUpdateConfig("store-layout");
    }

    public NPath getStoreLocation(NStoreType folderType, String repositoryIdOrName) {
        if (repositoryIdOrName == null) {
            return this.getStoreLocation(folderType);
        }
        NRepository repositoryById = this.workspace.findRepository(repositoryIdOrName).get();
        NRepositorySPI nRepositorySPI = NWorkspaceUtils.of().toRepositorySPI(repositoryById);
        return nRepositorySPI.config().getStoreLocation(folderType);
    }

    public NPath getStoreLocation(NLocationKey locationKey) {
        NPath u = this.getStoreLocation(locationKey.getId(), locationKey.getStoreType(), locationKey.getRepoUuid());
        if (!NBlankable.isBlank(locationKey.getName())) {
            u = u.resolve(locationKey.getName());
        }
        return u;
    }

    public NPath getStoreLocation(NId id, NStoreType folderType, String repositoryIdOrName) {
        if (repositoryIdOrName == null) {
            return this.getStoreLocation(id, folderType);
        }
        NPath storeLocation = this.getStoreLocation(folderType, repositoryIdOrName);
        return storeLocation.resolve("id").resolve(this.getDefaultIdBasedir(id));
    }

    public NPath getStoreLocation(NId id, NStoreType folderType) {
        NPath storeLocation = this.getStoreLocation(folderType);
        if (storeLocation == null) {
            return null;
        }
        return storeLocation.resolve("id").resolve(this.getDefaultIdBasedir(id));
    }

    public NStoreStrategy getStoreStrategy() {
        return this.cfg().current().getStoreStrategy();
    }

    public NStoreStrategy getRepositoryStoreStrategy() {
        return this.cfg().current().getRepositoryStoreStrategy();
    }

    public NOsFamily getStoreLayout() {
        return this.cfg().current().getStoreLayout();
    }

    public Map<NStoreType, String> getStoreLocations() {
        return this.cfg().current().getStoreLocations();
    }

    public Map<NHomeLocation, String> getHomeLocations() {
        return this.cfg().current().getHomeLocations();
    }

    public NPath getHomeLocation(NHomeLocation location) {
        return this.cfg().current().getHomeLocation(location);
    }

    public NPath getDefaultIdBasedir(NId id) {
        CoreNIdUtils.checkShortId(id);
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        String plainIdPath = groupId.replace('.', '/') + "/" + artifactId;
        if (id.getVersion().isBlank()) {
            return NPath.of(plainIdPath);
        }
        String version = id.getVersion().getValue();
        String x = plainIdPath + "/" + version;
        return NPath.of(x);
    }

    public String getDefaultIdFilename(NId id) {
        String c;
        String classifier = "";
        String ext = this.getDefaultIdExtension(id);
        if (!(ext.equals(".nuts") || ext.equals(".pom") || NBlankable.isBlank(c = id.getClassifier()))) {
            classifier = "-" + c;
        }
        return id.getArtifactId() + "-" + id.getVersion().getValue() + classifier + ext;
    }

    public String getDefaultIdContentExtension(String packaging) {
        NAssert.requireNonBlank(packaging, "packaging");
        switch (packaging) {
            case "jar": 
            case "bundle": 
            case "nuts-extension": 
            case "maven-archetype": 
            case "maven-plugin": 
            case "ejb-client": 
            case "test-jar": 
            case "ejb": 
            case "java-source": 
            case "javadoc": 
            case "eclipse-plugin": 
            case "orbit": {
                return ".jar";
            }
            case "dll": 
            case "so": 
            case "jnilib": {
                return "-natives.jar";
            }
            case "war": {
                return ".war";
            }
            case "ear": {
                return ".ear";
            }
            case "pom": {
                return ".pom";
            }
            case "nuts": {
                return ".nuts";
            }
            case "rar": {
                return ".rar";
            }
            case "zip": 
            case "nbm-application": {
                return ".zip";
            }
            case "gz": {
                return ".gz";
            }
            case "targz": 
            case "tar.gz": {
                return ".tar.gz";
            }
        }
        return "." + packaging;
    }

    public String getDefaultIdExtension(NId id) {
        String f;
        Map<String, String> q = id.getProperties();
        switch (f = NStringUtils.trim(q.get("face"))) {
            case "descriptor": {
                return ".nuts";
            }
            case "descriptor-hash": {
                return ".nuts.sha1";
            }
            case "catalog": {
                return ".catalog";
            }
            case "content-hash": {
                return this.getDefaultIdExtension(id.builder().setFaceContent().build()) + ".sha1";
            }
            case "content": {
                return this.getDefaultIdContentExtension(q.get("packaging"));
            }
        }
        if (f.equals("cache") || f.endsWith(".cache")) {
            return "." + f;
        }
        NAssert.requireNonBlank(f, () -> NMsg.ofC("missing face in %s", id));
        throw new NIllegalArgumentException(NMsg.ofC("unsupported face %s in %s", f, id));
    }
}

