/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NArchFamily;
import net.thevpc.nuts.platform.NDesktopEnvironmentFamily;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.app.gui.CoreNUtilGui;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.util.jclass.NJavaSdkUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NDefaultObservableMap;
import net.thevpc.nuts.util.NObservableMap;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNWorkspaceEnvManagerModel {
    private final Map<NPlatformFamily, List<NPlatformLocation>> configPlatforms = new LinkedHashMap<NPlatformFamily, List<NPlatformLocation>>();
    protected NObservableMap<String, Object> userProperties;
    private final NWorkspace workspace;
    private final NId platform;
    private final NId os;
    private NOsFamily osFamily;
    private String hostName;
    private String pid;
    private NShellFamily shellFamily;
    private Set<NId> desktopEnvironments;
    private Set<NDesktopEnvironmentFamily> osDesktopEnvironmentFamilies;
    private NDesktopEnvironmentFamily osDesktopEnvironmentFamily;
    private final NId arch;
    private final NId osDist;
    private final NArchFamily archFamily = NArchFamily.getCurrent();

    public DefaultNWorkspaceEnvManagerModel(NWorkspace ws) {
        this.workspace = ws;
        this.userProperties = new NDefaultObservableMap<String, Object>();
        this.os = NId.get(CorePlatformUtils.getPlatformOs()).get();
        NId platformOsDist = CorePlatformUtils.getPlatformOsDist();
        if (platformOsDist == null) {
            platformOsDist = NId.of("default");
        }
        this.osDist = platformOsDist;
        this.platform = NJavaSdkUtils.of(ws).createJdkId(System.getProperty("java.version"));
        this.arch = NId.get(System.getProperty("os.arch")).get();
    }

    public NId getArch() {
        return this.arch;
    }

    public NArchFamily getArchFamily() {
        return this.archFamily;
    }

    public String getPid() {
        if (this.pid == null) {
            String fallback = "";
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            int index = jvmName.indexOf(64);
            if (index < 1) {
                this.pid = fallback;
                return this.pid;
            }
            try {
                this.pid = String.valueOf(Long.toString(Long.parseLong(jvmName.substring(0, index))));
                return this.pid;
            }
            catch (NumberFormatException numberFormatException) {
                this.pid = fallback;
                return this.pid;
            }
        }
        return this.pid;
    }

    public String getHostName() {
        if (this.hostName == null) {
            switch (this.getOsFamily()) {
                case WINDOWS: {
                    String computername = NWorkspace.of().getSysEnv("COMPUTERNAME").orNull();
                    if (computername != null) {
                        this.hostName = computername;
                    } else {
                        try {
                            String hostname = NExecCmd.of().addCommand("hostname").failFast().getGrabbedOutOnlyString();
                            this.hostName = NStringUtils.trim(hostname);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.hostName != null) break;
                    this.hostName = "";
                    break;
                }
                default: {
                    String h = null;
                    try {
                        h = NStringUtils.trim(NPath.of("/etc/hostname").readString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (NBlankable.isBlank(h)) {
                        h = NExecCmd.of().system().addCommand("/bin/hostname").getGrabbedOutOnlyString();
                    }
                    this.hostName = NStringUtils.trim(h);
                    break;
                }
            }
        }
        return this.hostName;
    }

    public NOsFamily getOsFamily() {
        if (this.osFamily == null) {
            this.osFamily = NOsFamily.getCurrent();
        }
        return this.osFamily;
    }

    public NShellFamily getShellFamily() {
        if (this.shellFamily == null) {
            this.shellFamily = NShellFamily.getCurrent();
        }
        return this.shellFamily;
    }

    public Set<NShellFamily> getShellFamilies() {
        return this.getShellFamilies(true);
    }

    public Set<NShellFamily> getShellFamilies(boolean allEvenNonInstalled) {
        ArrayList shellFamilies = new ArrayList();
        switch (this.getOsFamily()) {
            case UNIX: 
            case LINUX: 
            case MACOS: {
                NShellFamily[] all;
                LinkedHashSet<NShellFamily> families = new LinkedHashSet<NShellFamily>();
                families.add(this.getShellFamily());
                for (NShellFamily f : all = new NShellFamily[]{NShellFamily.SH, NShellFamily.BASH, NShellFamily.ZSH, NShellFamily.CSH, NShellFamily.KSH, NShellFamily.FISH}) {
                    Path path;
                    if (f == null || !Files.exists(path = Paths.get("/bin", new String[0]).resolve(f.id()), new LinkOption[0])) continue;
                    families.add(f);
                }
                if (allEvenNonInstalled) {
                    families.addAll(Arrays.asList(all));
                }
                shellFamilies.addAll(families);
                break;
            }
            case WINDOWS: {
                LinkedHashSet<NShellFamily> families = new LinkedHashSet<NShellFamily>();
                families.add(this.getShellFamily());
                families.add(NShellFamily.WIN_CMD);
                if (this.getOs().getVersion().compareTo("7") >= 0) {
                    families.add(NShellFamily.WIN_POWER_SHELL);
                }
                shellFamilies.addAll(families);
                break;
            }
            default: {
                shellFamilies.add(NShellFamily.UNKNOWN);
            }
        }
        return new LinkedHashSet<NShellFamily>(shellFamilies);
    }

    public Set<NId> getDesktopEnvironments() {
        if (this.desktopEnvironments == null) {
            this.desktopEnvironments = this.getDesktopEnvironments0();
        }
        return this.desktopEnvironments;
    }

    public boolean isGraphicalDesktopEnvironment() {
        return CoreNUtilGui.isGraphicalDesktopEnvironment();
    }

    protected NId[] getDesktopEnvironmentsXDGOrEmpty() {
        NWorkspace ws = NWorkspace.of();
        String _XDG_SESSION_DESKTOP = ws.getSysEnv("XDG_SESSION_DESKTOP").orNull();
        String _XDG_CURRENT_DESKTOP = ws.getSysEnv("XDG_CURRENT_DESKTOP").orNull();
        ArrayList<NId> a = new ArrayList<NId>();
        if (!NBlankable.isBlank(_XDG_SESSION_DESKTOP) && !NBlankable.isBlank(_XDG_SESSION_DESKTOP)) {
            String[] supportedSessions = new LinkedHashSet(Arrays.stream(NStringUtils.trim(_XDG_CURRENT_DESKTOP).split(":")).map(x -> x.trim().toLowerCase()).filter(x -> x.length() > 0).collect(Collectors.toList())).toArray(new String[0]);
            String sd = _XDG_SESSION_DESKTOP.toLowerCase();
            for (int i = 0; i < supportedSessions.length; ++i) {
                NIdBuilder nb = NIdBuilder.of().setArtifactId(supportedSessions[i]);
                if ("kde".equals(sd)) {
                    String _KDE_FULL_SESSION = ws.getSysEnv("KDE_FULL_SESSION").orNull();
                    String _KDE_SESSION_VERSION = ws.getSysEnv("KDE_SESSION_VERSION").orNull();
                    if (_KDE_FULL_SESSION != null && "true".equals(_KDE_FULL_SESSION.trim())) {
                        nb.setProperty("full", "true");
                    }
                    if (_KDE_SESSION_VERSION != null) {
                        nb.setProperty("version", _KDE_SESSION_VERSION.trim());
                    }
                }
                String _XDG_SESSION_TYPE = ws.getSysEnv("XDG_SESSION_TYPE").orNull();
                String _XSESSION_IS_UP = ws.getSysEnv("XSESSION_IS_UP").orNull();
                String _XDG_SESSION_CLASS = ws.getSysEnv("XDG_SESSION_CLASS").orNull();
                if (_XDG_SESSION_TYPE != null) {
                    nb.setProperty("type", _XDG_SESSION_TYPE.trim().toLowerCase());
                }
                if (_XDG_SESSION_CLASS != null) {
                    nb.setProperty("class", _XDG_SESSION_CLASS.trim().toLowerCase());
                }
                a.add(nb.build());
            }
        }
        return a.toArray(new NId[0]);
    }

    protected Set<NId> getDesktopEnvironments0() {
        if (!this.isGraphicalDesktopEnvironment()) {
            return Collections.singleton(NIdBuilder.of().setArtifactId(NDesktopEnvironmentFamily.HEADLESS.id()).build());
        }
        switch (NWorkspace.of().getOsFamily()) {
            case WINDOWS: {
                return Collections.singleton(NIdBuilder.of().setArtifactId(NDesktopEnvironmentFamily.WINDOWS_SHELL.id()).build());
            }
            case MACOS: {
                return Collections.singleton(NIdBuilder.of().setArtifactId(NDesktopEnvironmentFamily.MACOS_AQUA.id()).build());
            }
            case UNIX: 
            case LINUX: {
                NId[] all = this.getDesktopEnvironmentsXDGOrEmpty();
                if (all.length == 0) {
                    return Collections.singleton(NIdBuilder.of().setArtifactId(NDesktopEnvironmentFamily.UNKNOWN.id()).build());
                }
                return Collections.unmodifiableSet(new LinkedHashSet<NId>(Arrays.asList(all)));
            }
        }
        return Collections.singleton(NIdBuilder.of().setArtifactId(NDesktopEnvironmentFamily.UNKNOWN.id()).build());
    }

    public Set<NDesktopEnvironmentFamily> getDesktopEnvironmentFamilies() {
        if (this.osDesktopEnvironmentFamilies == null) {
            this.osDesktopEnvironmentFamilies = this.getDesktopEnvironmentFamilies0();
        }
        return this.osDesktopEnvironmentFamilies;
    }

    public Set<NDesktopEnvironmentFamily> getDesktopEnvironmentFamilies0() {
        Set<NId> desktopEnvironments = this.getDesktopEnvironments();
        LinkedHashSet<NDesktopEnvironmentFamily> all = new LinkedHashSet<NDesktopEnvironmentFamily>();
        for (NId desktopEnvironment : desktopEnvironments) {
            all.add(NDesktopEnvironmentFamily.parse(desktopEnvironment.getShortName()).orNull());
        }
        return new LinkedHashSet<NDesktopEnvironmentFamily>(all);
    }

    public NDesktopEnvironmentFamily getDesktopEnvironmentFamily() {
        if (this.osDesktopEnvironmentFamily == null) {
            this.osDesktopEnvironmentFamily = this.getDesktopEnvironmentFamily0();
        }
        return this.osDesktopEnvironmentFamily;
    }

    public NDesktopEnvironmentFamily getDesktopEnvironmentFamily0() {
        Set<NDesktopEnvironmentFamily> all = this.getDesktopEnvironmentFamilies();
        if (all.size() == 0) {
            return NDesktopEnvironmentFamily.UNKNOWN;
        }
        boolean unknown = false;
        boolean none = false;
        boolean headless = false;
        block5: for (NDesktopEnvironmentFamily f : all) {
            switch (f) {
                case UNKNOWN: {
                    unknown = true;
                    continue block5;
                }
                case HEADLESS: {
                    headless = true;
                    continue block5;
                }
                case NONE: {
                    none = true;
                    continue block5;
                }
            }
            return f;
        }
        if (headless) {
            return NDesktopEnvironmentFamily.HEADLESS;
        }
        if (none) {
            return NDesktopEnvironmentFamily.NONE;
        }
        if (unknown) {
            return NDesktopEnvironmentFamily.UNKNOWN;
        }
        return NDesktopEnvironmentFamily.UNKNOWN;
    }

    public NId getOs() {
        return this.os;
    }

    public NId getPlatform() {
        return this.platform;
    }

    public NId getOsDist() {
        return this.osDist;
    }

    public Map<String, Object> getProperties() {
        return this.userProperties;
    }

    public NOptional<Object> getProperty(String property) {
        Object v = this.userProperties.get(property);
        return NOptional.ofNamed(v, property);
    }

    public <T> T getOrCreateProperty(Class<T> property, Supplier<T> supplier) {
        return this.getOrCreateProperty(property.getName(), supplier);
    }

    public synchronized <T> T getOrCreateProperty(String property, Supplier<T> supplier) {
        Object o = this.getProperty(property).orNull();
        if (o != null) {
            return (T)o;
        }
        o = supplier.get();
        this.setProperty(property, o);
        return (T)o;
    }

    public void setProperty(String property, Object value) {
        if (value == null) {
            this.userProperties.remove(property);
        } else {
            this.userProperties.put(property, value);
        }
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    public Map<NPlatformFamily, List<NPlatformLocation>> getConfigPlatforms() {
        return this.configPlatforms;
    }
}

