/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaClassUtils;
import net.thevpc.nuts.runtime.standalone.util.jclass.NJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceEnvManagerModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NPlatformLocationSelectComparator;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStream;

public class DefaultNPlatformModel {
    private NWorkspace workspace;
    private DefaultNWorkspaceEnvManagerModel model;

    public DefaultNPlatformModel(DefaultNWorkspaceEnvManagerModel model) {
        this.workspace = model.getWorkspace();
        this.model = model;
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    public boolean addPlatform(NPlatformLocation location) {
        return this.add0(location, true);
    }

    public boolean add0(NPlatformLocation location, boolean notify) {
        NSession session = this.getWorkspace().currentSession();
        if (location != null) {
            NAssert.requireNonBlank(location.getProduct(), "platform location product");
            NAssert.requireNonBlank(location.getName(), "platform location product");
            NAssert.requireNonBlank(location.getVersion(), "platform location version");
            NAssert.requireNonBlank(location.getVersion(), "platform location path");
            List<NPlatformLocation> list = this.getPlatforms().get(location.getPlatformType());
            if (list == null) {
                list = new ArrayList<NPlatformLocation>();
                this.model.getConfigPlatforms().put(location.getPlatformType(), list);
            }
            NPlatformLocation old = null;
            for (NPlatformLocation nutsPlatformLocation : list) {
                if (!Objects.equals(nutsPlatformLocation.getPackaging(), location.getPackaging()) || !Objects.equals(nutsPlatformLocation.getProduct(), location.getProduct()) || !nutsPlatformLocation.getName().equals(location.getName()) && !nutsPlatformLocation.getPath().equals(location.getPath())) continue;
                old = nutsPlatformLocation;
                break;
            }
            if (old != null) {
                return false;
            }
            list.add(location);
            if (notify) {
                if (session.isPlainTrace()) {
                    NOut.resetLine().println(NMsg.ofC("%s %s %s (%s) %s at %s", NText.ofStyledSuccess("install"), location.getId().getShortName(), location.getPackaging(), location.getProduct(), NVersion.get(location.getVersion()).get(), NPath.of(location.getPath())));
                }
                NWorkspaceExt.of(this.workspace).getConfigModel().fireConfigurationChanged("platform", ConfigEventType.MAIN);
            }
            return true;
        }
        return false;
    }

    public boolean updatePlatform(NPlatformLocation oldLocation, NPlatformLocation newLocation) {
        boolean updated = false;
        updated |= this.removePlatform(oldLocation);
        updated |= this.removePlatform(newLocation);
        return updated |= this.addPlatform(newLocation);
    }

    public boolean removePlatform(NPlatformLocation location) {
        List<NPlatformLocation> list;
        if (location != null && (list = this.getPlatforms().get(location.getPlatformType())) != null && list.remove(location)) {
            NWorkspaceExt.of(this.workspace).getConfigModel().fireConfigurationChanged("platform", ConfigEventType.MAIN);
            return true;
        }
        return false;
    }

    public NOptional<NPlatformLocation> findPlatformByName(NPlatformFamily type, String locationName) {
        return this.findOnePlatform(type, location -> location.getName().equals(locationName));
    }

    public NOptional<NPlatformLocation> findPlatformByPath(NPlatformFamily type, NPath path) {
        NAssert.requireNonNull(path, "path");
        return this.findOnePlatform(type, location -> location.getPath() != null && location.getPath().equals(path.toString()));
    }

    public NOptional<NPlatformLocation> findPlatformByVersion(NPlatformFamily type, String version) {
        return this.findOnePlatform(type, location -> location.getVersion().equals(version));
    }

    public NOptional<NPlatformLocation> findPlatform(NPlatformLocation location) {
        if (location == null) {
            return NOptional.ofNamedEmpty(NMsg.ofC("platform %s", location));
        }
        String type = location.getId().getArtifactId();
        NPlatformFamily ftype = NPlatformFamily.parse(type).orElse(NPlatformFamily.JAVA);
        List<NPlatformLocation> list = this.getPlatforms().get(ftype);
        if (list != null) {
            for (NPlatformLocation location2 : list) {
                if (!location2.equals(location)) continue;
                return NOptional.of(location2);
            }
        }
        return NOptional.ofNamedEmpty(NMsg.ofC("platform %s", location));
    }

    public NOptional<NPlatformLocation> findPlatformByVersion(NPlatformFamily type, NVersionFilter versionFilter) {
        return this.findOnePlatform(type, location -> {
            String sVersion2;
            NVersion version2;
            NLiteral p;
            int a;
            if (versionFilter == null) {
                return true;
            }
            String sVersion = location.getVersion();
            NVersion version = NVersion.get(sVersion).get();
            if (versionFilter.acceptVersion(version)) {
                return true;
            }
            return (type == NPlatformFamily.JAVA || location.getPlatformType() == NPlatformFamily.JAVA) && (a = sVersion.indexOf(46)) > 0 && (p = NLiteral.of(sVersion.substring(0, a))).asInt().isPresent() && p.asInt().get() == 1 && versionFilter.acceptVersion(version2 = NVersion.get(sVersion2 = sVersion.substring(a + 1)).get());
        });
    }

    public NStream<NPlatformLocation> searchSystemPlatforms(NPlatformFamily platformType) {
        if (platformType == NPlatformFamily.JAVA) {
            try {
                return NStream.ofArray(NJavaSdkUtils.of(this.workspace).searchJdkLocationsFuture().get());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return NStream.ofEmpty();
    }

    public NStream<NPlatformLocation> searchSystemPlatforms(NPlatformFamily platformType, NPath path) {
        if (platformType == NPlatformFamily.JAVA) {
            return NStream.ofArray(NJavaSdkUtils.of(this.workspace).searchJdkLocations(path));
        }
        return NStream.ofEmpty();
    }

    public NOptional<NPlatformLocation> resolvePlatform(NPlatformFamily platformType, NPath path, String preferredName) {
        if (platformType == NPlatformFamily.JAVA) {
            NPlatformLocation z = NJavaSdkUtils.of(this.workspace).resolveJdkLocation(path, preferredName);
            if (z == null) {
                return NOptional.ofNamedEmpty(NMsg.ofC("%s platform at %s", platformType.id(), path));
            }
            return NOptional.of(z);
        }
        return NOptional.ofNamedEmpty(NMsg.ofC("%s platform at %s", platformType.id(), path));
    }

    public void setPlatforms(NPlatformLocation[] locations) {
        this.model.getConfigPlatforms().clear();
        for (NPlatformLocation platform : locations) {
            this.add0(platform, false);
        }
    }

    public NOptional<NPlatformLocation> findOnePlatform(NPlatformFamily type, Predicate<NPlatformLocation> filter) {
        NPlatformLocation[] a = (NPlatformLocation[])this.findPlatforms(type, filter).toArray(NPlatformLocation[]::new);
        if (a.length == 0) {
            return NOptional.ofNamedEmpty(type.id() + " platform");
        }
        if (a.length == 1) {
            NPlatformLocation r = a[0];
            if (r == null) {
                return NOptional.ofNamedEmpty(type.id() + " platform");
            }
            return NOptional.of(r);
        }
        NPlatformLocation best = a[0];
        for (int i = 1; i < a.length; ++i) {
            NVersion v1 = NVersion.get(best.getVersion()).get();
            NVersion v2 = NVersion.get(a[i].getVersion()).get();
            if (type == NPlatformFamily.JAVA) {
                double d2;
                double d1 = Double.parseDouble(JavaClassUtils.sourceVersionToClassVersion(v1.getValue()));
                if (d1 == (d2 = Double.parseDouble(JavaClassUtils.sourceVersionToClassVersion(v2.getValue())))) {
                    if (v1.compareTo(v2) >= 0) continue;
                    best = a[i];
                    continue;
                }
                if (v1.compareTo(v2) <= 0) continue;
                best = a[i];
                continue;
            }
            if (v1.compareTo(v2) <= 0) continue;
            best = a[i];
        }
        if (best == null) {
            return NOptional.ofNamedEmpty(type.id() + " platform");
        }
        return NOptional.of(best);
    }

    public NStream<NPlatformLocation> findPlatforms(NPlatformFamily type, Predicate<NPlatformLocation> filter) {
        NSession session = this.getWorkspace().currentSession();
        if (filter == null) {
            if (type == null) {
                ArrayList<NPlatformLocation> all = new ArrayList<NPlatformLocation>();
                for (List<NPlatformLocation> value : this.model.getConfigPlatforms().values()) {
                    all.addAll(value);
                }
                return NStream.ofIterable(all);
            }
            List<NPlatformLocation> list = this.getPlatforms().get(type);
            if (list == null) {
                return NStream.ofEmpty();
            }
            return NStream.ofIterable(list);
        }
        ArrayList<NPlatformLocation> ret = new ArrayList<NPlatformLocation>();
        if (type == null) {
            for (List<NPlatformLocation> found : this.getPlatforms().values()) {
                for (NPlatformLocation location : found) {
                    if (!filter.test(location)) continue;
                    ret.add(location);
                }
            }
        } else {
            List<NPlatformLocation> found = this.getPlatforms().get(type);
            if (found != null) {
                for (NPlatformLocation location : found) {
                    if (!filter.test(location)) continue;
                    ret.add(location);
                }
            }
        }
        if (!ret.isEmpty()) {
            ret.sort(new NPlatformLocationSelectComparator());
        }
        return NStream.ofIterable(ret);
    }

    public Map<NPlatformFamily, List<NPlatformLocation>> getPlatforms() {
        return this.model.getConfigPlatforms();
    }
}

