/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NIndexStore;
import net.thevpc.nuts.core.NIndexerNotAccessibleException;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionFilterToNIdPredicate2;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.AbstractNIndexStore;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class DefaultNIndexStore
extends AbstractNIndexStore {
    public DefaultNIndexStore(NRepository repository) {
        super(repository);
    }

    @Override
    public NIterator<NId> searchVersions(NId id) {
        return NIteratorBuilder.ofSupplier(() -> {
            if (this.isInaccessible()) {
                return NIteratorBuilder.emptyIterator();
            }
            String uu = this.getIndexURL().resolve("id").resolve("allVersions") + String.format("?repositoryUuid=%s&name=%s&repo=%s&group=%s&os=%s&osdist=%s&arch=%s&face=%s&", this.getRepository().getUuid(), NStringUtils.trim(id.getArtifactId()), NStringUtils.trim(id.getRepository()), NStringUtils.trim(id.getGroupId()), NStringUtils.trim(String.join((CharSequence)",", id.getCondition().getOs())), NStringUtils.trim(String.join((CharSequence)",", id.getCondition().getOsDist())), NStringUtils.trim(String.join((CharSequence)",", id.getCondition().getArch())), NStringUtils.trim(id.getFace()));
            try {
                Map[] array = NElementParser.ofJson().parse(new InputStreamReader(NPath.of(uu).getInputStream()), Map[].class);
                return Arrays.stream(array).map(s -> NId.get(s.get("stringId").toString()).get()).collect(Collectors.toList()).iterator();
            }
            catch (UncheckedIOException | NIOException e) {
                this.setInaccessible();
                return NIteratorBuilder.emptyIterator();
            }
        }, () -> NElement.ofUpletBuilder().name("SearchIndexVersionsAt").add(this.getIndexURL().resolve("id").resolve("allVersions").toString()).build()).build();
    }

    @Override
    public NIterator<NId> search(NDefinitionFilter filter) {
        return NIteratorBuilder.ofSupplier(() -> {
            if (this.isInaccessible()) {
                throw new NIndexerNotAccessibleException(NMsg.ofC("index search failed for %s", this.getRepository().getName()));
            }
            String uu = this.getIndexURL().resolve("id") + "?repositoryUuid=" + this.getRepository().getUuid();
            try {
                Map[] array = NElementParser.ofJson().parse(new InputStreamReader(NPath.of(uu).getInputStream()), Map[].class);
                return Arrays.stream(array).map(s -> NId.get(s.get("stringId").toString()).get()).filter(new NDefinitionFilterToNIdPredicate2(filter)).iterator();
            }
            catch (UncheckedIOException | NIOException e) {
                this.setInaccessible();
                throw new NIndexerNotAccessibleException(NMsg.ofC("index search failed for %s", this.getRepository().getName()));
            }
        }, () -> NElement.ofObjectBuilder().name("SearchIndexPackages").set("source", this.getIndexURL().resolve("id").toString()).set("filter", NElementDescribables.describeResolveOrToString(filter)).build()).build();
    }

    private NPath getIndexURL() {
        return NPath.of("http://localhost:7070/indexer/");
    }

    @Override
    public NIndexStore invalidate(NId id) {
        if (this.isInaccessible()) {
            return this;
        }
        String uu = this.getIndexURL().resolve("id").resolve("delete") + String.format("?repositoryUuid=%s&name=%s&repo=%s&group=%s&version=%s&os=%s&osdist=%s&arch=%s&face=%s", this.getRepository().getUuid(), NStringUtils.trim(id.getArtifactId()), NStringUtils.trim(id.getRepository()), NStringUtils.trim(id.getGroupId()), NStringUtils.trim(id.getVersion().toString()), NStringUtils.trim(String.join((CharSequence)",", id.getCondition().getOs())), NStringUtils.trim(String.join((CharSequence)",", id.getCondition().getOsDist())), NStringUtils.trim(String.join((CharSequence)",", id.getCondition().getArch())), NStringUtils.trim(id.getFace()));
        try {
            NPath.of(uu).getInputStream();
        }
        catch (UncheckedIOException | NIOException e) {
            this.setInaccessible();
        }
        return this;
    }

    @Override
    public NIndexStore revalidate(NId id) {
        if (this.isInaccessible()) {
            return this;
        }
        String uu = this.getIndexURL().resolve("id").resolve("addData") + String.format("?repositoryUuid=%s&name=%s&repo=%s&group=%s&version=%s&os=%s&osdist=%s&arch=%s&face=%s", this.getRepository().getUuid(), NStringUtils.trim(id.getArtifactId()), NStringUtils.trim(id.getRepository()), NStringUtils.trim(id.getGroupId()), NStringUtils.trim(id.getVersion().toString()), NStringUtils.trim(String.join((CharSequence)",", id.getCondition().getOs())), NStringUtils.trim(String.join((CharSequence)",", id.getCondition().getOsDist())), NStringUtils.trim(String.join((CharSequence)",", id.getCondition().getArch())), NStringUtils.trim(id.getFace()));
        try {
            NPath.of(uu).getInputStream();
        }
        catch (UncheckedIOException | NIOException e) {
            this.setInaccessible();
        }
        return this;
    }

    @Override
    public NIndexStore subscribe() {
        String uu = "http://localhost:7070/indexer/subscription/subscribe?workspaceLocation=" + CoreIOUtils.urlEncodeString(NWorkspace.of().getWorkspaceLocation().toString()) + "&repositoryUuid=" + CoreIOUtils.urlEncodeString(this.getRepository().getUuid());
        try {
            NPath.of(uu).getInputStream();
        }
        catch (UncheckedIOException | NIOException e) {
            throw new NUnsupportedOperationException(NMsg.ofC("unable to subscribe for repository%s", this.getRepository().getName()), (Throwable)e);
        }
        return this;
    }

    @Override
    public NIndexStore unsubscribe() {
        String uu = "http://localhost:7070/indexer/subscription/unsubscribe?workspaceLocation=" + CoreIOUtils.urlEncodeString(NWorkspace.of().getWorkspaceLocation().toString()) + "&repositoryUuid=" + CoreIOUtils.urlEncodeString(this.getRepository().getUuid());
        try {
            NPath.of(uu).getInputStream();
        }
        catch (UncheckedIOException | NIOException e) {
            throw new NUnsupportedOperationException(NMsg.ofC("unable to unsubscribe for repository %s", this.getRepository().getName()), (Throwable)e);
        }
        return this;
    }

    @Override
    public boolean isSubscribed() {
        String uu = "http://localhost:7070/indexer/subscription/isSubscribed?workspaceLocation=" + CoreIOUtils.urlEncodeString(NWorkspace.of().getWorkspaceLocation().toString()) + "&repositoryUuid=" + CoreIOUtils.urlEncodeString(this.getRepository().getUuid());
        try {
            return new Scanner(NPath.of(uu).getInputStream()).nextBoolean();
        }
        catch (UncheckedIOException | NIOException e) {
            return false;
        }
    }
}

