/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;

public class DefaultImportModel {
    private NWorkspace workspace;
    private Set<String> cachedImports;

    public DefaultImportModel(NWorkspace ws) {
        this.workspace = ws;
    }

    public void invalidateCache() {
        this.cachedImports = null;
    }

    public Set<String> getCachedImports() {
        return this.cachedImports;
    }

    public void add(String[] importExpressions) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        if (this.getStoreModelMain().getImports() != null) {
            imports.addAll(this.getStoreModelMain().getImports());
        }
        if (importExpressions != null) {
            for (String importExpression : importExpressions) {
                if (importExpression == null) continue;
                for (String s : StringTokenizerUtils.splitDefault(importExpression)) {
                    imports.add(s.trim());
                }
            }
        }
        String[] arr = imports.toArray(new String[0]);
        this.set(arr);
    }

    public void removeAll() {
        this.set(null);
    }

    public void remove(String[] importExpressions) {
        if (this.getStoreModelMain().getImports() != null) {
            LinkedHashSet<String> imports = new LinkedHashSet<String>();
            for (String importExpression : this.getStoreModelMain().getImports()) {
                imports.addAll(this.parseImports(importExpression));
            }
            if (importExpressions != null) {
                for (String importExpression : importExpressions) {
                    imports.removeAll(this.parseImports(importExpression));
                }
            }
            String[] arr = imports.toArray(new String[0]);
            this.set(arr);
        }
    }

    public void set(String[] imports) {
        LinkedHashSet<String> simports = new LinkedHashSet<String>();
        if (imports != null) {
            for (String s : imports) {
                simports.addAll(this.parseImports(s));
            }
        }
        this.getStoreModelMain().setImports(new ArrayList<String>(simports));
        NWorkspaceExt.of(this.workspace).getConfigModel().fireConfigurationChanged("import", ConfigEventType.MAIN);
    }

    public boolean isImportedGroupId(String groupId) {
        return this.getAll().contains(groupId);
    }

    public Set<String> getAll() {
        if (this.cachedImports == null) {
            LinkedHashSet<String> all = new LinkedHashSet<String>();
            if (this.getStoreModelMain().getImports() != null) {
                all.addAll(this.getStoreModelMain().getImports());
            }
            this.cachedImports = Collections.unmodifiableSet(all);
            return this.cachedImports;
        }
        return this.cachedImports;
    }

    NWorkspaceConfigMain getStoreModelMain() {
        return ((DefaultNWorkspace)this.workspace).getConfigModel().getStoreModelMain();
    }

    protected Set<String> parseImports(String importExpression) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        if (importExpression != null) {
            for (String s : StringTokenizerUtils.splitDefault(importExpression)) {
                if (s.isEmpty()) continue;
                imports.add(s.trim());
            }
        }
        return imports;
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }
}

