/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NCommandConfig;
import net.thevpc.nuts.command.NCommandFactoryConfig;
import net.thevpc.nuts.command.NCustomCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceCmdFactory;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.internal.NInternalCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.CommandNWorkspaceCommandFactory;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ConfigNWorkspaceCommandFactory;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.alias.DefaultNCustomCommand;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigMain;
import net.thevpc.nuts.spi.NExecTargetSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;

public class DefaultCustomCommandsModel {
    private final ConfigNWorkspaceCommandFactory defaultCommandFactory;
    private final List<NWorkspaceCmdFactory> commandFactories = new ArrayList<NWorkspaceCmdFactory>();
    private NWorkspace workspace;
    private Map<String, NInternalCommand> internalCommands;

    public DefaultCustomCommandsModel(NWorkspace ws) {
        this.workspace = ws;
        this.defaultCommandFactory = new ConfigNWorkspaceCommandFactory();
    }

    protected NLog _LOG() {
        return NLog.of(DefaultCustomCommandsModel.class);
    }

    public void addFactory(NCommandFactoryConfig commandFactoryConfig) {
        if (commandFactoryConfig == null || commandFactoryConfig.getFactoryId() == null || commandFactoryConfig.getFactoryId().isEmpty() || !commandFactoryConfig.getFactoryId().trim().equals(commandFactoryConfig.getFactoryId())) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid WorkspaceCommandFactory %s", commandFactoryConfig));
        }
        for (NWorkspaceCmdFactory factory : this.commandFactories) {
            if (!commandFactoryConfig.getFactoryId().equals(factory.getFactoryId())) continue;
            throw new NIllegalArgumentException(NMsg.ofC("factory already registered : %s", factory.getFactoryId()));
        }
        CommandNWorkspaceCommandFactory f = null;
        if (NBlankable.isBlank(commandFactoryConfig.getFactoryType()) || "command".equals(commandFactoryConfig.getFactoryType().trim())) {
            f = new CommandNWorkspaceCommandFactory();
        }
        if (f != null) {
            f.configure(commandFactoryConfig);
            this.commandFactories.add(f);
        }
        Collections.sort(this.commandFactories, new Comparator<NWorkspaceCmdFactory>(){

            @Override
            public int compare(NWorkspaceCmdFactory o1, NWorkspaceCmdFactory o2) {
                return Integer.compare(o2.getPriority(), o1.getPriority());
            }
        });
        List<NCommandFactoryConfig> commandFactories = this.getStoreModelMain().getCommandFactories();
        if (commandFactories == null) {
            commandFactories = new ArrayList<NCommandFactoryConfig>();
            this.getStoreModelMain().setCommandFactories(commandFactories);
        }
        NCommandFactoryConfig oldCommandFactory = null;
        for (NCommandFactoryConfig commandFactory : commandFactories) {
            if (f != null && !commandFactory.getFactoryId().equals(f.getFactoryId())) continue;
            oldCommandFactory = commandFactory;
        }
        if (oldCommandFactory == null) {
            commandFactories.add(commandFactoryConfig);
        } else if (oldCommandFactory != commandFactoryConfig) {
            oldCommandFactory.setFactoryId(commandFactoryConfig.getFactoryId());
            oldCommandFactory.setFactoryType(commandFactoryConfig.getFactoryType());
            oldCommandFactory.setParameters((Map<String, String>)(commandFactoryConfig.getParameters() == null ? null : new LinkedHashMap<String, String>(commandFactoryConfig.getParameters())));
            oldCommandFactory.setPriority(commandFactoryConfig.getPriority());
        }
        NWorkspaceExt.of(this.workspace).getConfigModel().fireConfigurationChanged("command", ConfigEventType.MAIN);
    }

    public boolean removeFactoryIfExists(String factoryId) {
        return this.removeFactory(factoryId, false);
    }

    public void removeFactory(String factoryId) {
        this.removeFactory(factoryId, true);
    }

    public boolean commandFactoryExists(String factoryId) {
        if (factoryId == null || factoryId.isEmpty()) {
            return false;
        }
        Object removeMe = null;
        Object removeMeConfig = null;
        for (NWorkspaceCmdFactory factory : this.commandFactories) {
            if (!factoryId.equals(factory.getFactoryId())) continue;
            return true;
        }
        List<NCommandFactoryConfig> _commandFactories = this.getStoreModelMain().getCommandFactories();
        if (_commandFactories != null) {
            for (NCommandFactoryConfig commandFactory : _commandFactories) {
                if (!factoryId.equals(commandFactory.getFactoryId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean removeFactory(String factoryId, boolean error) {
        List<NCommandFactoryConfig> _commandFactories;
        if (factoryId == null || factoryId.isEmpty()) {
            if (!error) {
                return false;
            }
            throw new NIllegalArgumentException(NMsg.ofC("invalid WorkspaceCommandFactory %s", factoryId));
        }
        NWorkspaceCmdFactory removeMe = null;
        NCommandFactoryConfig removeMeConfig = null;
        Iterator<NWorkspaceCmdFactory> iterator = this.commandFactories.iterator();
        while (iterator.hasNext()) {
            NWorkspaceCmdFactory factory = iterator.next();
            if (!factoryId.equals(factory.getFactoryId())) continue;
            removeMe = factory;
            iterator.remove();
            NWorkspaceExt.of(this.workspace).getConfigModel().fireConfigurationChanged("command", ConfigEventType.MAIN);
            break;
        }
        if ((_commandFactories = this.getStoreModelMain().getCommandFactories()) != null) {
            Iterator<NCommandFactoryConfig> iterator2 = _commandFactories.iterator();
            while (iterator2.hasNext()) {
                NCommandFactoryConfig commandFactory = iterator2.next();
                if (!factoryId.equals(commandFactory.getFactoryId())) continue;
                removeMeConfig = commandFactory;
                iterator2.remove();
                NWorkspaceExt.of(this.workspace).getConfigModel().fireConfigurationChanged("command", ConfigEventType.MAIN);
                break;
            }
        }
        if (removeMe == null && removeMeConfig == null) {
            if (!error) {
                return false;
            }
            throw new NIllegalArgumentException(NMsg.ofC("command factory does not exists %s", factoryId));
        }
        return true;
    }

    public boolean add(NCommandConfig command) {
        if (command == null || NBlankable.isBlank(command.getName()) || command.getName().contains(" ") || command.getName().contains(".") || command.getName().contains("/") || command.getName().contains("\\") || command.getCommand() == null || command.getCommand().size() == 0) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid command %s", command == null ? "<NULL>" : command.getName()));
        }
        NCommandConfig oldCommand = this.defaultCommandFactory.findCommand(command.getName());
        this.find(command.getName());
        if (oldCommand != null) {
            if (oldCommand.equals(command)) {
                return false;
            }
            if (!NAsk.of().setDefaultValue(false).forBoolean(NMsg.ofC("override existing command %s ?", NText.ofStyled(command.getName(), NTextStyle.primary1()))).getBooleanValue().booleanValue()) {
                this.update(command);
                return true;
            }
            return false;
        }
        this.defaultCommandFactory.installCommand(command);
        NSession session = this.workspace.currentSession();
        if (session.isPlainTrace()) {
            NPrintStream out = session.getTerminal().out();
            NTexts text = NTexts.of();
            out.resetLine().println(NMsg.ofC("%s command %s", text.ofStyled("install", NTextStyle.success()), text.ofStyled(command.getName(), NTextStyle.primary3())));
        }
        return true;
    }

    public boolean update(NCommandConfig command) {
        if (command == null || NBlankable.isBlank(command.getName()) || command.getName().contains(" ") || command.getName().contains(".") || command.getName().contains("/") || command.getName().contains("\\") || command.getCommand() == null || command.getCommand().size() == 0) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid command %s", command == null ? "<NULL>" : command.getName()));
        }
        NCommandConfig oldCommand = this.defaultCommandFactory.findCommand(command.getName());
        if (oldCommand != null) {
            if (oldCommand.equals(command)) {
                return false;
            }
            this.defaultCommandFactory.uninstallCommand(command.getName());
            this.defaultCommandFactory.installCommand(command);
            NSession session = this.workspace.currentSession();
            if (session.isPlainTrace()) {
                NPrintStream out = session.getTerminal().out();
                NTexts text = NTexts.of();
                out.resetLine().println(NMsg.ofC("%s command %s", text.ofStyled("update ", NTextStyles.of(NTextStyle.success(), NTextStyle.underlined())), text.ofStyled(command.getName(), NTextStyle.primary3())));
            }
            return true;
        }
        throw new NIllegalArgumentException(NMsg.ofC("command not found %s", command.getName()));
    }

    public void remove(String name) {
        if (NBlankable.isBlank(name)) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid command : %s", name == null ? "<NULL>" : name));
        }
        NCommandConfig command = this.defaultCommandFactory.findCommand(name);
        if (command == null) {
            throw new NIllegalArgumentException(NMsg.ofC("command does not exists %s", name));
        }
        this.defaultCommandFactory.uninstallCommand(name);
        NSession session = this.workspace.currentSession();
        if (session.isPlainTrace()) {
            NPrintStream out = session.getTerminal().out();
            out.resetLine().println(NMsg.ofC("%s command %s", "uninstall", NText.ofStyled(name, NTextStyle.primary3())));
        }
    }

    NWorkspaceConfigMain getStoreModelMain() {
        return ((DefaultNWorkspace)this.workspace).getConfigModel().getStoreModelMain();
    }

    public NCustomCmd find(String name) {
        NCommandConfig c = this.defaultCommandFactory.findCommand(name);
        if (c == null) {
            NWorkspaceCmdFactory commandFactory;
            Iterator<NWorkspaceCmdFactory> iterator = this.commandFactories.iterator();
            while (iterator.hasNext() && (c = (commandFactory = iterator.next()).findCommand(name)) == null) {
            }
        }
        if (c == null) {
            return null;
        }
        return this.toDefaultNWorkspaceCommand(c);
    }

    public List<NCustomCmd> findAll() {
        HashMap<String, NCustomCmd> all = new HashMap<String, NCustomCmd>();
        for (NCommandConfig command : this.defaultCommandFactory.findCommands()) {
            all.put(command.getName(), this.toDefaultNWorkspaceCommand(command));
        }
        for (NWorkspaceCmdFactory commandFactory : this.commandFactories) {
            for (NCommandConfig command : commandFactory.findCommands()) {
                if (all.containsKey(command.getName())) continue;
                all.put(command.getName(), this.toDefaultNWorkspaceCommand(command));
            }
        }
        return new ArrayList<NCustomCmd>(all.values());
    }

    public List<NCustomCmd> findByOwner(NId id) {
        HashMap<String, NCustomCmd> all = new HashMap<String, NCustomCmd>();
        for (NCommandConfig command : this.defaultCommandFactory.findCommands(id)) {
            all.put(command.getName(), this.toDefaultNWorkspaceCommand(command));
        }
        return new ArrayList<NCustomCmd>(all.values());
    }

    private NCustomCmd toDefaultNWorkspaceCommand(NCommandConfig c) {
        if (c.getCommand() == null || c.getCommand().isEmpty()) {
            this._LOG().log(NMsg.ofC("invalid command definition '%s'. Missing command . Ignored", c.getName()).withLevel(Level.WARNING).withIntent(NMsgIntent.FAIL));
            return null;
        }
        return new DefaultNCustomCommand().setCommand(c.getCommand()).setFactoryId(c.getFactoryId()).setOwner(c.getOwner()).setExecutorOptions(c.getExecutorOptions()).setName(c.getName()).setHelpCommand(c.getHelpCommand()).setHelpText(c.getHelpText());
    }

    public NCommandFactoryConfig[] getFactories() {
        if (this.getStoreModelMain().getCommandFactories() != null) {
            return this.getStoreModelMain().getCommandFactories().toArray(new NCommandFactoryConfig[0]);
        }
        return new NCommandFactoryConfig[0];
    }

    public NCustomCmd find(String name, NId forId, NId forOwner) {
        NId i;
        NCustomCmd a = this.find(name);
        if (a != null && a.getCommand() != null && a.getCommand().size() > 0 && (i = NId.get(a.getCommand().get(0)).orNull()) != null && (forId == null || i.getShortName().equals(forId.getArtifactId()) || i.getShortName().equals(forId.getShortName())) && (forOwner == null || a.getOwner() != null && a.getOwner().getShortName().equals(forOwner.getShortName()))) {
            return a;
        }
        return null;
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    public Map<String, NInternalCommand> getInternalCommands() {
        if (this.internalCommands == null) {
            List<NInternalCommand> all = this.workspace.extensions().createComponents(NInternalCommand.class, null);
            this.internalCommands = all.stream().collect(Collectors.toMap(x -> x.getName(), x -> x));
        }
        return this.internalCommands;
    }

    public NOptional<NExecTargetSPI> getExecCmdExtension(String target) {
        return this.workspace.extensions().createComponent(NExecTargetSPI.class, target);
    }
}

