/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.Date;
import net.thevpc.nuts.core.NIndexStore;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NWorkspace;

public abstract class AbstractNIndexStore
implements NIndexStore {
    private NRepository repository;
    private boolean enabled = true;
    private Date inaccessibleDate = null;

    public AbstractNIndexStore(NRepository repository) {
        this.repository = repository;
    }

    protected void setInaccessible() {
        this.inaccessibleDate = new Date();
    }

    public boolean isInaccessible() {
        if (this.inaccessibleDate == null) {
            return false;
        }
        long elapsed = System.currentTimeMillis() - this.inaccessibleDate.getTime();
        if (elapsed > 300000L) {
            this.inaccessibleDate = null;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public NIndexStore setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public NRepository getRepository() {
        return this.repository;
    }

    public void setRepository(NRepository repository) {
        this.repository = repository;
    }

    public NWorkspace getWorkspace() {
        return this.repository == null ? null : this.repository.getWorkspace();
    }
}

