/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.welcome;

import java.util.LinkedHashMap;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.app.util.NAppUtils;
import net.thevpc.nuts.runtime.standalone.util.ExtraApiUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.internal.DefaultInternalNExecutableCommand;
import net.thevpc.nuts.text.NText;

public class DefaultNWelcomeInternalExecutable
extends DefaultInternalNExecutableCommand {
    public DefaultNWelcomeInternalExecutable(String[] args, NExecCmd execCommand) {
        super("welcome", args, execCommand);
    }

    @Override
    public int execute() {
        NSession session = NSession.of();
        boolean dry = ExtraApiUtils.asBoolean(this.getExecCommand().getDry());
        if (dry) {
            this.dryExecute();
            return 0;
        }
        if (NAppUtils.processHelpOptions(this.args)) {
            this.showDefaultHelp();
            return 0;
        }
        NCmdLine cmdLine = NCmdLine.of(this.args);
        while (cmdLine.hasNext()) {
            NArg a = cmdLine.peek().get();
            if (a.isOption()) {
                switch (a.key()) {
                    default: 
                }
                session.configureLast(cmdLine);
                continue;
            }
            session.configureLast(cmdLine);
        }
        if (NOut.isPlain()) {
            NOut.resetLine().println(NWorkspaceExt.of().getWelcomeText());
        } else {
            LinkedHashMap<String, Object> welcome = new LinkedHashMap<String, Object>();
            welcome.put("message", "Welcome to nuts. Yeah, It's working...");
            welcome.put("name", NText.ofStyledPrimary1("nuts"));
            welcome.put("long-name", "Network Updatable Things Services");
            welcome.put("description", "The Free and Open Source Package Manager for Java (TM) and other Things ...");
            welcome.put("url", NPath.of("https://github.com/thevpc/nuts"));
            welcome.put("author", "thevpc");
            welcome.put("api-id", session.getWorkspace().getApiId().builder().setVersion("").build());
            welcome.put("api-version", session.getWorkspace().getApiVersion());
            welcome.put("runtime-id", session.getWorkspace().getRuntimeId().builder().setVersion("").build());
            welcome.put("runtime-version", session.getWorkspace().getRuntimeId().getVersion());
            welcome.put("workspace", NWorkspace.of().getWorkspaceLocation());
            welcome.put("hash-name", NPath.of(session.getWorkspace().getDigestName()));
            NOut.resetLine().println(welcome);
        }
        return 0;
    }
}

