/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.update;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.command.NInstallCmd;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.command.NUpdateCmd;
import net.thevpc.nuts.command.NUpdateResult;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceUpdateResult;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.DefaultNUpdateResult;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallFlags;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallHelper;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallIdInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallIdList;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.update.AbstractNUpdateCmd;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.update.DefaultNWorkspaceUpdateResult;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceConfigModel;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NCancelException;
import net.thevpc.nuts.util.NComparator;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NIteratorUtils;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnexpectedException;

public class DefaultNUpdateCmd
extends AbstractNUpdateCmd {
    private final NComparator<NId> LATEST_VERSION_FIRST = new NComparator<NId>(){

        @Override
        public int compare(NId x, NId y) {
            return -x.getVersion().compareTo(y.getVersion());
        }

        @Override
        public NElement describe() {
            return NElement.ofString("latestVersionFirst");
        }
    };
    private final NComparator<NId> DEFAULT_THEN_LATEST_VERSION_FIRST = new NComparator<NId>(){

        @Override
        public int compare(NId x, NId y) {
            int yi;
            NInstalledRepository rr = NWorkspaceExt.of().getInstalledRepository();
            int xi = rr.isDefaultVersion(x) ? 0 : 1;
            int v = Integer.compare(xi, yi = rr.isDefaultVersion(y) ? 0 : 1);
            if (v != 0) {
                return v;
            }
            return -x.getVersion().compareTo(y.getVersion());
        }

        @Override
        public NElement describe() {
            return NElement.ofString("defaultThenLatestVersionFirst");
        }
    };
    private boolean checkFixes = false;
    private List<FixAction> resultFixes = null;

    public DefaultNUpdateCmd(NWorkspace workspace) {
        super(workspace);
    }

    @Override
    public int getResultCount() {
        return this.getResult().getUpdatesCount();
    }

    @Override
    public NWorkspaceUpdateResult getResult() {
        if (this.result == null) {
            this.checkUpdates();
        }
        if (this.result == null) {
            throw new NUnexpectedException();
        }
        return this.result;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().get();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isUncommented();
        switch (a.key()) {
            case "--check-fixes": {
                cmdLine.skip();
                if (enabled) {
                    this.checkFixes = true;
                }
                return true;
            }
        }
        return super.configureFirst(cmdLine);
    }

    @Override
    public NUpdateCmd update() {
        this.applyResult(this.getResult());
        return this;
    }

    @Override
    public NUpdateCmd checkUpdates() {
        NUpdateResult updated;
        NVersion bootVersion0;
        if (this.checkFixes) {
            this.checkFixes();
            this.traceFixes();
        }
        Instant now = this.expireTime == null ? Instant.now() : this.expireTime;
        NWorkspaceExt dws = NWorkspaceExt.of();
        LinkedHashMap<String, NUpdateResult> allUpdates = new LinkedHashMap<String, NUpdateResult>();
        LinkedHashMap<String, NUpdateResult> extUpdates = new LinkedHashMap<String, NUpdateResult>();
        HashMap<String, NUpdateResult> regularUpdates = new HashMap<String, NUpdateResult>();
        NUpdateResult apiUpdate = null;
        NVersion bootVersion = bootVersion0 = NWorkspace.of().getApiVersion();
        if (this.getApiVersion() != null && !this.getApiVersion().isBlank()) {
            bootVersion = this.getApiVersion();
        }
        if (this.isApi() || this.getApiVersion() != null && !this.getApiVersion().isBlank()) {
            apiUpdate = this.checkCoreUpdate(NId.get("net.thevpc.nuts:nuts").get(), this.getApiVersion(), Type.API, now);
            if (apiUpdate.isUpdatable()) {
                bootVersion = apiUpdate.getAvailable().getId().getVersion();
                allUpdates.put("net.thevpc.nuts:nuts", apiUpdate);
            } else {
                bootVersion = bootVersion0;
            }
        }
        NUpdateResult runtimeUpdate = null;
        if (this.isRuntime() && dws.requiresRuntimeExtension() && (runtimeUpdate = this.checkCoreUpdate(NId.get(NWorkspace.of().getRuntimeId().getShortName()).get(), apiUpdate != null && apiUpdate.getAvailable() != null && apiUpdate.getAvailable().getId() != null ? apiUpdate.getAvailable().getId().getVersion() : bootVersion, Type.RUNTIME, now)).isUpdatable()) {
            allUpdates.put(runtimeUpdate.getId().getShortName(), runtimeUpdate);
        }
        if (this.isExtensions()) {
            for (NId d : this.getExtensionsToUpdate()) {
                updated = this.checkRegularUpdate(d, Type.EXTENSION, bootVersion, now, this.expireTime != null);
                if (!updated.isUpdatable()) continue;
                allUpdates.put(updated.getId().getShortName(), updated);
                extUpdates.put(updated.getId().getShortName(), updated);
            }
        }
        if (this.isCompanions()) {
            for (NId d : this.getCompanionsToUpdate()) {
                updated = this.checkRegularUpdate(d, Type.COMPANION, bootVersion, now, this.expireTime != null);
                if (!updated.isUpdatable()) continue;
                allUpdates.put(updated.getId().getShortName(), updated);
                regularUpdates.put(updated.getId().getShortName(), updated);
            }
        }
        for (NId id : this.getRegularIds()) {
            updated = this.checkRegularUpdate(id, Type.REGULAR, null, now, this.expireTime != null);
            allUpdates.put(updated.getId().getShortName(), updated);
            regularUpdates.put(updated.getId().getShortName(), updated);
        }
        List<NId> lockedIds = this.getLockedIds();
        if (lockedIds.size() > 0) {
            for (NId d : new HashSet<NId>(lockedIds)) {
                NDependency dd = NDependency.get(d.toString()).get();
                if (!regularUpdates.containsKey(dd.getShortName())) continue;
                NUpdateResult updated2 = (NUpdateResult)regularUpdates.get(dd.getShortName());
                if (dd.getVersion().filter().acceptVersion(updated2.getId().getVersion())) continue;
                throw new NIllegalArgumentException(NMsg.ofC("%s unsatisfied  : %s", dd, updated2.getId().getVersion()));
            }
        }
        this.result = new DefaultNWorkspaceUpdateResult(apiUpdate, runtimeUpdate, new ArrayList<NUpdateResult>(extUpdates.values()), new ArrayList<NUpdateResult>(regularUpdates.values()));
        this.traceUpdates(this.result);
        return this;
    }

    private Set<NId> getExtensionsToUpdate() {
        HashSet<NId> ext = new HashSet<NId>();
        for (NId extension : NExtensions.of().getConfigExtensions()) {
            ext.add(extension.getShortId());
        }
        if (this.updateExtensions) {
            return ext;
        }
        HashSet<NId> ext2 = new HashSet<NId>();
        for (NId id : this.ids) {
            if (id.getShortName().equals("net.thevpc.nuts:nuts") || id.getShortName().equals(NWorkspace.of().getRuntimeId().getShortName()) || !ext.contains(id.getShortId())) continue;
            ext2.add(id.getShortId());
        }
        return ext2;
    }

    private Set<NId> getCompanionsToUpdate() {
        HashSet<NId> ext = new HashSet<NId>();
        for (NId extension : NExtensions.of().getCompanionIds()) {
            ext.add(extension.getShortId());
        }
        return ext;
    }

    private Set<NId> getRegularIds() {
        HashSet<String> extensions = new HashSet<String>();
        for (NId object : NExtensions.of().getConfigExtensions()) {
            extensions.add(object.getShortName());
        }
        HashSet<NId> baseRegulars = new HashSet<NId>(this.ids);
        if (this.isInstalled()) {
            baseRegulars.addAll(NSearchCmd.of().setDefinitionFilter(NDefinitionFilters.of().byInstalled(true)).getResultIds().stream().map(NId::getShortId).collect(Collectors.toList()));
            NWorkspaceExt dws = NWorkspaceExt.of();
            NInstalledRepository ir = dws.getInstalledRepository();
            for (NInstallInformation y : NIteratorUtils.toList(ir.searchInstallInformation())) {
                if (y == null || !y.getInstallStatus().isInstalled() || y.getId() == null) continue;
                baseRegulars.add(y.getId().builder().setVersion("").build());
            }
        }
        HashSet<NId> regulars = new HashSet<NId>();
        for (NId id : baseRegulars) {
            if (id.getShortName().equals("net.thevpc.nuts:nuts") || id.getShortName().equals(NWorkspace.of().getRuntimeId().getShortName()) || extensions.contains(id.getShortName())) continue;
            regulars.add(id);
        }
        return regulars;
    }

    public NUpdateCmd checkFixes() {
        this.resultFixes = null;
        NWorkspaceExt dws = NWorkspaceExt.of();
        NInstalledRepository ir = dws.getInstalledRepository();
        this.resultFixes = NIteratorUtils.toList(NIteratorUtils.convertNonNull(ir.searchInstallInformation(), new Function<NInstallInformation, FixAction>(){

            @Override
            public FixAction apply(NInstallInformation nInstallInformation) {
                NId id = NSearchCmd.of().setDefinitionFilter(NDefinitionFilters.of().byInstalled(true)).addId(nInstallInformation.getId()).getResultIds().findFirst().orNull();
                if (id == null) {
                    return new FixAction(nInstallInformation.getId(), "MissingInstallation"){

                        @Override
                        public void fix() {
                            NInstallCmd.of(this.getId()).run();
                        }
                    };
                }
                return null;
            }
        }, "CheckFixes"));
        return this;
    }

    protected void traceFixes() {
        if (this.resultFixes != null) {
            NSession session = NSession.of();
            NPrintStream out = session.out();
            for (FixAction n : this.resultFixes) {
                out.println(NMsg.ofC("[```error FIX```] %s %s", n.getId(), n.getProblemKey()));
            }
        }
    }

    protected void traceUpdates(NWorkspaceUpdateResult result) {
        NSession session = NSession.of();
        NPrintStream out = session.out();
        List<NUpdateResult> all = result.getAllResults();
        List<NUpdateResult> updates = result.getUpdatable();
        List notInstalled = result.getAllResults().stream().filter(x -> !x.isInstalled()).collect(Collectors.toList());
        all.sort(new Comparator<NUpdateResult>(){

            private int itemOrder(NUpdateResult o) {
                if (!o.isInstalled()) {
                    return 1;
                }
                if (!o.isUpdateVersionAvailable()) {
                    return 2;
                }
                if (!o.isUpdateStatusAvailable()) {
                    return 3;
                }
                return 4;
            }

            @Override
            public int compare(NUpdateResult o1, NUpdateResult o2) {
                return Integer.compare(this.itemOrder(o1), this.itemOrder(o2));
            }
        });
        if (session.isPlainTrace()) {
            if (notInstalled.size() == 0 && updates.size() == 0) {
                out.resetLine().println(NMsg.ofC("all packages are %s. You are running latest version%s.", NText.ofStyledSuccess("up-to-date"), result.getAllResults().size() > 1 ? "s" : ""));
            } else {
                if (updates.size() > 0 && notInstalled.size() > 0) {
                    out.resetLine().println(NMsg.ofC("workspace has %s package%s not installed and %s package%s to update.", NText.ofStyledPrimary1("" + notInstalled.size()), notInstalled.size() > 1 ? "s" : "", NText.ofStyledPrimary1("" + updates.size()), updates.size() > 1 ? "s" : ""));
                } else if (updates.size() > 0) {
                    out.resetLine().println(NMsg.ofC("workspace has %s package%s to update.", NText.ofStyledPrimary1("" + updates.size()), updates.size() > 1 ? "s" : ""));
                } else if (notInstalled.size() > 0) {
                    out.resetLine().println(NMsg.ofC("workspace has %s package%s not installed.", NText.ofStyledPrimary1("" + notInstalled.size()), notInstalled.size() > 1 ? "s" : ""));
                }
                int widthCol1 = 2;
                int widthCol2 = 2;
                for (NUpdateResult update : all) {
                    widthCol1 = Math.max(widthCol1, update.getAvailable() == null ? 0 : update.getAvailable().getId().getShortName().length());
                    widthCol2 = Math.max(widthCol2, update.getInstalled() == null ? 0 : update.getInstalled().getId().getVersion().toString().length());
                }
                NTexts factory = NTexts.of();
                for (NUpdateResult update : all) {
                    if (update.getInstalled() == null) {
                        out.println(NMsg.ofC("%s  : %s", factory.ofStyled(NStringUtils.formatAlign(update.getId().toString(), widthCol2, NPositionType.FIRST), NTextStyle.primary6()), factory.ofStyled("not installed", NTextStyle.error())));
                        continue;
                    }
                    if (update.isUpdateVersionAvailable()) {
                        out.println(NMsg.ofC("%s  : %s => %s", factory.ofStyled(NStringUtils.formatAlign(update.getInstalled().getId().getVersion().toString(), widthCol2, NPositionType.FIRST), NTextStyle.primary6()), NStringUtils.formatAlign(update.getAvailable().getId().getShortName(), widthCol1, NPositionType.FIRST), factory.ofPlain(update.getAvailable().getId().getVersion().toString())));
                        continue;
                    }
                    if (update.isUpdateStatusAvailable()) {
                        out.println(NMsg.ofC("%s  : %s => %s", factory.ofStyled(NStringUtils.formatAlign(update.getInstalled().getId().getVersion().toString(), widthCol2, NPositionType.FIRST), NTextStyle.primary6()), NStringUtils.formatAlign(update.getAvailable().getId().getShortName(), widthCol1, NPositionType.FIRST), factory.ofStyled("set as default", NTextStyle.primary4())));
                        continue;
                    }
                    out.println(NMsg.ofC("%s  : %s", factory.ofStyled(NStringUtils.formatAlign(update.getInstalled().getId().getVersion().toString(), widthCol2, NPositionType.FIRST), NTextStyle.primary6()), factory.ofStyled("up-to-date", NTextStyle.warn())));
                }
            }
        } else if (updates.size() == 0 && notInstalled.size() == 0) {
            out.println(NElement.ofObjectBuilder().set("message", "all packages are up-to-date. You are running latest version" + (result.getAllResults().size() > 1 ? "s" : "") + ".").build());
        } else {
            NArrayElementBuilder arrayElementBuilder = NElement.ofArrayBuilder();
            for (NUpdateResult update : all) {
                if (update.getInstalled() == null) {
                    arrayElementBuilder.add(NElement.ofObjectBuilder().set("package", update.getId().getShortName()).set("status", "not-installed").build());
                    continue;
                }
                if (update.isUpdateVersionAvailable()) {
                    arrayElementBuilder.add(NElement.ofObjectBuilder().set("package", update.getAvailable().getId().getShortName()).set("status", "update-version-available").set("localVersion", update.getInstalled().getId().getVersion().toString()).set("newVersion", update.getAvailable().getId().getVersion().toString()).build());
                    continue;
                }
                if (update.isUpdateStatusAvailable()) {
                    arrayElementBuilder.add(NElement.ofObjectBuilder().set("package", update.getAvailable().getId().getShortName()).set("localVersion", update.getInstalled().getId().getVersion().toString()).set("status", "update-default-available").set("newVersion", "set as default").build());
                    continue;
                }
                arrayElementBuilder.add(NElement.ofObjectBuilder().set("package", update.getId().getShortName()).set("localVersion", update.getInstalled().getId().getVersion().toString()).set("status", "up-to-date").build());
            }
            out.println(arrayElementBuilder.build());
        }
    }

    private NFetchCmd latestOnlineDependencies() {
        NFetchCmd se = NFetchCmd.of();
        se.addDependencyFilter(NDependencyFilters.of().byRunnable(this.isOptional()));
        if (!this.scopes.isEmpty()) {
            se.addDependencyFilter(NDependencyFilters.of().byScope(this.scopes.toArray(new NDependencyScope[0])));
        }
        return se;
    }

    protected NUpdateResult checkRegularUpdate(NId id, Type type, NVersion targetApiVersion, Instant now, boolean updateEvenIfExisting) {
        NVersion version = id.getVersion();
        if (!updateEvenIfExisting && version.isSingleValue()) {
            updateEvenIfExisting = NAsk.of().setDefaultValue(true).forBoolean(NMsg.ofC("version is too restrictive. Do you intend to force update of %s ?", id)).getBooleanValue();
        }
        DefaultNUpdateResult r = new DefaultNUpdateResult();
        r.setId(id.getShortId());
        boolean shouldUpdateDefault = false;
        NDefinition d0 = NSearchCmd.of().addId(id).setDefinitionFilter(NDefinitionFilters.of().byDeployed(true)).setDependencyFilter(NDependencyFilters.of().byOptional(false)).setFailFast(false).sort(this.DEFAULT_THEN_LATEST_VERSION_FIRST).getResultDefinitions().findFirst().orNull();
        if (d0 == null) {
            return r;
        }
        if (!d0.getInstallInformation().get().isDefaultVersion()) {
            shouldUpdateDefault = true;
        }
        NSearchCmd sc = NSearchCmd.of().setFetchStrategy(NFetchStrategy.ANYWHERE).addId(d0.getId().getShortId()).setFailFast(false).setLatest(true).addDefinitionFilter(NDefinitionFilters.of().byLockedIds(this.getLockedIds().toArray(new NId[0]))).addRepositoryFilter(NRepositoryFilters.of().installedRepo().neg()).setDependencyFilter(NDependencyFilters.of().byOptional(this.isOptional() ? null : Boolean.valueOf(false)));
        if (updateEvenIfExisting) {
            sc.setExpireTime(now);
        }
        if (type == Type.EXTENSION) {
            sc.setExtension(true);
        } else if (type == Type.COMPANION) {
            sc.setCompanion(true);
        }
        if (targetApiVersion != null) {
            sc.setTargetApiVersion(targetApiVersion);
        }
        sc.setDependencyFilter(this.resolveDependencyFilter());
        NDefinition d1 = sc.getResultDefinitions().findFirst().orNull();
        r.setInstalled(d0);
        r.setAvailable(d1);
        if (d1 == null) {
            r.setAvailable(d0);
        } else {
            NVersion v0 = d0.getId().getVersion();
            NVersion v1 = d1.getId().getVersion();
            if (v1.compareTo(v0) <= 0) {
                if (updateEvenIfExisting) {
                    r.setUpdateForced(true);
                }
                if (shouldUpdateDefault) {
                    r.setUpdateStatusAvailable(true);
                }
            } else {
                r.setUpdateVersionAvailable(true);
            }
        }
        return r;
    }

    private NDependencyFilter resolveDependencyFilter() {
        return NDependencyFilters.of().byRunnable(this.isOptional()).and(NDependencyFilters.of().byScope(this.scopes.toArray(new NDependencyScope[0])));
    }

    private void applyFixes() {
        if (this.resultFixes != null) {
            NSession session = NSession.of();
            NPrintStream out = session.out();
            for (FixAction n : this.resultFixes) {
                n.fix();
                out.println(NMsg.ofC("[```error FIX```] unable to %s %s ", n.getId(), n.getProblemKey()));
            }
        }
    }

    private void applyResult(NWorkspaceUpdateResult result) {
        NId finalRuntimeId;
        NSession session = NSession.of();
        NWorkspace ws = session.getWorkspace();
        this.applyFixes();
        NUpdateResult apiUpdate = result.getApi();
        NUpdateResult runtimeUpdate = result.getRuntime();
        List notInstalled = result.getAllResults().stream().filter(x -> x.getInstalled() == null).map(NUpdateResult::getId).collect(Collectors.toList());
        if (!notInstalled.isEmpty()) {
            if (notInstalled.size() == 1) {
                throw new NIllegalArgumentException(NMsg.ofC("%s is not yet installed for it to be updated.", notInstalled.get(0)));
            }
            throw new NIllegalArgumentException(NMsg.ofC("%s are not yet installed for them to be updated.", notInstalled));
        }
        if (result.getUpdatesCount() == 0) {
            return;
        }
        NWorkspaceUtils.of().checkReadOnly();
        boolean requireSave = false;
        NSession validWorkspaceSession = session;
        NPrintStream out = validWorkspaceSession.out();
        boolean accept = NIO.of().getDefaultTerminal().ask().forBoolean(NMsg.ofPlain("would you like to apply updates?")).setDefaultValue(true).getValue();
        if (validWorkspaceSession.isAsk() && !accept) {
            throw new NCancelException();
        }
        boolean apiUpdateAvailable = apiUpdate != null && apiUpdate.getAvailable() != null && !apiUpdate.isUpdateApplied();
        boolean runtimeUpdateAvailable = runtimeUpdate != null && runtimeUpdate.getAvailable() != null && !runtimeUpdate.isUpdateApplied();
        boolean apiUpdateApplicable = apiUpdateAvailable && !apiUpdate.isUpdateApplied();
        boolean runtimeUpdateApplicable = runtimeUpdateAvailable && !runtimeUpdate.isUpdateApplied();
        NId finalApiId = apiUpdateAvailable ? apiUpdate.getAvailable().getId() : ws.getApiId();
        NId nId = finalRuntimeId = runtimeUpdateApplicable ? runtimeUpdate.getAvailable().getId() : ws.getRuntimeId();
        if (apiUpdateApplicable || runtimeUpdateApplicable) {
            // empty if block
        }
        if (apiUpdateApplicable) {
            this.applyRegularUpdate((DefaultNUpdateResult)apiUpdate);
            ((DefaultNUpdateResult)apiUpdate).setUpdateApplied(true);
            this.traceSingleUpdate(apiUpdate);
        }
        if (runtimeUpdateApplicable) {
            this.applyRegularUpdate((DefaultNUpdateResult)runtimeUpdate);
            ((DefaultNUpdateResult)runtimeUpdate).setUpdateApplied(true);
            List<NId> baseApiIds = CoreNUtils.resolveNutsApiIdsFromIdList(runtimeUpdate.getDependencies());
            DefaultNWorkspaceConfigModel configModel = NWorkspaceExt.of().getModel().configModel;
            for (NId newApi : baseApiIds) {
                configModel.setExtraBootRuntimeId(newApi, runtimeUpdate.getAvailable().getId(), runtimeUpdate.getAvailable().getDependencies().get().transitive().toList());
            }
            this.traceSingleUpdate(runtimeUpdate);
        }
        for (NUpdateResult extension : result.getExtensions()) {
            if (extension.isUpdateApplied() || extension.getAvailable() == null) continue;
            this.applyRegularUpdate((DefaultNUpdateResult)extension);
            List<NId> baseApiIds = CoreNUtils.resolveNutsApiIdsFromIdList(extension.getDependencies());
            DefaultNWorkspaceConfigModel configModel = NWorkspaceExt.of().getModel().configModel;
            for (NId newApi : baseApiIds) {
                configModel.setExtraBootExtensionId(newApi, extension.getAvailable().getId(), extension.getAvailable().getDependencies().get().transitive().toList());
            }
            ((DefaultNUpdateResult)extension).setUpdateApplied(true);
            this.traceSingleUpdate(extension);
        }
        for (NUpdateResult component : result.getArtifacts()) {
            this.applyRegularUpdate((DefaultNUpdateResult)component);
        }
        if (NWorkspace.of().saveConfig(requireSave)) {
            if (this._LOG().isLoggable(Level.INFO)) {
                this._LOG().log(NMsg.ofPlain("workspace is updated. Nuts should be restarted for changes to take effect.").withLevel(Level.INFO).withIntent(NMsgIntent.ALERT));
            }
            if (apiUpdate != null && apiUpdate.isUpdatable() && !apiUpdate.isUpdateApplied() && validWorkspaceSession.isPlainTrace()) {
                out.println("workspace is updated. Nuts should be restarted for changes to take effect.");
            }
        }
    }

    private void traceSingleUpdate(NUpdateResult r) {
        NSession session = NSession.of();
        NId id = r.getId();
        NDefinition d0 = r.getInstalled();
        NDefinition d1 = r.getAvailable();
        NId simpleId = d0 != null ? d0.getId().getShortId() : (d1 != null ? d1.getId().getShortId() : id.getShortId());
        NPrintStream out = session.out();
        NTexts factory = NTexts.of();
        if (r.isUpdateApplied() && r.isUpdateForced()) {
            if (d0 == null) {
                out.resetLine().println(NMsg.ofC("%s is %s to latest version %s", simpleId, factory.ofStyled("updated", NTextStyle.primary3()), d1 == null ? null : d1.getId().getVersion()));
            } else if (d1 != null) {
                NVersion v0 = d0.getId().getVersion();
                NVersion v1 = d1.getId().getVersion();
                if (v1.compareTo(v0) <= 0) {
                    if (v1.compareTo(v0) == 0) {
                        out.resetLine().println(NMsg.ofC("%s is %s to %s", simpleId, factory.ofStyled("forced", NTextStyle.primary3()), d0.getId().getVersion()));
                    } else {
                        out.resetLine().println(NMsg.ofC("%s is %s from %s to older version %s", simpleId, factory.ofStyled("forced", NTextStyle.primary3()), d0.getId().getVersion(), d1.getId().getVersion()));
                    }
                } else {
                    out.resetLine().println(NMsg.ofC("%s is %s from %s to latest version %s", simpleId, factory.ofStyled("updated", NTextStyle.primary3()), d0.getId().getVersion(), d1.getId().getVersion()));
                }
            }
        }
    }

    public NUpdateResult checkCoreUpdate(NId id, NVersion bootApiVersion, Type type, Instant now) {
        NSession session = NSession.of();
        NWorkspace ws = session.getWorkspace();
        NId oldId = null;
        NDefinition oldFile = null;
        NDefinition newFile = null;
        NId newId = null;
        switch (type.ordinal()) {
            case 0: {
                NVersion v;
                oldId = NWorkspace.of().getStoredConfig().getApiId();
                NId confId = NWorkspace.of().getStoredConfig().getApiId();
                if (confId != null) {
                    oldId = confId;
                }
                if ((v = bootApiVersion) == null || v.isBlank()) {
                    v = NVersion.get("LATEST").get();
                }
                try {
                    NId finalOldId = oldId;
                    oldFile = session.copy().setFetchStrategy(NFetchStrategy.ONLINE).callWith(() -> NFetchCmd.of(finalOldId).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition());
                }
                catch (NArtifactNotFoundException finalOldId) {
                    // empty catch block
                }
                try {
                    NId finalNewId1 = newId = NSearchCmd.of().setFetchStrategy(NFetchStrategy.ANYWHERE).setRepositoryFilter(this.getRepositoryFilter()).addId("net.thevpc.nuts:nuts#" + v).setLatest(true).getResultIds().findFirst().orNull();
                    newFile = newId == null ? null : session.copy().setFetchStrategy(NFetchStrategy.ONLINE).callWith(() -> this.latestOnlineDependencies().setFailFast(false).setId(finalNewId1).getResultDefinition());
                }
                catch (NArtifactNotFoundException ex) {
                    this._LOG().log(NMsg.ofC("error : %s", ex).asError(ex));
                }
                break;
            }
            case 1: {
                oldId = ws.getRuntimeId();
                NId confId = NWorkspace.of().getStoredConfig().getRuntimeId();
                if (confId != null) {
                    oldId = confId;
                }
                if (oldId != null) {
                    try {
                        NId finalOldId1 = oldId;
                        oldFile = session.copy().setFetchStrategy(NFetchStrategy.ONLINE).callWith(() -> NFetchCmd.of().setId(finalOldId1).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition());
                    }
                    catch (NArtifactNotFoundException ex) {
                        this._LOG().log(NMsg.ofC("error : %s", ex).asError(ex));
                    }
                }
                try {
                    NSearchCmd se = NSearchCmd.of().setFetchStrategy(NFetchStrategy.ANYWHERE).addId(oldFile != null ? oldFile.getId().builder().setVersion("").build().toString() : "net.thevpc.nuts:nuts-runtime").setRuntime(true).setTargetApiVersion(bootApiVersion).addDefinitionFilter(NDefinitionFilters.of().byLockedIds(this.getLockedIds().toArray(new NId[0]))).setLatest(true).sort(this.LATEST_VERSION_FIRST);
                    NId finalNewId = newId = se.getResultIds().findFirst().orNull();
                    newFile = newId == null ? null : session.copy().setFetchStrategy(NFetchStrategy.ONLINE).callWith(() -> this.latestOnlineDependencies().setId(finalNewId).setFailFast(false).getResultDefinition());
                }
                catch (NArtifactNotFoundException ex) {
                    this._LOG().log(NMsg.ofC("error : %s", ex).asError(ex));
                }
                break;
            }
        }
        NId cnewId = this.toCanonicalForm(newId);
        NId coldId = this.toCanonicalForm(oldId);
        DefaultNUpdateResult defaultNutsUpdateResult = new DefaultNUpdateResult(id, oldFile, newFile, newFile == null ? null : ((NStream)newFile.getDependencies().get().transitive().map(NDependency::toId).redescribe(NElementDescribables.ofDesc("toId"))).toList(), false);
        if (cnewId != null && newFile != null && coldId != null && cnewId.getVersion().compareTo(coldId.getVersion()) > 0) {
            defaultNutsUpdateResult.setUpdateVersionAvailable(true);
        }
        return defaultNutsUpdateResult;
    }

    private NId toCanonicalForm(NId id) {
        String oldValue;
        if (id != null && (oldValue = (id = id.builder().setRepository(null).build()).getProperties().get("face")) != null && oldValue.trim().isEmpty()) {
            id = id.builder().setProperty("face", null).build();
        }
        return id;
    }

    private void applyRegularUpdate(DefaultNUpdateResult r) {
        if (r.isUpdateApplied()) {
            return;
        }
        NWorkspaceExt dws = NWorkspaceExt.of();
        NDefinition d0 = r.getInstalled();
        NDefinition d1 = r.getAvailable();
        if (d0 == null) {
            NWorkspaceSecurityManager.of().checkAllowed("update", "update");
            this.applyRegularUpdate0(d1, new String[0]);
            r.setUpdateApplied(true);
        } else if (d1 != null) {
            NVersion v0 = d0.getId().getVersion();
            NVersion v1 = d1.getId().getVersion();
            if (v1.compareTo(v0) <= 0) {
                if (r.isUpdateForced()) {
                    NWorkspaceSecurityManager.of().checkAllowed("update", "update");
                    this.applyRegularUpdate0(d1, new String[0]);
                    r.setUpdateApplied(true);
                    r.setUpdateForced(true);
                } else {
                    dws.getInstalledRepository().setDefaultVersion(d1.getId());
                }
            } else {
                NWorkspaceSecurityManager.of().checkAllowed("update", "update");
                this.applyRegularUpdate0(d1, new String[0]);
                r.setUpdateApplied(true);
            }
        }
        this.traceSingleUpdate(r);
    }

    private void applyRegularUpdate0(NDefinition d1, String[] args) {
        InstallIdList li = new InstallIdList();
        InstallFlags flags = new InstallFlags();
        InstallHelper h = new InstallHelper((DefaultNWorkspace)NWorkspaceExt.of(), li, true, args == null ? new ArrayList() : Arrays.asList(args), null);
        InstallIdInfo uu = li.addAsInstalled(d1.getId(), flags);
        uu.cacheItem = h.getCache(d1.getId());
        uu.cacheItem.revalidate(d1);
    }

    public static enum Type {
        API,
        RUNTIME,
        REGULAR,
        EXTENSION,
        COMPANION;

    }

    private static abstract class FixAction {
        private final NId id;
        private final String problemKey;

        public FixAction(NId id, String problemKey) {
            this.id = id;
            this.problemKey = problemKey;
        }

        public NId getId() {
            return this.id;
        }

        public String getProblemKey() {
            return this.problemKey;
        }

        public abstract void fix();

        public String toString() {
            return "FixAction{id=" + this.id + ", problemKey='" + this.problemKey + '\'' + '}';
        }
    }
}

