/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.update;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NUpdateCmd;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceUpdateResult;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NWorkspaceCmdBase;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NUnexpectedException;

public abstract class AbstractNUpdateCmd
extends NWorkspaceCmdBase<NUpdateCmd>
implements NUpdateCmd {
    protected boolean enableInstall = true;
    protected boolean updateApi = false;
    protected boolean updateRuntime = false;
    protected boolean updateExtensions = false;
    protected boolean updateInstalled = false;
    protected boolean updateCompanions = false;
    protected boolean includeOptional = false;
    protected NVersion forceBootAPIVersion;
    protected Instant expireTime;
    protected List<String> args;
    protected final List<NDependencyScope> scopes = new ArrayList<NDependencyScope>();
    protected final List<NId> lockedIds = new ArrayList<NId>();
    protected final List<NId> ids = new ArrayList<NId>();
    protected NWorkspaceUpdateResult result;
    protected NRepositoryFilter repositoryFilter;

    public AbstractNUpdateCmd(NWorkspace workspace) {
        super("update");
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public List<NId> getIds() {
        return NCollections.unmodifiableList(this.ids);
    }

    @Override
    public NUpdateCmd addId(String id) {
        return this.addId(id == null ? null : NId.get(id).get());
    }

    @Override
    public NUpdateCmd addId(NId id) {
        if (id == null) {
            throw new NArtifactNotFoundException(id);
        }
        this.ids.add(id);
        return this;
    }

    @Override
    public NUpdateCmd addIds(String ... ids) {
        for (String id : ids) {
            this.addId(id);
        }
        return this;
    }

    @Override
    public NUpdateCmd addIds(NId ... ids) {
        for (NId id : ids) {
            this.addId(id);
        }
        return this;
    }

    @Override
    public NUpdateCmd removeId(NId id) {
        if (id != null) {
            this.ids.remove(id);
        }
        return this;
    }

    @Override
    public NUpdateCmd removeId(String id) {
        return this.removeId(NId.get(id).get());
    }

    @Override
    public NUpdateCmd addScope(NDependencyScope scope) {
        if (scope != null) {
            this.scopes.add(scope);
        }
        return this;
    }

    @Override
    public NUpdateCmd addScopes(NDependencyScope ... scopes) {
        if (scopes != null) {
            for (NDependencyScope s : scopes) {
                this.addScope(s);
            }
        }
        return this;
    }

    @Override
    public NUpdateCmd addScopes(Collection<NDependencyScope> scopes) {
        if (scopes != null) {
            for (NDependencyScope s : scopes) {
                this.addScope(s);
            }
        }
        return this;
    }

    @Override
    public boolean isOptional() {
        return this.includeOptional;
    }

    @Override
    public NUpdateCmd setOptional(boolean includeOptional) {
        this.includeOptional = includeOptional;
        return this;
    }

    @Override
    public List<String> getArgs() {
        return NCollections.unmodifiableList(this.args);
    }

    @Override
    public NUpdateCmd addArg(String arg) {
        if (arg != null) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            this.args.add(arg);
        }
        return this;
    }

    @Override
    public NUpdateCmd clearArgs() {
        this.args = null;
        return this;
    }

    @Override
    public NUpdateCmd addArgs(String ... args) {
        return this.addArgs(args == null ? null : Arrays.asList(args));
    }

    @Override
    public NUpdateCmd addArgs(Collection<String> args) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (args != null) {
            for (String arg : args) {
                if (arg == null) continue;
                this.args.add(arg);
            }
        }
        return this;
    }

    @Override
    public List<NId> getLockedIds() {
        return NCollections.unmodifiableList(this.lockedIds);
    }

    @Override
    public boolean isEnableInstall() {
        return this.enableInstall;
    }

    @Override
    public NUpdateCmd setEnableInstall(boolean enableInstall) {
        this.enableInstall = enableInstall;
        return this;
    }

    private boolean isUpdateNone() {
        return !this.updateApi && !this.updateRuntime && !this.updateExtensions && !this.updateInstalled && !this.updateCompanions && this.ids.isEmpty();
    }

    @Override
    public boolean isApi() {
        if (this.updateApi || this.isUpdateNone()) {
            return true;
        }
        for (NId id : this.ids) {
            if (!id.getShortName().equals("net.thevpc.nuts:nuts")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstalled() {
        return this.updateInstalled;
    }

    @Override
    public boolean isCompanions() {
        if (this.isApi()) {
            return true;
        }
        return this.updateCompanions;
    }

    @Override
    public boolean isRuntime() {
        if (this.isApi()) {
            return true;
        }
        if (this.updateRuntime) {
            return true;
        }
        for (NId id : this.ids) {
            if (!id.getShortName().equals(NWorkspace.of().getRuntimeId().getShortName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public NUpdateCmd setApi(boolean enableMajorUpdates) {
        this.updateApi = enableMajorUpdates;
        return this;
    }

    @Override
    public NUpdateCmd setCompanions(boolean updateCompanions) {
        this.updateCompanions = updateCompanions;
        return this;
    }

    @Override
    public boolean isExtensions() {
        if (this.isApi()) {
            return true;
        }
        return this.updateExtensions;
    }

    @Override
    public NUpdateCmd setExtensions(boolean updateExtensions) {
        this.updateExtensions = updateExtensions;
        return this;
    }

    @Override
    public NVersion getApiVersion() {
        return this.forceBootAPIVersion;
    }

    @Override
    public NUpdateCmd setApiVersion(NVersion value) {
        this.forceBootAPIVersion = value;
        return this;
    }

    @Override
    public int getResultCount() {
        return this.getResult().getUpdatesCount();
    }

    @Override
    public NWorkspaceUpdateResult getResult() {
        if (this.result == null) {
            this.checkUpdates();
        }
        if (this.result == null) {
            throw new NUnexpectedException();
        }
        return this.result;
    }

    @Override
    public NUpdateCmd run() {
        return this.update();
    }

    @Override
    public NUpdateCmd checkUpdates(boolean applyUpdates) {
        this.checkUpdates();
        if (applyUpdates) {
            this.update();
        }
        return this;
    }

    @Override
    public NUpdateCmd setRuntime(boolean updateRuntime) {
        this.updateRuntime = updateRuntime;
        return this;
    }

    @Override
    public NUpdateCmd setInstalled(boolean enable) {
        this.updateInstalled = enable;
        return this;
    }

    @Override
    public NUpdateCmd setAll() {
        this.setApi(true);
        this.setRuntime(true);
        this.setExtensions(true);
        this.setCompanions(true);
        this.setInstalled(true);
        return this;
    }

    @Override
    public NUpdateCmd clearIds() {
        this.ids.clear();
        return this;
    }

    @Override
    public NUpdateCmd addLockedId(NId id) {
        if (id != null) {
            this.lockedIds.add(id);
        }
        return this;
    }

    @Override
    public NUpdateCmd addLockedId(String id) {
        if (!NBlankable.isBlank(id)) {
            this.lockedIds.add(NId.get(id).get());
        }
        return this;
    }

    @Override
    public NUpdateCmd addLockedIds(NId ... ids) {
        if (ids != null) {
            for (NId id : ids) {
                this.addId(id);
            }
        }
        return this;
    }

    @Override
    public NUpdateCmd addLockedIds(String ... ids) {
        if (ids != null) {
            for (String id : ids) {
                this.addId(id);
            }
        }
        return this;
    }

    @Override
    public NUpdateCmd clearLockedIds() {
        this.lockedIds.clear();
        return this;
    }

    @Override
    public NUpdateCmd clearScopes() {
        this.scopes.clear();
        return this;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().get();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isUncommented();
        switch (a.key()) {
            case "-a": 
            case "--all": {
                cmdLine.skip();
                if (enabled) {
                    this.setAll();
                }
                return true;
            }
            case "-i": 
            case "--installed": {
                return cmdLine.matcher().matchFlag(v -> this.setInstalled(v.booleanValue())).anyMatch();
            }
            case "-r": 
            case "--runtime": {
                return cmdLine.matcher().matchFlag(v -> this.setRuntime(v.booleanValue())).anyMatch();
            }
            case "-A": 
            case "--api": {
                return cmdLine.matcher().matchFlag(v -> this.setApi(v.booleanValue())).anyMatch();
            }
            case "-e": 
            case "--extensions": {
                return cmdLine.matcher().matchFlag(v -> this.setExtensions(v.booleanValue())).anyMatch();
            }
            case "-c": 
            case "--companions": {
                return cmdLine.matcher().matchFlag(v -> this.setCompanions(v.booleanValue())).anyMatch();
            }
            case "-v": 
            case "--api-version": 
            case "--to-version": {
                return cmdLine.matcher().matchEntry(v -> this.setApiVersion(NVersion.get(v.stringValue()).get())).anyMatch();
            }
            case "-g": 
            case "--args": {
                cmdLine.skip();
                if (enabled) {
                    this.addArgs(cmdLine.toStringArray());
                }
                cmdLine.skipAll();
                return true;
            }
            case "-N": 
            case "--expire": {
                a = cmdLine.next().get();
                if (enabled) {
                    this.expireTime = NBlankable.isNonBlank(a.getStringValue().orNull()) ? Instant.parse(a.getStringValue().get()) : Instant.now();
                }
                return true;
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (a.isOption()) {
            return false;
        }
        cmdLine.skip();
        this.addId(a.asString().get());
        return true;
    }

    @Override
    public NRepositoryFilter getRepositoryFilter() {
        return this.repositoryFilter;
    }

    @Override
    public NUpdateCmd setRepositoryFilter(NRepositoryFilter repositoryFilter) {
        this.repositoryFilter = repositoryFilter;
        return this;
    }
}

