/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user;

import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.cmdline.NArgName;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementNotFoundException;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNSettingsSubCommand;
import net.thevpc.nuts.security.NUser;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;

public class NSettingsUserSubCommand
extends AbstractNSettingsSubCommand {
    public NSettingsUserSubCommand(NWorkspace workspace) {
    }

    @Override
    public boolean exec(NCmdLine cmdLine, Boolean autoSave) {
        return NSettingsUserSubCommand.exec(null, cmdLine, autoSave);
    }

    public static boolean exec(NRepository editedRepo, NCmdLine cmdLine, Boolean autoSave) {
        if (cmdLine.next("add user", "au").isPresent()) {
            NRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next("--repo", "-r").isPresent()) {
                repository = NWorkspace.of().findRepository(cmdLine.nextNonOption(NArgName.of("RepositoryId")).get().image()).get();
            }
            if (repository == null) {
                String user = cmdLine.nextNonOption(NArgName.of("Username")).get().image();
                char[] password = cmdLine.nextNonOption(NArgName.of("Password")).get().image().toCharArray();
                if (cmdLine.isExecMode()) {
                    NWorkspaceSecurityManager.of().addUser(user).setCredentials(password).run();
                }
            } else {
                String user = cmdLine.nextNonOption(NArgName.of("Username")).get().image();
                char[] password = cmdLine.nextNonOption(NArgName.of("Password")).get().image().toCharArray();
                String mappedUser = null;
                char[] remotePassword = null;
                if (!cmdLine.isEmpty()) {
                    mappedUser = cmdLine.nextNonOption(NArgName.of("RemoteId")).get().image();
                    remotePassword = cmdLine.nextNonOption(NArgName.of("RemotePassword")).get().image().toCharArray();
                }
                if (cmdLine.isExecMode()) {
                    repository.security().addUser(user).setCredentials(password).setRemoteIdentity(mappedUser).setRemoteCredentials(remotePassword).run();
                }
            }
            if (cmdLine.isExecMode()) {
                NWorkspace.of().saveConfig();
            }
            return true;
        }
        NSession session = NSession.of();
        NPrintStream out = session.out();
        if (cmdLine.next("list users", "list user", "user list", "lu").isPresent()) {
            NRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next("--repo", "-r").isPresent()) {
                repository = NWorkspace.of().findRepository(cmdLine.nextNonOption(NArgName.of("repository")).get().image()).get();
            }
            if (cmdLine.isExecMode()) {
                List<NUser> security = repository == null ? NWorkspaceSecurityManager.of().findUsers() : repository.security().findUsers();
                for (NUser u : security) {
                    out.println(NMsg.ofC("User: %s", u.getUser()));
                    if (!NBlankable.isBlank(u.getRemoteIdentity())) {
                        out.println(NMsg.ofC("   Mapper to  : %s", u.getRemoteIdentity()));
                    }
                    out.println(NMsg.ofC("   Password   : %s", u.hasCredentials() ? "Set" : "None"));
                    out.println(NMsg.ofC("   Groups     : %s", u.getGroups().size() == 0 ? "None" : u.getGroups()));
                    out.println(NMsg.ofC("   Rights     : %s", u.getPermissions().size() == 0 ? "None" : u.getPermissions()));
                }
            }
            return true;
        }
        if (cmdLine.next("password", "passwd", "pwd").isPresent()) {
            NRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next("--repo", "-r").isPresent()) {
                repository = NWorkspace.of().findRepository(cmdLine.nextNonOption(NArgName.of("RepositoryId")).get().image()).get();
            }
            String user = null;
            char[] password = null;
            char[] oldPassword = null;
            do {
                if (cmdLine.next("--user").isPresent()) {
                    user = cmdLine.nextNonOption(NArgName.of("Username")).get().image();
                    continue;
                }
                if (cmdLine.next("--password").isPresent()) {
                    password = cmdLine.nextNonOption(NArgName.of("Password")).get().image().toCharArray();
                    continue;
                }
                if (cmdLine.next("--old-password").isPresent()) {
                    oldPassword = cmdLine.nextNonOption(NArgName.of("OldPassword")).get().image().toCharArray();
                    continue;
                }
                cmdLine.setCommandName("config password").throwUnexpectedArgument();
            } while (cmdLine.hasNext());
            if (cmdLine.isExecMode()) {
                boolean admin = repository == null ? NWorkspaceSecurityManager.of().isAllowed("admin") : repository.security().isAllowed("admin");
                if (oldPassword == null && !admin) {
                    oldPassword = session.getTerminal().readPassword(NMsg.ofPlain("Old Password:"));
                }
                if (password == null) {
                    password = session.getTerminal().readPassword(NMsg.ofPlain("Password:"));
                }
                if (repository == null) {
                    NWorkspaceSecurityManager.of().updateUser(user).setCredentials(password).setOldCredentials(oldPassword).run();
                } else {
                    repository.security().updateUser(user).setCredentials(password).setOldCredentials(oldPassword).run();
                }
                NWorkspace.of().saveConfig();
            }
            return true;
        }
        if (cmdLine.next("edit user", "eu").isPresent()) {
            NRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next("--repo", "-r").isPresent()) {
                repository = NWorkspace.of().findRepository(cmdLine.nextNonOption(NArgName.of("RepositoryId")).get().image()).get();
            }
            String user = cmdLine.nextNonOption(NArgName.of("Username")).get().image();
            if (cmdLine.isExecMode()) {
                NUser u = null;
                u = repository == null ? NWorkspaceSecurityManager.of().findUser(user) : repository.security().getEffectiveUser(user);
                if (u == null) {
                    throw new NElementNotFoundException(NMsg.ofC("no such user %s", user));
                }
            }
            String lastOption = "";
            block18: while (cmdLine.hasNext()) {
                if (cmdLine.next("--add-group").isPresent()) {
                    lastOption = "--add-group";
                    continue;
                }
                if (cmdLine.next("--remove-group").isPresent()) {
                    lastOption = "--remove-group";
                    continue;
                }
                if (cmdLine.next("--add-right").isPresent()) {
                    lastOption = "--add-right";
                    continue;
                }
                if (cmdLine.next("--remove-right").isPresent()) {
                    lastOption = "--remove-right";
                    continue;
                }
                if (cmdLine.next("--mapped-user").isPresent()) {
                    lastOption = "--mapped-user";
                    continue;
                }
                if (cmdLine.next("--password").isPresent()) {
                    lastOption = "--password";
                    continue;
                }
                switch (lastOption) {
                    case "--add-group": {
                        String a = cmdLine.nextNonOption(NArgName.of("Group")).get().image();
                        if (!cmdLine.isExecMode()) continue block18;
                        if (repository != null) {
                            repository.security().updateUser(user).addGroup(a).run();
                            continue block18;
                        }
                        NWorkspaceSecurityManager.of().updateUser(user).addGroup(a).run();
                        continue block18;
                    }
                    case "--remove-group": {
                        String a = cmdLine.nextNonOption(NArgName.of("Group")).get().image();
                        if (!cmdLine.isExecMode()) continue block18;
                        if (repository != null) {
                            repository.security().updateUser(user).removeGroup(a).run();
                            continue block18;
                        }
                        NWorkspaceSecurityManager.of().updateUser(user).removeGroup(a).run();
                        continue block18;
                    }
                    case "--add-right": {
                        String a = cmdLine.nextNonOption(NArgName.of("Right")).get().image();
                        if (!cmdLine.isExecMode()) continue block18;
                        if (repository != null) {
                            repository.security().updateUser(user).addPermission(a).run();
                            continue block18;
                        }
                        NWorkspaceSecurityManager.of().updateUser(user).addPermission(a).run();
                        continue block18;
                    }
                    case "--remove-right": {
                        String a = cmdLine.nextNonOption(NArgName.of("Right")).get().image();
                        if (!cmdLine.isExecMode()) continue block18;
                        if (repository != null) {
                            repository.security().updateUser(user).removePermission(a).run();
                            continue block18;
                        }
                        NWorkspaceSecurityManager.of().updateUser(user).removePermission(a).run();
                        continue block18;
                    }
                    case "--mapped-user": {
                        String a = cmdLine.nextNonOption(NArgName.of("RemoteIdentity")).get().image();
                        if (!cmdLine.isExecMode()) continue block18;
                        if (repository != null) {
                            repository.security().updateUser(user).setRemoteIdentity(a).run();
                            continue block18;
                        }
                        NWorkspaceSecurityManager.of().updateUser(user).setRemoteIdentity(a).run();
                        continue block18;
                    }
                    case "--password": {
                        char[] pwd = cmdLine.nextNonOption(NArgName.of("password", "Password")).get().image().toCharArray();
                        char[] old = cmdLine.nextNonOption(NArgName.of("password", "OldPassword")).get().image().toCharArray();
                        if (cmdLine.isExecMode()) {
                            if (repository != null) {
                                repository.security().updateUser(user).setCredentials(pwd).setOldCredentials(old).run();
                            } else {
                                NWorkspaceSecurityManager.of().updateUser(user).setCredentials(pwd).setOldCredentials(old).run();
                            }
                        }
                        Arrays.fill(pwd, '\u0000');
                        Arrays.fill(old, '\u0000');
                        continue block18;
                    }
                }
                cmdLine.setCommandName("config edit user").throwUnexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                NWorkspace.of().saveConfig();
            }
            return true;
        }
        if (cmdLine.next("unsecure").isPresent()) {
            NRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next("--repo", "-r").isPresent()) {
                repository = NWorkspace.of().findRepository(cmdLine.nextNonOption(NArgName.of("RepositoryId")).get().image()).get();
            }
            if (cmdLine.isExecMode()) {
                char[] credentials = null;
                if (!NWorkspaceSecurityManager.of().isAdmin()) {
                    credentials = session.getTerminal().readPassword(NMsg.ofPlain("Enter password : "));
                }
                if (NWorkspaceSecurityManager.of().setSecureMode(false, credentials)) {
                    out.println("<<unsecure box activated.Anonymous has all rights.>>");
                } else {
                    out.println("<<unsecure box is already activated.>>");
                }
                if (credentials != null) {
                    Arrays.fill(credentials, '\u0000');
                }
            }
            NWorkspace.of().saveConfig();
            return true;
        }
        if (cmdLine.next("secure").isPresent()) {
            char[] credentials = null;
            if (!NWorkspaceSecurityManager.of().isAdmin()) {
                credentials = session.getTerminal().readPassword(NMsg.ofPlain("Enter password : "));
            }
            NRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next("--repo", "-r").isPresent()) {
                repository = NWorkspace.of().findRepository(cmdLine.nextNonOption(NArgName.of("RepositoryId")).get().image()).get();
            }
            if (cmdLine.isExecMode()) {
                if (NWorkspaceSecurityManager.of().setSecureMode(true, credentials)) {
                    out.println("\"\"secure box activated.\"\"");
                } else {
                    out.println("\"\"secure box already activated.\"\"");
                }
            }
            if (credentials != null) {
                Arrays.fill(credentials, '\u0000');
            }
            NWorkspace.of().saveConfig();
            return true;
        }
        return false;
    }
}

