/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import net.thevpc.nuts.core.NConstants;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.repository.config.NRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user.AbstractNUpdateUserCmd;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NRepositoryConfigManagerExt;
import net.thevpc.nuts.security.NUpdateUserCmd;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultNUpdateUserCmd
extends AbstractNUpdateUserCmd {
    public DefaultNUpdateUserCmd(NWorkspace workspace) {
        super(workspace);
    }

    @Override
    public NUpdateUserCmd run() {
        NWorkspaceSecurityManager sec = NWorkspaceSecurityManager.of();
        if (this.getCredentials() != null && !NBlankable.isBlank(new String(this.getCredentials()))) {
            sec.checkAllowed("set-password", "set-user-credentials");
            String currentLogin = sec.getCurrentUsername();
            if (NBlankable.isBlank(this.login)) {
                if (!"anonymous".equals(currentLogin)) {
                    this.login = currentLogin;
                } else {
                    throw new NIllegalArgumentException(NMsg.ofPlain("not logged in"));
                }
            }
            if (this.repository != null) {
                NRepositoryConfigModel rconf = NRepositoryConfigManagerExt.of(this.repository.config()).getModel();
                NUserConfig u = rconf.findUser(this.login).get();
                this.fillNutsUserConfig(u);
                rconf.setUser(u);
            } else {
                DefaultNWorkspaceConfigModel wconf = NWorkspaceExt.of().getConfigModel();
                NUserConfig u = wconf.getUser(this.login);
                if (u == null) {
                    throw new NIllegalArgumentException(NMsg.ofC("no such user %s", this.login));
                }
                this.fillNutsUserConfig(u);
                wconf.setUser(u);
            }
        }
        return this;
    }

    protected void fillNutsUserConfig(NUserConfig u) {
        NWorkspaceSecurityManager wsec = NWorkspaceSecurityManager.of();
        String currentLogin = wsec.getCurrentUsername();
        if (!currentLogin.equals(this.login)) {
            this.repository.security().checkAllowed("admin", "set-user-credentials");
        }
        if (!wsec.isAllowed("admin")) {
            wsec.checkCredentials(u.getCredentials().toCharArray(), this.getOldCredentials());
        }
        if (this.getCredentials() != null) {
            u.setCredentials(CoreStringUtils.chrToStr(wsec.createCredentials(this.getCredentials(), false, CoreStringUtils.strToChr(u.getCredentials()))));
        }
        if (this.getRemoteCredentials() != null) {
            u.setRemoteCredentials(CoreStringUtils.chrToStr(wsec.createCredentials(this.getRemoteCredentials(), true, CoreStringUtils.strToChr(u.getRemoteCredentials()))));
        }
        if (this.resetGroups) {
            u.setGroups(Collections.emptyList());
        }
        if (this.resetPermissions) {
            u.setPermissions(Collections.emptyList());
        }
        LinkedHashSet g = new LinkedHashSet(u.getGroups() == null ? new ArrayList() : u.getGroups());
        g.addAll(this.groups);
        for (String group : this.rm_groups) {
            g.remove(group);
        }
        u.setGroups(new ArrayList<String>(g));
        LinkedHashSet<String> r = new LinkedHashSet<String>(u.getPermissions() == null ? new ArrayList() : u.getPermissions());
        for (String group : this.permissions) {
            if (!NConstants.Permissions.ALL.contains(group.toLowerCase()) && !NConstants.Permissions.ALL.contains("!" + group.toLowerCase())) continue;
            r.add(group);
        }
        for (String group : this.rm_permissions) {
            r.remove(group);
        }
        u.setPermissions(new ArrayList<String>(r));
        if (this.remoteIdentity != null) {
            u.setRemoteIdentity(this.remoteIdentity);
        }
        if (this.remoteCredentials != null) {
            u.setRemoteCredentials(this.remoteIdentity);
        }
    }
}

