/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user;

import net.thevpc.nuts.core.NRepositorySecurityManager;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user.AbstractNAddUserCmd;
import net.thevpc.nuts.runtime.standalone.workspace.config.NRepositoryConfigManagerExt;
import net.thevpc.nuts.security.NAddUserCmd;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultNAddUserCmd
extends AbstractNAddUserCmd {
    public DefaultNAddUserCmd(NWorkspace workspace) {
        super(workspace);
    }

    @Override
    public NAddUserCmd run() {
        if (NBlankable.isBlank(this.getUsername())) {
            throw new NIllegalArgumentException(NMsg.ofPlain("invalid user"));
        }
        if (this.repository != null) {
            NRepositorySecurityManager sec = this.repository.security();
            NUserConfig security = new NUserConfig(this.getUsername(), CoreStringUtils.chrToStr(sec.createCredentials(this.getCredentials(), false, null)), this.getGroups(), this.getPermissions());
            security.setRemoteIdentity(this.getRemoteIdentity());
            security.setRemoteCredentials(CoreStringUtils.chrToStr(sec.createCredentials(this.getRemoteCredentials(), true, null)));
            NRepositoryConfigManagerExt.of(this.repository.config()).getModel().setUser(security);
        } else {
            NWorkspaceSecurityManager sec = NWorkspaceSecurityManager.of();
            NUserConfig security = new NUserConfig(this.getUsername(), CoreStringUtils.chrToStr(sec.createCredentials(this.getCredentials(), false, null)), this.getGroups(), this.getPermissions());
            security.setRemoteIdentity(this.getRemoteIdentity());
            security.setRemoteCredentials(CoreStringUtils.chrToStr(sec.createCredentials(this.getRemoteCredentials(), true, null)));
            NWorkspaceExt.of().getConfigModel().setUser(security);
        }
        return this;
    }
}

