/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NWorkspaceCmdBaseRepo;
import net.thevpc.nuts.security.NAddUserCmd;
import net.thevpc.nuts.util.NScorableContext;

public abstract class AbstractNAddUserCmd
extends NWorkspaceCmdBaseRepo<NAddUserCmd>
implements NAddUserCmd {
    protected String login;
    protected String remoteIdentity;
    protected char[] remoteCredentials;
    protected char[] password;
    protected final Set<String> permissions = new HashSet<String>();
    protected final Set<String> groups = new HashSet<String>();

    public AbstractNAddUserCmd(NWorkspace workspace) {
        super("add-user");
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public String getUsername() {
        return this.login;
    }

    @Override
    public AbstractNAddUserCmd setUsername(String username) {
        this.login = username;
        return this;
    }

    @Override
    public char[] getCredentials() {
        return this.password;
    }

    @Override
    public AbstractNAddUserCmd setCredentials(char[] password) {
        this.password = password;
        return this;
    }

    @Override
    public char[] getRemoteCredentials() {
        return this.remoteCredentials;
    }

    @Override
    public AbstractNAddUserCmd setRemoteCredentials(char[] password) {
        this.remoteCredentials = password;
        return this;
    }

    @Override
    public String getRemoteIdentity() {
        return this.remoteIdentity;
    }

    @Override
    public AbstractNAddUserCmd setRemoteIdentity(String remoteIdentity) {
        this.remoteIdentity = remoteIdentity;
        return this;
    }

    @Override
    public AbstractNAddUserCmd addPermissions(String ... permissions) {
        if (permissions != null) {
            return this.addPermissions(Arrays.asList(permissions));
        }
        return this;
    }

    @Override
    public AbstractNAddUserCmd removePermissions(String ... permissions) {
        if (permissions != null) {
            return this.removePermissions(Arrays.asList(permissions));
        }
        return this;
    }

    @Override
    public AbstractNAddUserCmd addPermissions(Collection<String> permissions) {
        if (permissions != null) {
            for (String permission : permissions) {
                if (permission == null) continue;
                this.permissions.add(permission);
            }
        }
        return this;
    }

    @Override
    public AbstractNAddUserCmd removePermissions(Collection<String> permissions) {
        if (permissions != null) {
            for (String permission : permissions) {
                if (permission == null) continue;
                this.permissions.remove(permission);
            }
        }
        return this;
    }

    @Override
    public AbstractNAddUserCmd addGroups(String ... groups) {
        if (groups != null) {
            return this.addPermissions(Arrays.asList(groups));
        }
        return this;
    }

    @Override
    public AbstractNAddUserCmd removeGroups(String ... groups) {
        if (groups != null) {
            return this.removeGroups(Arrays.asList(groups));
        }
        return this;
    }

    @Override
    public AbstractNAddUserCmd addGroup(String group) {
        if (group != null) {
            this.groups.add(group);
        }
        return this;
    }

    @Override
    public AbstractNAddUserCmd addPermission(String permission) {
        if (permission != null) {
            this.permissions.add(permission);
        }
        return this;
    }

    @Override
    public AbstractNAddUserCmd addGroups(Collection<String> groups) {
        if (groups != null) {
            for (String right : groups) {
                if (right == null) continue;
                this.groups.add(right);
            }
        }
        return this;
    }

    @Override
    public AbstractNAddUserCmd removeGroups(Collection<String> groups) {
        if (groups != null) {
            for (String right : groups) {
                if (right == null) continue;
                this.groups.remove(right);
            }
        }
        return this;
    }

    @Override
    public List<String> getPermissions() {
        return new ArrayList<String>(this.permissions);
    }

    @Override
    public List<String> getGroups() {
        return new ArrayList<String>(this.groups);
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().get();
        if (a == null) {
            return false;
        }
        switch (a.key()) {
            default: 
        }
        return super.configureFirst(cmdLine);
    }
}

