/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.updatestats;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.thevpc.nuts.command.NUpdateStatsCmd;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.updatestats.AbstractNUpdateStatsCmd;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultNUpdateStatsCmd
extends AbstractNUpdateStatsCmd {
    public DefaultNUpdateStatsCmd(NWorkspace workspace) {
        super(workspace);
    }

    @Override
    public NUpdateStatsCmd run() {
        boolean processed = false;
        NSession session = NSession.of();
        for (String repository : this.getRepositories()) {
            processed = true;
            NRepository repo = NWorkspace.of().findRepository(repository).get();
            NRepositorySPI repoSPI = NWorkspaceUtils.of().toRepositorySPI(repo);
            repoSPI.updateStatistics().run();
        }
        for (Path repositoryPath : this.getPaths()) {
            processed = true;
            NAssert.requireNonBlank(repositoryPath, "location");
            if (!Files.isDirectory(repositoryPath, new LinkOption[0])) {
                throw new NIllegalArgumentException(NMsg.ofC("expected folder at location %s", repositoryPath));
            }
            File[] mavenRepoRootFiles = repositoryPath.toFile().listFiles(x -> x.getName().equals("index.html") || x.getName().equals("plugin-management.html") || x.getName().equals("distribution-management.html") || x.getName().equals("dependency-info.html") || x.getName().equals("dependency-convergence.html") || x.getName().equals("dependencies.html") || x.getName().equals("plugins.html") || x.getName().equals("project-info.html") || x.getName().equals("project-summary.html"));
            if (mavenRepoRootFiles != null && mavenRepoRootFiles.length > 3) {
                new MavenRepositoryFolderHelper(null, NPath.of(repositoryPath)).reindexFolder();
                if (!session.isPlainTrace()) continue;
                session.getTerminal().out().resetLine().println(NMsg.ofC("[%s] updated maven index %s", NWorkspace.of().getWorkspaceLocation(), repositoryPath));
                continue;
            }
            File[] nutsRepoRootFiles = repositoryPath.toFile().listFiles(x -> x.getName().equals("nuts-repository.json"));
            if (nutsRepoRootFiles == null || nutsRepoRootFiles.length <= 0) {
                throw new NIllegalArgumentException(NMsg.ofPlain("unsupported repository folder"));
            }
            new NRepositoryFolderHelper(null, NPath.of(repositoryPath), false, "stats", null).reindexFolder();
            if (!session.isPlainTrace()) continue;
            NOut.resetLine().println(NMsg.ofC("[%s] updated stats %s", NWorkspace.of().getWorkspaceLocation(), repositoryPath));
        }
        if (!processed) {
            if (session.isPlainTrace()) {
                NOut.resetLine().println(NMsg.ofC("%s updating workspace stats", NWorkspace.of().getWorkspaceLocation()));
            }
            for (NRepository repo : NWorkspace.of().getRepositories()) {
                if (session.isPlainTrace()) {
                    NOut.resetLine().println(NMsg.ofC("%s updating stats %s", NWorkspace.of().getWorkspaceLocation(), repo));
                }
                NWorkspaceUtils.of().toRepositorySPI(repo).updateStatistics().run();
            }
        }
        return this;
    }

    @Override
    public void add(String repo) {
        NAssert.requireNonBlank(repo, "repository or path");
        if (repo.equals(".") || repo.equals("..") || repo.contains("/") || repo.contains("\\")) {
            this.addPath(Paths.get(repo, new String[0]));
        } else {
            this.addRepo(repo);
        }
    }
}

