/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.repo;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NArgName;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNSettingsSubCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user.NSettingsUserSubCommand;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMutableTableModel;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextArt;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NBooleanRef;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NRef;

public class NSettingsRepositorySubCommand
extends AbstractNSettingsSubCommand {
    public NSettingsRepositorySubCommand(NWorkspace workspace) {
    }

    public static RepoInfo repoInfo(NRepository x, boolean tree) {
        return new RepoInfo(x.getName(), x.config().getType(), x.config().getLocationPath(), x.config().isEnabled() ? RepoStatus.enabled : RepoStatus.disabled, tree ? (RepoInfo[])x.config().getMirrors().stream().map(e -> NSettingsRepositorySubCommand.repoInfo(e, tree)).toArray(RepoInfo[]::new) : null, x.config().isTemporary(), x.config().isPreview(), x.config().getTags().toArray(new String[0]));
    }

    @Override
    public boolean exec(NCmdLine cmdLine, Boolean autoSave) {
        NWorkspace workspace = NWorkspace.of();
        NSession session = NSession.of();
        NPrintStream out = session.out();
        if (cmdLine.next("add repo", "ar").isPresent()) {
            this.doAddRepo(cmdLine, out);
            return true;
        }
        if (cmdLine.next("remove repo", "rr").isPresent()) {
            this.doRemoveRepo(cmdLine, out);
            return true;
        }
        if (cmdLine.next("list repos", "lr").isPresent()) {
            this.doListRepo(cmdLine, out);
            return true;
        }
        if (cmdLine.next("enable repo", "er").isPresent()) {
            this.enableRepo(cmdLine, autoSave, session, true);
            return true;
        }
        if (cmdLine.next("disable repo", "dr").isPresent()) {
            this.enableRepo(cmdLine, autoSave, session, false);
            return true;
        }
        if (cmdLine.next("edit repo", "er").isPresent()) {
            String repoId = (String)cmdLine.nextNonOption(NArgName.of("RepositoryName")).flatMap(NArg::asString).get();
            if (cmdLine.next("add repo", "ar").isPresent()) {
                String repositoryName = (String)cmdLine.nextNonOption(NArgName.of("NewRepositoryName")).flatMap(NArg::asString).get();
                String location = (String)cmdLine.nextNonOption(NArgName.of("folder")).flatMap(NArg::asString).get();
                NRepository editedRepo = workspace.findRepository(repoId).get();
                NRepository repo = editedRepo.config().addMirror(new NAddRepositoryOptions().setName(repositoryName).setLocation(repositoryName).setConfig(new NRepositoryConfig().setName(repositoryName).setLocation(NRepositoryLocation.of(location))));
                workspace.saveConfig();
            } else if (cmdLine.next("remove repo", "rr").isPresent()) {
                String location = (String)cmdLine.nextNonOption(NArgName.of("RepositoryName")).flatMap(NArg::asString).get();
                NRepository editedRepo = workspace.findRepository(repoId).get();
                editedRepo.config().removeMirror(location);
                workspace.saveConfig();
            } else if (cmdLine.next("enable", "br").isPresent()) {
                NRepository editedRepo = workspace.findRepository(repoId).get();
                editedRepo.config().setEnabled(true);
                workspace.saveConfig();
            } else if (cmdLine.next("disable", "dr").isPresent()) {
                NRepository editedRepo = workspace.findRepository(repoId).get();
                editedRepo.config().setEnabled(true);
                workspace.saveConfig();
            } else if (cmdLine.next("list repos", "repo list", "list repo", "lr").isPresent()) {
                NRepository editedRepo = workspace.findRepository(repoId).get();
                List<NRepository> linkRepositories = editedRepo.config().isSupportedMirroring() ? editedRepo.config().getMirrors() : Collections.emptyList();
                out.println(NMsg.ofC("%s sub repositories.", linkRepositories.size()));
                NMutableTableModel m = NMutableTableModel.of();
                m.addHeaderRow(NText.ofPlain("Id"), NText.ofPlain("Enabled"), NText.ofPlain("Type"), NText.ofPlain("Location"));
                while (cmdLine.hasNext()) {
                    if (NSession.of().configureFirst(cmdLine)) continue;
                    cmdLine.setCommandName("config edit repo").throwUnexpectedArgument();
                }
                for (NRepository repository : linkRepositories) {
                    NText[] nTextArray = new NText[4];
                    nTextArray[0] = NText.ofStyledPrimary4(repository.getName());
                    nTextArray[1] = repository.config().isEnabled() ? (repository.isEnabled() ? NText.ofStyled("ENABLED", NTextStyle.success()) : NText.ofStyled("<RT-DISABLED>", NTextStyle.error())) : NText.ofStyled("<DISABLED>", NTextStyle.error());
                    nTextArray[2] = NText.of(repository.getRepositoryType());
                    nTextArray[3] = NText.of(repository.config().getLocation());
                    m.addRow(nTextArray);
                }
                out.print(NTextArt.of().getTableRenderer().get().render(m));
            } else if (cmdLine.next("-h", "-?", "--help").isPresent()) {
                out.println(NMsg.ofC("edit repository %s add repo ...", repoId));
                out.println(NMsg.ofC("edit repository %s remove repo ...", repoId));
                out.println(NMsg.ofC("edit repository %s list repos ...", repoId));
            } else {
                NRepository editedRepo = workspace.findRepository(repoId).get();
                if (!NSettingsUserSubCommand.exec(editedRepo, cmdLine, autoSave)) {
                    throw new NIllegalArgumentException(NMsg.ofC("config edit repo: Unsupported command %s", cmdLine));
                }
            }
            return true;
        }
        return false;
    }

    private void doListRepo(NCmdLine cmdLine, NPrintStream out) {
        cmdLine.setCommandName("config list repos");
        NRef<String> parent = NRef.ofNull(String.class);
        NBooleanRef longFormat = NRef.ofFalse();
        NSession session = NSession.of();
        while (cmdLine.hasNext()) {
            block10: while (cmdLine.hasNext()) {
                NArg aa = cmdLine.peek().get();
                boolean enabled = aa.isUncommented();
                switch (aa.key()) {
                    case "--parent": {
                        cmdLine.matcher().matchEntry(v -> parent.set(v.stringValue())).anyMatch();
                        continue block10;
                    }
                    case "-l": 
                    case "--long": {
                        cmdLine.matcher().matchFlag(v -> longFormat.set(v.booleanValue())).anyMatch();
                        continue block10;
                    }
                }
                if (session.configureFirst(cmdLine)) continue;
                if (aa.isOption()) {
                    cmdLine.throwUnexpectedArgument();
                    continue;
                }
                if (parent.isNotNull()) {
                    cmdLine.throwUnexpectedArgument();
                    continue;
                }
                parent.set((String)cmdLine.next().flatMap(NArg::asString).get());
            }
        }
        if (cmdLine.isExecMode()) {
            NWorkspace workspace = NWorkspace.of();
            List<NRepository> r = parent.isNull() ? workspace.getRepositories() : workspace.findRepository(parent.get()).get().config().getMirrors();
            RepoInfo[] array = (RepoInfo[])r.stream().map(x -> NSettingsRepositorySubCommand.repoInfo(x, session.getOutputFormat().orDefault() != NContentType.TABLE && session.getOutputFormat().orDefault() != NContentType.PLAIN)).toArray(RepoInfo[]::new);
            NContentType cf = NSession.of().getOutputFormat().orElse(NContentType.PLAIN);
            if (((Boolean)longFormat.get()).booleanValue()) {
                if (cf == NContentType.PLAIN) {
                    for (RepoInfo repoInfo : array) {
                        out.println(repoInfo.name);
                    }
                } else {
                    out.println(array);
                }
            } else if (cf == NContentType.PLAIN) {
                NMutableTableModel model = NMutableTableModel.of();
                for (RepoInfo repoInfo : array) {
                    model.addRow(NText.of(repoInfo.name), NText.of((Object)repoInfo.enabled), NText.of(repoInfo.location), NText.of(repoInfo.tags));
                }
                out.println(NTextArt.of().getTableRenderer("table:spaces").get().render(model));
            } else {
                out.println(array);
            }
        }
    }

    private void doRemoveRepo(NCmdLine cmdLine, NPrintStream out) {
        NRef<String> repositoryName = NRef.ofNull(String.class);
        NRef<String> parent = NRef.ofNull(String.class);
        NSession session = NSession.of();
        block8: while (cmdLine.hasNext()) {
            NArg aa = cmdLine.peek().get();
            boolean enabled = aa.isUncommented();
            switch (aa.key()) {
                case "--name": {
                    cmdLine.matcher().matchEntry(v -> repositoryName.set(v.stringValue())).anyMatch();
                    continue block8;
                }
                case "--parent": {
                    cmdLine.matcher().matchEntry(v -> parent.set(v.stringValue())).anyMatch();
                    continue block8;
                }
            }
            if (session.configureFirst(cmdLine)) continue;
            if (aa.isOption()) {
                cmdLine.throwUnexpectedArgument();
                continue;
            }
            if (repositoryName.isNotNull()) {
                cmdLine.throwUnexpectedArgument();
                continue;
            }
            repositoryName.set((String)cmdLine.next().flatMap(NArg::asString).get());
        }
        if (repositoryName.isNull()) {
            cmdLine.peek().get();
        }
        if (cmdLine.isExecMode()) {
            if (parent.isNull()) {
                NWorkspace.of().removeRepository(repositoryName.get());
            } else {
                NRepository p = NWorkspace.of().findRepository(parent.get()).get();
                p.config().removeMirror(repositoryName.get());
            }
            NWorkspace.of().saveConfig();
        }
    }

    private void doAddRepo(NCmdLine cmdLine, NPrintStream out) {
        NSession session = NSession.of();
        class Data {
            String location = null;
            String repositoryName = null;
            String parent = null;
            Map<String, String> env = new LinkedHashMap<String, String>();

            Data() {
            }
        }
        Data d = new Data();
        block13: while (cmdLine.hasNext()) {
            String loc2;
            NArg aa = cmdLine.peek().get();
            boolean enabled = aa.isUncommented();
            switch (aa.key()) {
                case "-l": 
                case "--location": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.location = v.stringValue();
                    }).anyMatch();
                    continue block13;
                }
                case "--name": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.repositoryName = v.stringValue();
                    }).anyMatch();
                    continue block13;
                }
                case "--parent": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.parent = v.stringValue();
                    }).anyMatch();
                    continue block13;
                }
                case "--env": {
                    cmdLine.matcher().matchEntry(v -> {
                        NArg vv = NArg.of(v.stringValue());
                        d.env.put(vv.getKey() == null ? null : vv.key(), vv.getValue() == null ? null : vv.getStringValue().get());
                    }).anyMatch();
                    continue block13;
                }
            }
            if (session.configureFirst(cmdLine)) continue;
            if (aa.isOption()) {
                cmdLine.throwUnexpectedArgument();
                continue;
            }
            if (aa.isKeyValue()) {
                NArg n = cmdLine.nextEntry().get();
                d.repositoryName = n.getStringKey().get();
                d.location = n.getStringValue().get();
                continue;
            }
            d.location = (String)cmdLine.next().flatMap(NArg::asString).get();
            NAddRepositoryOptions ro = NRepositoryDB.of().getRepositoryOptionsByName(d.location).orNull();
            String string = loc2 = ro == null ? null : ro.getConfig().getLocation().getFullLocation();
            if (loc2 != null) {
                d.repositoryName = d.location;
                d.location = loc2;
                continue;
            }
            cmdLine.peek().get();
        }
        if (d.repositoryName == null) {
            cmdLine.peek().get();
        }
        if (cmdLine.isExecMode()) {
            NRepository repo = null;
            NAddRepositoryOptions o = new NAddRepositoryOptions().setName(d.repositoryName).setLocation(d.repositoryName).setConfig(d.location == null ? null : new NRepositoryConfig().setName(d.repositoryName).setLocation(NRepositoryLocation.of(d.location)).setEnv(d.env));
            if (d.parent == null) {
                repo = NWorkspace.of().addRepository(o);
            } else {
                NRepository p = NWorkspace.of().findRepository(d.parent).get();
                repo = p.config().addMirror(o);
            }
            out.println(NMsg.ofC("repository %s added successfully", repo.getName()));
            NWorkspace.of().saveConfig();
        }
        cmdLine.setCommandName("config add repo").throwUnexpectedArgument();
    }

    private void enableRepo(NCmdLine cmdLine, Boolean autoSave, NSession session, boolean enableRepo) {
        NRef<String> repositoryName = NRef.ofNull(String.class);
        block6: while (cmdLine.hasNext()) {
            NArg aa = cmdLine.peek().get();
            boolean enabled = aa.isUncommented();
            switch (aa.key()) {
                case "--name": {
                    cmdLine.matcher().matchEntry(v -> repositoryName.set(v.stringValue())).anyMatch();
                    continue block6;
                }
            }
            if (session.configureFirst(cmdLine)) continue;
            if (aa.isOption()) {
                cmdLine.throwUnexpectedArgument();
                continue;
            }
            if (repositoryName.isNull()) {
                repositoryName.set((String)cmdLine.next().flatMap(NArg::asString).get());
                continue;
            }
            cmdLine.throwUnexpectedArgument();
        }
        if (repositoryName.isNull()) {
            cmdLine.peek().get();
        }
        if (cmdLine.isExecMode()) {
            NWorkspace workspace = NWorkspace.of();
            NRepository editedRepo = workspace.findRepository(repositoryName.get()).get();
            editedRepo.config().setEnabled(enableRepo);
            workspace.saveConfig();
        }
    }

    public static class RepoInfo {
        String name;
        String type;
        NPath location;
        boolean temporary;
        boolean preview;
        RepoStatus enabled;
        RepoInfo[] mirrors;
        String[] tags;

        public RepoInfo(String name, String type, NPath location, RepoStatus enabled, RepoInfo[] mirrors, boolean temporary, boolean preview, String[] tags) {
            this.name = name;
            this.type = type;
            this.location = location;
            this.enabled = enabled;
            this.mirrors = mirrors;
            this.preview = preview;
            this.temporary = temporary;
            this.tags = tags;
        }

        public RepoInfo() {
        }

        public RepoInfo setTemporary(boolean temporary) {
            this.temporary = temporary;
            return this;
        }

        public RepoInfo setPreview(boolean preview) {
            this.preview = preview;
            return this;
        }

        public RepoInfo setMirrors(RepoInfo[] mirrors) {
            this.mirrors = mirrors;
            return this;
        }

        public String[] getTags() {
            return this.tags;
        }

        public RepoInfo setTags(String[] tags) {
            this.tags = tags;
            return this;
        }

        public boolean isTemporary() {
            return this.temporary;
        }

        public boolean isPreview() {
            return this.preview;
        }

        public RepoInfo[] getMirrors() {
            return this.mirrors;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public NPath getLocation() {
            return this.location;
        }

        public void setLocation(NPath location) {
            this.location = location;
        }

        public RepoStatus getEnabled() {
            return this.enabled;
        }

        public void setEnabled(RepoStatus enabled) {
            this.enabled = enabled;
        }
    }

    public static enum RepoStatus {
        enabled,
        disabled;

    }
}

