/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.xtra.shell.AbstractScriptBuilder;
import net.thevpc.nuts.runtime.standalone.xtra.shell.NShellHelper;

public class SimpleScriptBuilder
extends AbstractScriptBuilder {
    private BaseSystemNdi sndi;
    private List<String> lines = new ArrayList<String>();

    public SimpleScriptBuilder(NShellFamily shellFamily, String type, NId anyId, BaseSystemNdi sndi) {
        super(shellFamily, type, anyId);
        this.sndi = sndi;
    }

    public SimpleScriptBuilder printCall(String line, String ... args) {
        return this.println(NShellHelper.of(this.getShellFamily()).getCallScriptCommand(line, args));
    }

    public SimpleScriptBuilder printSet(String var, String value) {
        return this.println(NShellHelper.of(this.getShellFamily()).getSetVarCommand(var, value));
    }

    public SimpleScriptBuilder printSetStatic(String var, String value) {
        return this.println(NShellHelper.of(this.getShellFamily()).getSetVarStaticCommand(var, value));
    }

    public SimpleScriptBuilder printComment(String line) {
        for (String s : this._split(line)) {
            this.println(NShellHelper.of(this.getShellFamily()).toCommentLine(s));
        }
        return this;
    }

    private List<String> _split(String line) {
        ArrayList<String> a = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(line));
        try {
            String c;
            while ((c = br.readLine()) != null) {
                a.add(c);
            }
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        return a;
    }

    private List<String> currBody() {
        return this.lines;
    }

    public SimpleScriptBuilder println(String line) {
        this.currBody().addAll(this._split(line));
        return this;
    }

    @Override
    public String buildString() {
        return String.join((CharSequence)NShellHelper.of(this.getShellFamily()).newlineString(), this.lines);
    }

    @Override
    public SimpleScriptBuilder setPath(Path path) {
        return (SimpleScriptBuilder)super.setPath(path);
    }

    @Override
    public SimpleScriptBuilder setPath(String preferredName) {
        return (SimpleScriptBuilder)super.setPath(preferredName);
    }
}

