/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.script;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.util.NdiUtils;
import net.thevpc.nuts.runtime.standalone.xtra.shell.AbstractScriptBuilder;
import net.thevpc.nuts.runtime.standalone.xtra.shell.NShellHelper;

public class FromTemplateScriptBuilder
extends AbstractScriptBuilder {
    private final BaseSystemNdi sndi;
    private String templateName;
    private final Map<String, List<String>> bodyMap = new LinkedHashMap<String, List<String>>();
    private String currBody = "BODY";
    private Function<String, String> mapper;
    private final NdiScriptOptions options;

    public FromTemplateScriptBuilder(String templateName, NShellFamily shellFamily, String type, NId anyId, BaseSystemNdi sndi, NdiScriptOptions options) {
        super(shellFamily, type, anyId);
        this.sndi = sndi;
        this.options = options;
        this.templateName = templateName;
    }

    public FromTemplateScriptBuilder printCall(String line, String ... args) {
        return this.println(NShellHelper.of(this.getShellFamily()).getCallScriptCommand(line, args));
    }

    public FromTemplateScriptBuilder printSet(String var, String value) {
        return this.println(NShellHelper.of(this.getShellFamily()).getSetVarCommand(var, value));
    }

    public FromTemplateScriptBuilder printSetStatic(String var, String value) {
        return this.println(NShellHelper.of(this.getShellFamily()).getSetVarStaticCommand(var, value));
    }

    public FromTemplateScriptBuilder printComment(String line) {
        for (String s : this._split(line)) {
            this.println(NShellHelper.of(this.getShellFamily()).toCommentLine(s));
        }
        return this;
    }

    private List<String> _split(String line) {
        ArrayList<String> a = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(line));
        try {
            String c;
            while ((c = br.readLine()) != null) {
                a.add(c);
            }
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        return a;
    }

    private List<String> currBody() {
        return this.bodyMap.computeIfAbsent(this.currBody, v -> new ArrayList());
    }

    public FromTemplateScriptBuilder withBody(String b) {
        if (b == null || b.isEmpty()) {
            b = "BODY";
        }
        this.currBody = b;
        return this;
    }

    public FromTemplateScriptBuilder println(String line) {
        this.currBody().addAll(this._split(line));
        return this;
    }

    public Function<String, String> getMapper() {
        return this.mapper;
    }

    public FromTemplateScriptBuilder setMapper(Function<String, String> mapper) {
        this.mapper = mapper;
        return this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public FromTemplateScriptBuilder setTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    private String str(NPath path) {
        return path == null ? null : path.toString();
    }

    @Override
    public String buildString() {
        try {
            NDefinition anyIdDef = NSearchCmd.of().addId(this.getAnyId()).setLatest(true).setDependencyFilter(NDependencyFilters.of().byRunnable()).setDistinct(true).getResultDefinitions().findSingleton().get();
            final NId anyId = anyIdDef.getId();
            StringWriter bos = new StringWriter();
            try (BufferedWriter w = new BufferedWriter(bos);){
                NdiUtils.generateScript("/net/thevpc/nuts/runtime/settings/" + this.sndi.getTemplateName(this.templateName, this.getShellFamily()), w, new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        String v;
                        String string = v = FromTemplateScriptBuilder.this.mapper == null ? null : (String)FromTemplateScriptBuilder.this.mapper.apply(s);
                        if (v != null) {
                            return v;
                        }
                        switch (s) {
                            case "NUTS_ID": {
                                return anyId.getLongName();
                            }
                            case "GENERATOR": {
                                return NWorkspace.of().getRuntimeId().getLongName();
                            }
                            case "SCRIPT_NUTS": {
                                return FromTemplateScriptBuilder.this.sndi.getNutsStart(FromTemplateScriptBuilder.this.options).path().toString();
                            }
                            case "SCRIPT_NUTS_TERM_INIT": {
                                return FromTemplateScriptBuilder.this.sndi.getIncludeNutsTermInit(FromTemplateScriptBuilder.this.options)[0].path().toString();
                            }
                            case "SCRIPT_NUTS_TERM": {
                                return FromTemplateScriptBuilder.this.sndi.getNutsTerm(FromTemplateScriptBuilder.this.options)[0].path().toString();
                            }
                            case "SCRIPT_NUTS_INIT": {
                                return FromTemplateScriptBuilder.this.sndi.getIncludeNutsInit(FromTemplateScriptBuilder.this.options, FromTemplateScriptBuilder.this.getShellFamily()).path().toString();
                            }
                            case "SCRIPT_NUTS_ENV": {
                                return FromTemplateScriptBuilder.this.sndi.getIncludeNutsEnv(FromTemplateScriptBuilder.this.options, FromTemplateScriptBuilder.this.getShellFamily()).path().toString();
                            }
                            case "NUTS_APP_JAR": {
                                return FromTemplateScriptBuilder.this.options.resolveNutsAppJarPath().toString();
                            }
                            case "BIN_FOLDER": {
                                return FromTemplateScriptBuilder.this.options.resolveBinFolder().toString();
                            }
                            case "INC_FOLDER": {
                                return FromTemplateScriptBuilder.this.options.resolveIncFolder().toString();
                            }
                            case "NUTS_API_VERSION": {
                                return FromTemplateScriptBuilder.this.options.getNutsApiVersion().toString();
                            }
                            case "NUTS_API_ID": {
                                return FromTemplateScriptBuilder.this.options.resolveNutsApiId().toString();
                            }
                            case "NUTS_VERSION": {
                                return NWorkspace.of().getApiVersion().toString();
                            }
                            case "NUTS_WORKSPACE": {
                                return NWorkspace.of().getWorkspaceLocation().toString();
                            }
                            case "NUTS_WORKSPACE_BIN": {
                                return FromTemplateScriptBuilder.this.str(NPath.ofWorkspaceStore(NStoreType.BIN));
                            }
                            case "NUTS_WORKSPACE_CONF": {
                                return FromTemplateScriptBuilder.this.str(NPath.ofWorkspaceStore(NStoreType.CONF));
                            }
                            case "NUTS_WORKSPACE_CACHE": {
                                return FromTemplateScriptBuilder.this.str(NPath.ofWorkspaceStore(NStoreType.CACHE));
                            }
                            case "NUTS_WORKSPACE_LIB": {
                                return FromTemplateScriptBuilder.this.str(NPath.ofWorkspaceStore(NStoreType.LIB));
                            }
                            case "NUTS_WORKSPACE_LOG": {
                                return FromTemplateScriptBuilder.this.str(NPath.ofWorkspaceStore(NStoreType.LOG));
                            }
                            case "NUTS_WORKSPACE_RUN": {
                                return FromTemplateScriptBuilder.this.str(NPath.ofWorkspaceStore(NStoreType.RUN));
                            }
                            case "NUTS_WORKSPACE_TEMP": {
                                return FromTemplateScriptBuilder.this.str(NPath.ofWorkspaceStore(NStoreType.TEMP));
                            }
                            case "NUTS_WORKSPACE_VAR": {
                                return FromTemplateScriptBuilder.this.str(NPath.ofWorkspaceStore(NStoreType.VAR));
                            }
                            case "NUTS_APP_JAR_EXPR": {
                                String NUTS_APP_JAR_PATH = FromTemplateScriptBuilder.this.options.resolveNutsAppJarPath().toString();
                                if (NUTS_APP_JAR_PATH.startsWith(NPath.ofWorkspaceStore(NStoreType.LIB).toString())) {
                                    String pp = NUTS_APP_JAR_PATH.substring(NPath.ofWorkspaceStore(NStoreType.LIB).toString().length());
                                    return NShellHelper.of(FromTemplateScriptBuilder.this.getShellFamily()).varRef("NUTS_WORKSPACE_LIB") + pp;
                                }
                                return NUTS_APP_JAR_PATH;
                            }
                            case "NUTS_WORKSPACE_BINDIR_EXPR": {
                                return NShellHelper.of(FromTemplateScriptBuilder.this.getShellFamily()).varRef("NUTS_WORKSPACE_BIN") + FromTemplateScriptBuilder.this.options.resolveBinFolder().toString().substring(NPath.ofWorkspaceStore(NStoreType.BIN).toString().length());
                            }
                        }
                        List q = (List)FromTemplateScriptBuilder.this.bodyMap.get(s);
                        if (q != null) {
                            return String.join((CharSequence)NShellHelper.of(FromTemplateScriptBuilder.this.getShellFamily()).newlineString(), q);
                        }
                        return s;
                    }
                });
            }
            return bos.toString();
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public FromTemplateScriptBuilder setPath(Path path) {
        return (FromTemplateScriptBuilder)super.setPath(path);
    }

    @Override
    public FromTemplateScriptBuilder setPath(NPath path) {
        return (FromTemplateScriptBuilder)super.setPath(path);
    }

    @Override
    public FromTemplateScriptBuilder setPath(String preferredName) {
        return (FromTemplateScriptBuilder)super.setPath(preferredName);
    }
}

