/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceBootConfig;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NDigest;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathExtensionType;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.platform.NDesktopIntegrationItem;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformHome;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.FreeDesktopEntry;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.FreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NameBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.AbstractSystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.script.FromTemplateScriptBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.script.SimpleScriptBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;
import net.thevpc.nuts.runtime.standalone.xtra.shell.NShellHelper;
import net.thevpc.nuts.runtime.standalone.xtra.shell.ReplaceString;
import net.thevpc.nuts.runtime.standalone.xtra.shell.ScriptBuilder;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NSupportMode;

public abstract class BaseSystemNdi
extends AbstractSystemNdi {
    public static final ReplaceString COMMENT_LINE_CONFIG_HEADER = new ReplaceString("net.thevpc.nuts configuration", "((net[.]thevpc[.]nuts)|(net[.]thevpc[.]nuts.toolbox[.]ndi)|(net[.]vpc[.]app[.]nuts)) configuration");

    public NdiScriptInfo[] getSysRC(NdiScriptOptions options) {
        ArrayList<RcNdiScriptInfo> scriptInfos = new ArrayList<RcNdiScriptInfo>();
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        for (NShellFamily sf : NWorkspace.of().getShellFamilies()) {
            String z = NShellHelper.of(sf).getSysRcName();
            if (visited.contains(z)) continue;
            visited.add(z);
            RcNdiScriptInfo i = new RcNdiScriptInfo(z, options, sf);
            scriptInfos.add(i);
        }
        return scriptInfos.toArray(new NdiScriptInfo[0]);
    }

    public NdiScriptInfo[] getIncludeNutsInit(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(this.getShellGroups()).map(x -> this.getIncludeNutsInit(options, (NShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    public NdiScriptInfo getIncludeNutsInit(final NdiScriptOptions options, NShellFamily shellFamily) {
        switch (shellFamily) {
            case SH: 
            case BASH: 
            case CSH: 
            case KSH: 
            case ZSH: {
                return new NdiScriptInfo(){

                    @Override
                    public NPath path() {
                        return options.resolveIncFolder().resolve(".nuts-init.sh");
                    }

                    @Override
                    public PathInfo create() {
                        NPath apiConfigFile = this.path();
                        return BaseSystemNdi.this.scriptBuilderTemplate("nuts-init", NShellFamily.SH, "nuts-init", options.resolveNutsApiId(), options).setPath(apiConfigFile).buildAddLine(BaseSystemNdi.this);
                    }
                };
            }
            case FISH: {
                return new NdiScriptInfo(){

                    @Override
                    public NPath path() {
                        return options.resolveIncFolder().resolve(".nuts-init.fish");
                    }

                    @Override
                    public PathInfo create() {
                        NPath apiConfigFile = this.path();
                        return BaseSystemNdi.this.scriptBuilderTemplate("nuts-init", NShellFamily.FISH, "nuts-init", options.resolveNutsApiId(), options).setPath(apiConfigFile).buildAddLine(BaseSystemNdi.this);
                    }
                };
            }
        }
        return null;
    }

    public NdiScriptInfo[] getIncludeNutsTermInit(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(this.getShellGroups()).map(x -> this.getIncludeNutsTermInit(options, (NShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    protected abstract NShellFamily[] getShellGroups();

    public abstract NdiScriptInfo getIncludeNutsTermInit(NdiScriptOptions var1, NShellFamily var2);

    public FromTemplateScriptBuilder scriptBuilderTemplate(String templateName, NShellFamily shellFamily, String type, NId anyId, NdiScriptOptions options) {
        return ScriptBuilder.fromTemplate(templateName, shellFamily, type, anyId, this, options);
    }

    public SimpleScriptBuilder scriptBuilderSimple(NShellFamily shellFamily, String type, NId anyId, NdiScriptOptions options) {
        return ScriptBuilder.simple(shellFamily, type, anyId, this);
    }

    public NdiScriptInfo[] getNutsTerm(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(this.getShellGroups()).map(x -> this.getNutsTerm(options, (NShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    public abstract NdiScriptInfo getNutsTerm(NdiScriptOptions var1, NShellFamily var2);

    public NdiScriptInfo[] getIncludeNutsEnv(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(this.getShellGroups()).map(x -> this.getIncludeNutsEnv(options, (NShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    public abstract NdiScriptInfo getIncludeNutsEnv(NdiScriptOptions var1, NShellFamily var2);

    public NdiScriptInfo getNutsStart(final NdiScriptOptions options) {
        return new NdiScriptInfo(){

            @Override
            public NPath path() {
                return options.resolveBinFolder().resolve(BaseSystemNdi.this.getExecFileName("nuts"));
            }

            @Override
            public PathInfo create() {
                return null;
            }
        };
    }

    public NPath getBinScriptFile(String name, NdiScriptOptions options) {
        NPath pp = NPath.of(name);
        if (!pp.isName()) {
            return pp.toAbsolute();
        }
        return options.resolveBinFolder().resolve(this.getExecFileName(name)).toAbsolute();
    }

    protected abstract String createNutsScriptContent(NId var1, NdiScriptOptions var2, NShellFamily var3);

    @Override
    public PathInfo[] createArtifactScript(NdiScriptOptions options) {
        NId nid = NId.get(options.getId()).get();
        ArrayList<PathInfo> r = new ArrayList<PathInfo>();
        if (this.isNutsBootId(nid)) {
            r.addAll(Arrays.asList(this.createBootScripts(options.copy().setId(options.resolveNutsApiId().toString()))));
        } else {
            NDefinition appDef;
            if (options.isAddNutsScript()) {
                r.addAll(Arrays.asList(this.createBootScripts(options.copy().setId(options.resolveNutsApiId().toString()))));
            }
            NDefinition fetched = null;
            if (nid.getVersion().isBlank()) {
                fetched = NSearchCmd.of().addId(options.getId()).setLatest(true).getResultDefinitions().findFirst().get();
                nid = fetched.getId().getShortId();
            }
            String n = nid.getArtifactId();
            NPath ff = this.getBinScriptFile(n, options);
            String s = options.getLauncher().getCustomScriptPath();
            if (NBlankable.isBlank(s)) {
                appDef = this.loadIdDefinition(nid);
                s = NameBuilder.id(appDef.getId(), "%n", null, appDef.getDescriptor()).buildName();
                s = this.getBinScriptFile(s, options).toString();
            } else if (NPath.of(s).isName()) {
                appDef = this.loadIdDefinition(nid);
                s = NameBuilder.id(appDef.getId(), s, null, appDef.getDescriptor()).buildName();
                s = this.getBinScriptFile(s, options).toString();
            } else {
                appDef = this.loadIdDefinition(nid);
                s = s + File.separator + NameBuilder.id(appDef.getId(), this.getExecFileName("%n"), null, appDef.getDescriptor()).buildName();
            }
            NShellFamily shellFamily = this.getShellGroups()[0];
            r.add(this.scriptBuilderTemplate("body", shellFamily, "artifact", nid, options).setPath(s).println(this.createNutsScriptContent(nid, options, shellFamily)).build());
            if (this.matchCondition(options.getLauncher().getCreateDesktopLauncher(), this.getDesktopIntegrationSupport(NDesktopIntegrationItem.DESKTOP))) {
                r.addAll(Arrays.asList(this.createShortcut(NDesktopIntegrationItem.DESKTOP, options.copy().setId(nid.toString()))));
            }
            if (this.matchCondition(options.getLauncher().getCreateUserLauncher(), this.getDesktopIntegrationSupport(NDesktopIntegrationItem.USER))) {
                r.addAll(Arrays.asList(this.createShortcut(NDesktopIntegrationItem.USER, options.copy().setId(nid.toString()))));
            }
            if (this.matchCondition(options.getLauncher().getCreateMenuLauncher(), this.getDesktopIntegrationSupport(NDesktopIntegrationItem.MENU))) {
                r.addAll(Arrays.asList(this.createShortcut(NDesktopIntegrationItem.MENU, options.copy().setId(nid.toString()))));
            }
        }
        return r.toArray(new PathInfo[0]);
    }

    @Override
    public void removeNutsScript(String id, String switchWorkspaceLocation) {
        NdiScriptOptions options = new NdiScriptOptions();
        options.getLauncher().setSwitchWorkspaceLocation(switchWorkspaceLocation);
        NId nid = NId.get(id).get();
        NPath f = this.getBinScriptFile(nid.getArtifactId(), options);
        NTexts factory = NTexts.of();
        if (f.isRegularFile() && NAsk.of().forBoolean(NMsg.ofC("tool %s will be removed. Confirm?", factory.ofStyled(CoreIOUtils.betterPath(f.toString()), NTextStyle.path()))).setDefaultValue(true).getBooleanValue().booleanValue()) {
            f.delete();
            NSession session = NSession.of();
            if (session.isPlainTrace()) {
                NOut.println(NMsg.ofC("tool %s removed.", factory.ofStyled(CoreIOUtils.betterPath(f.toString()), NTextStyle.path())));
            }
        }
    }

    @Override
    public PathInfo[] switchWorkspace(NdiScriptOptions options) {
        options = options.copy();
        options.getLauncher().setSwitchWorkspace(true);
        PathInfo[] v = this.createBootScripts(options);
        NSession session = NSession.of();
        if (session.isPlainTrace()) {
            NOut.println(NMsg.ofC("```sh nuts``` switched to workspace %s to point to %s", options.getWorkspaceLocation(), options.getNutsApiVersion()));
        }
        return v;
    }

    @Override
    public boolean isNutsBootId(NId nid) {
        return "nuts".equals(nid.getShortName()) || "nuts-app".equals(nid.getShortName()) || "net.thevpc.nuts:nuts".equals(nid.getShortName()) || "net.thevpc.nuts:nuts-app".equals(nid.getShortName());
    }

    @Override
    public PathInfo[] addScript(NdiScriptOptions options, String[] all) {
        List<String> idsToInstall = Arrays.asList(all);
        NSession session = NSession.of();
        Path workspaceLocation = NWorkspace.of().getWorkspaceLocation().toPath().get();
        ArrayList<PathInfo> result = new ArrayList<PathInfo>();
        Boolean systemWideConfig = options.getLauncher().getSwitchWorkspace();
        if (!idsToInstall.isEmpty()) {
            NdiScriptOptions oo;
            NId nid;
            if (systemWideConfig == null) {
                systemWideConfig = workspaceLocation.toString().equals(NPlatformHome.of(NOsFamily.getCurrent()).getWorkspaceLocation(null));
            }
            boolean includeEnv = options.isIncludeEnv();
            for (String id : idsToInstall) {
                NId nid2 = NId.get(id).get();
                if (nid2 == null) {
                    throw new NExecutionException(NMsg.ofC("unable to create script for %s : invalid id", id), 1);
                }
                if (nid2.getVersion().isBlank()) continue;
                includeEnv = true;
            }
            String linkNameCurrent = options.getLauncher().getCustomScriptPath();
            List nutsIds = idsToInstall.stream().filter(x -> this.isNutsBootId(NId.get(x).get())).collect(Collectors.toList());
            List nonNutsIds = idsToInstall.stream().filter(x -> !this.isNutsBootId(NId.get(x).get())).collect(Collectors.toList());
            boolean bootAlreadyProcessed = false;
            for (String id : nutsIds) {
                try {
                    String verString;
                    nid = NId.get(id).get();
                    bootAlreadyProcessed = true;
                    if (!nid.getVersion().isBlank() && ((verString = nid.getVersion().toString()).equalsIgnoreCase("current") || verString.equalsIgnoreCase("curr"))) {
                        id = nid.builder().setVersion(session.getWorkspace().getApiId().getVersion()).build().toString();
                    }
                    oo = options.copy().setId(id);
                    oo.getLauncher().setCustomScriptPath(linkNameCurrent);
                    oo.getLauncher().setSwitchWorkspace(systemWideConfig != null && systemWideConfig != false);
                    result.addAll(Arrays.asList(this.createArtifactScript(oo)));
                }
                catch (UncheckedIOException | NIOException e) {
                    throw new NExecutionException(NMsg.ofC("unable to add launcher for %s : %s", id, e), (Throwable)e);
                }
            }
            if (!bootAlreadyProcessed && !nonNutsIds.isEmpty()) {
                NdiScriptOptions oo2 = options.copy().setId(options.resolveNutsApiId().toString());
                oo2.getLauncher().setCustomScriptPath(null);
                oo2.getLauncher().setCustomScriptPath(linkNameCurrent);
                oo2.getLauncher().setSwitchWorkspace(systemWideConfig != null && systemWideConfig != false);
                result.addAll(Arrays.asList(this.createBootScripts(oo2)));
            }
            for (String id : nonNutsIds) {
                try {
                    nid = NId.get(id).get();
                    if (nid == null) {
                        throw new NExecutionException(NMsg.ofC("unable to create script for %s : invalid id", id), 1);
                    }
                    oo = options.copy().setId(id);
                    oo.getLauncher().setCustomScriptPath(linkNameCurrent);
                    oo.getLauncher().setSwitchWorkspace(systemWideConfig != null && systemWideConfig != false);
                    oo.setIncludeEnv(includeEnv);
                    result.addAll(Arrays.asList(this.createArtifactScript(oo)));
                }
                catch (UncheckedIOException | NIOException e) {
                    throw new NExecutionException(NMsg.ofC("unable to add launcher for %s : %s", id, e), (Throwable)e);
                }
            }
        }
        return result.toArray(new PathInfo[0]);
    }

    public PathInfo[] createBootScripts(NdiScriptOptions options) {
        String preferredName = options.getLauncher().getShortcutName();
        ArrayList<PathInfo> all = new ArrayList<PathInfo>();
        for (NdiScriptInfo i : this.getIncludeNutsEnv(options)) {
            all.add(i.create());
        }
        for (NdiScriptInfo i : this.getIncludeNutsInit(options)) {
            all.add(i.create());
        }
        String scriptPath = options.getLauncher().getCustomScriptPath();
        all.add(this.scriptBuilderTemplate("nuts", this.getShellGroups()[0], "nuts", options.resolveNutsApiId(), options).setPath(this.getBinScriptFile(NameBuilder.id(options.resolveNutsApiId(), scriptPath, "%n", options.resolveNutsApiDef().getDescriptor()).buildName(), options)).build());
        for (NdiScriptInfo i : this.getIncludeNutsTermInit(options)) {
            all.add(i.create());
        }
        for (NdiScriptInfo i : this.getNutsTerm(options)) {
            all.add(i.create());
        }
        if (options.getLauncher().getSwitchWorkspace() != null && options.getLauncher().getSwitchWorkspace().booleanValue()) {
            for (NdiScriptInfo ndiScriptInfo : this.getSysRC(options)) {
                PathInfo sysRC = ndiScriptInfo.create();
                if (sysRC == null) continue;
                all.add(sysRC);
            }
            if (this.matchCondition(options.getLauncher().getCreateDesktopLauncher(), this.getDesktopIntegrationSupport(NDesktopIntegrationItem.DESKTOP))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcutGlobal(NDesktopIntegrationItem.DESKTOP, options)));
            }
            if (this.matchCondition(options.getLauncher().getCreateMenuLauncher(), this.getDesktopIntegrationSupport(NDesktopIntegrationItem.MENU))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcutGlobal(NDesktopIntegrationItem.MENU, options)));
            }
        } else {
            if (this.matchCondition(options.getLauncher().getCreateDesktopLauncher(), this.getDesktopIntegrationSupport(NDesktopIntegrationItem.DESKTOP))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcut(NDesktopIntegrationItem.DESKTOP, options, scriptPath, preferredName)));
            }
            if (this.matchCondition(options.getLauncher().getCreateMenuLauncher(), this.getDesktopIntegrationSupport(NDesktopIntegrationItem.MENU))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcut(NDesktopIntegrationItem.MENU, options, scriptPath, preferredName)));
            }
            if (this.matchCondition(options.getLauncher().getCreateUserLauncher(), this.getDesktopIntegrationSupport(NDesktopIntegrationItem.USER))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcut(NDesktopIntegrationItem.USER, options, scriptPath, preferredName)));
            }
        }
        if (options.getLauncher().getSwitchWorkspace() != null && options.getLauncher().getSwitchWorkspace().booleanValue() && all.stream().anyMatch(x -> x.getStatus() != PathInfo.Status.DISCARDED)) {
            this.onPostGlobal(options, all.toArray(new PathInfo[0]));
        }
        return all.toArray(new PathInfo[0]);
    }

    private NDefinition loadIdDefinition(NId nid) {
        return NSearchCmd.of().addId(nid).setLatest(true).setDistinct(true).getResultDefinitions().findSingleton().get();
    }

    public NSupportMode getDesktopIntegrationSupport(NDesktopIntegrationItem target) {
        return NWorkspace.of().getDesktopIntegrationSupport(target);
    }

    protected boolean matchCondition(NSupportMode createDesktop, NSupportMode desktopIntegrationSupport) {
        if (desktopIntegrationSupport == null) {
            desktopIntegrationSupport = NSupportMode.NEVER;
        }
        return desktopIntegrationSupport.acceptCondition(createDesktop);
    }

    public void onPostGlobal(NdiScriptOptions options, PathInfo[] updatedPaths) {
    }

    public NWorkspaceBootConfig loadSwitchWorkspaceLocationConfig(String switchWorkspaceLocation) {
        NWorkspaceBootConfig bootConfig = NWorkspace.of().loadBootConfig(switchWorkspaceLocation, false, true);
        if (bootConfig == null) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid workspace: %s", switchWorkspaceLocation));
        }
        return bootConfig;
    }

    private String prepareLinkName(String linkName) {
        if (linkName == null) {
            linkName = "%n-%v";
        } else if (Files.isDirectory(Paths.get(linkName, new String[0]), new LinkOption[0])) {
            linkName = Paths.get(linkName, new String[0]).resolve("%n-%v").toString();
        } else if (linkName.endsWith("/") || linkName.endsWith("\\")) {
            linkName = Paths.get(linkName, new String[0]).resolve("%n-%v").toString();
        }
        return linkName;
    }

    public boolean saveFile(Path filePath, String content, boolean force) {
        try {
            String fileContent = "";
            if (Files.isRegularFile(filePath, new LinkOption[0])) {
                fileContent = new String(Files.readAllBytes(filePath));
            }
            if (force || !content.trim().equals(fileContent.trim())) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, content.getBytes(), new OpenOption[0]);
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public List<String> splitLines(String text) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null) {
            return lines;
        }
        try (BufferedReader br = new BufferedReader(new StringReader(text));){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return lines;
    }

    public PathInfo addFileLine(String type, NId id, NPath filePath, ReplaceString commentLine, String contentToAdd, ReplaceString header, NShellFamily shellFamily) {
        filePath = filePath.toAbsolute();
        List<String> contentToAddRows = this.splitLines(contentToAdd);
        boolean found = false;
        ArrayList<String> newFileContentRows = new ArrayList<String>();
        List<String> oldFileContentRows = null;
        NShellHelper sh = NShellHelper.of(shellFamily);
        if (filePath.isRegularFile()) {
            String fileContentString = new String(filePath.readBytes());
            oldFileContentRows = this.splitLines(fileContentString);
            while (!oldFileContentRows.isEmpty()) {
                if (oldFileContentRows.get(0).trim().isEmpty()) {
                    oldFileContentRows.remove(0);
                    continue;
                }
                if (!oldFileContentRows.get(oldFileContentRows.size() - 1).trim().isEmpty()) break;
                oldFileContentRows.remove(oldFileContentRows.size() - 1);
            }
            for (int i = 0; i < oldFileContentRows.size(); ++i) {
                String row = oldFileContentRows.get(i);
                if (sh.isComments(row.trim()) && commentLine.matches(sh.trimComments(row.trim()))) {
                    String clta = sh.toCommentLine(commentLine.getReplacement());
                    if (!clta.equals(row)) {
                        // empty if block
                    }
                    if (newFileContentRows.size() > 0 && ((String)newFileContentRows.get(newFileContentRows.size() - 1)).trim().length() > 0) {
                        newFileContentRows.add("");
                    }
                    newFileContentRows.add(clta);
                    found = true;
                    ++i;
                    ArrayList<String> old = new ArrayList<String>();
                    while (i < oldFileContentRows.size()) {
                        String s = oldFileContentRows.get(i);
                        if (s.trim().isEmpty()) {
                            ++i;
                            break;
                        }
                        if (s.trim().startsWith("#")) break;
                        ++i;
                        old.add(s.trim());
                    }
                    newFileContentRows.addAll(contentToAddRows);
                    newFileContentRows.add("");
                    while (i < oldFileContentRows.size()) {
                        newFileContentRows.add(oldFileContentRows.get(i));
                        ++i;
                    }
                    continue;
                }
                newFileContentRows.add(row);
            }
        }
        if (!(header == null || newFileContentRows.size() != 0 && header.matches(((String)newFileContentRows.get(0)).trim()))) {
            newFileContentRows.add(0, header.getReplacement());
        }
        if (!found) {
            if (newFileContentRows.size() > 0 && !((String)newFileContentRows.get(0)).trim().isEmpty()) {
                newFileContentRows.add("");
            }
            newFileContentRows.add(sh.toCommentLine(commentLine.getReplacement()));
            newFileContentRows.addAll(contentToAddRows);
            newFileContentRows.add("");
        }
        byte[] newContent = String.join((CharSequence)sh.newlineString(), newFileContentRows).getBytes();
        return new PathInfo(type, id, filePath, CoreIOUtils.tryWrite(newContent, filePath, "UpdateScript"));
    }

    public PathInfo removeFileCommented2Lines(String type, NId id, NPath filePath, String commentLine, boolean force, NShellFamily shellFamily) {
        filePath = filePath.toAbsolute();
        boolean alreadyExists = filePath.exists();
        boolean found = false;
        boolean updatedFile = false;
        NShellHelper sh = NShellHelper.of(shellFamily);
        ArrayList<String> lines = new ArrayList<String>();
        if (filePath.isRegularFile()) {
            String fileContent = new String(filePath.readBytes());
            String[] fileRows = fileContent.split("[\n\r]");
            for (int i = 0; i < fileRows.length; ++i) {
                String row = fileRows[i];
                if (row.trim().equals(sh.toCommentLine(commentLine))) {
                    found = true;
                    i += 2;
                    while (i < fileRows.length) {
                        lines.add(fileRows[i]);
                        ++i;
                    }
                    continue;
                }
                lines.add(row);
            }
        }
        if (found) {
            updatedFile = true;
        }
        if (force || updatedFile) {
            filePath.mkParentDirs();
            filePath.writeString(String.join((CharSequence)sh.newlineString(), lines) + sh.newlineString(), new NPathOption[0]);
        }
        return new PathInfo(type, id, filePath, updatedFile ? (alreadyExists ? PathInfo.Status.OVERRIDDEN : PathInfo.Status.CREATED) : PathInfo.Status.DISCARDED);
    }

    protected abstract String getExecFileName(String var1);

    protected abstract FreeDesktopEntryWriter createFreeDesktopEntryWriter();

    public PathInfo[] createShortcut(NDesktopIntegrationItem nDesktopIntegrationItem, NId id, String path, FreeDesktopEntry.Group shortcut) {
        ArrayList<PathInfo> results = new ArrayList<PathInfo>();
        FreeDesktopEntryWriter ww = this.createFreeDesktopEntryWriter();
        if (nDesktopIntegrationItem == NDesktopIntegrationItem.DESKTOP) {
            results.addAll(Arrays.asList(ww.writeDesktop(shortcut, path, true, id)));
        } else if (nDesktopIntegrationItem == NDesktopIntegrationItem.MENU) {
            results.addAll(Arrays.asList(ww.writeMenu(shortcut, path, true, id)));
        } else if (nDesktopIntegrationItem == NDesktopIntegrationItem.USER) {
            results.addAll(Arrays.asList(ww.writeShortcut(shortcut, path == null ? null : NPath.of(path), true, id)));
        } else {
            throw new NIllegalArgumentException(NMsg.ofPlain("unsupported"));
        }
        return results.toArray(new PathInfo[0]);
    }

    protected int resolveIconExtensionPriority(String extension) {
        switch (extension = extension.toLowerCase()) {
            case "svg": {
                return 10;
            }
            case "png": {
                return 8;
            }
            case "jpg": {
                return 6;
            }
            case "jpeg": {
                return 5;
            }
            case "gif": {
                return 4;
            }
            case "ico": {
                return 3;
            }
        }
        return -1;
    }

    protected int compareIconExtensions(String a, String b) {
        int ai = this.resolveIconExtensionPriority(a);
        int bi = this.resolveIconExtensionPriority(b);
        return Integer.compare(bi, ai);
    }

    protected int compareIconPaths(String a, String b) {
        String n1 = NPath.of(a).nameParts(NPathExtensionType.SHORT).getExtension();
        String n2 = NPath.of(b).nameParts(NPathExtensionType.SHORT).getExtension();
        return this.compareIconExtensions(n1, n2);
    }

    protected String resolveBestIcon(NId appId, List<String> iconPaths) {
        List all;
        if ((iconPaths = this.toAbsoluteIconPaths(appId, iconPaths)) != null && (all = iconPaths.stream().map(x -> x == null ? "" : x.trim()).filter(x -> !x.isEmpty()).filter(x -> this.resolveIconExtensionPriority(NPath.of(x).nameParts(NPathExtensionType.SHORT).getExtension()) >= 0).sorted(this::compareIconPaths).collect(Collectors.toList())).size() > 0) {
            return (String)all.get(0);
        }
        return null;
    }

    public String resolveIcon(String iconPath, NId appId) {
        if (!NBlankable.isBlank(iconPath)) {
            return iconPath;
        }
        return this.getPreferredIconPath(appId);
    }

    public List<String> toAbsoluteIconPaths(NId appId, List<String> iconPaths) {
        if (iconPaths == null) {
            return null;
        }
        return iconPaths.stream().map(x -> this.toAbsoluteIconPath(appId, (String)x)).collect(Collectors.toList());
    }

    public String toAbsoluteIconPath(NId appId, String iconPath) {
        if (NBlankable.isBlank(iconPath)) {
            return iconPath;
        }
        if (iconPath.startsWith("classpath://")) {
            return "resource://" + appId.getLongName() + "" + iconPath.substring("classpath://".length() - 1);
        }
        return iconPath;
    }

    public String getPreferredIconPath(NId appId) {
        if (CoreNIdUtils.isApiId(appId)) {
            NId rt = CoreNIdUtils.findRuntimeForApi(appId.getVersion().getValue());
            if (rt == null) {
                rt = NWorkspace.of().getRuntimeId();
            }
            return this.getPreferredIconPath(rt);
        }
        NDefinition appDef = NSearchCmd.of(appId).setDependencyFilter(NDependencyFilters.of().byRunnable()).setLatest(true).setDistinct(true).getResultDefinitions().findSingleton().get();
        String descAppIcon = this.resolveBestIcon(appDef.getId(), appDef.getDescriptor().getIcons());
        if (descAppIcon == null) {
            NId rid;
            if (this.isNutsBootId(appDef.getId()) || appDef.getId().getGroupId().equals("net.thevpc.nuts") || appDef.getId().getGroupId().startsWith("net.thevpc.nuts.")) {
                rid = NWorkspace.of().getRuntimeId();
                descAppIcon = this.resolveBestIcon(rid, Arrays.asList("resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts.svg", "resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts.png", "resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts.ico"));
            } else if (appDef.getId().getGroupId().startsWith("net.thevpc.nuts")) {
                rid = NWorkspace.of().getRuntimeId();
                descAppIcon = this.resolveBestIcon(rid, Arrays.asList("resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts-app.svg", "resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts-app.png", "resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts-app.ico"));
            }
        }
        String iconPath = null;
        if (descAppIcon != null) {
            String descAppIcon0 = descAppIcon;
            String descAppIconDigest = NDigest.of().md5().setSource(new ByteArrayInputStream(descAppIcon0.getBytes())).computeString();
            NPath p0 = NPath.of(descAppIcon);
            descAppIcon = this.toAbsoluteIconPath(appId, descAppIcon);
            String bestName = descAppIconDigest + "." + p0.nameParts(NPathExtensionType.SHORT).getExtension();
            NPath localIconPath = NPath.ofIdStore(appDef.getId(), NStoreType.CACHE).resolve("icons").resolve(bestName);
            if (localIconPath.isRegularFile()) {
                iconPath = localIconPath.toString();
            } else {
                NPath p = NPath.of(descAppIcon);
                if (p.exists()) {
                    NCp.of().from(p).to(localIconPath).addOptions(NPathOption.SAFE, NPathOption.LOG, NPathOption.TRACE).run();
                    iconPath = localIconPath.toString();
                }
            }
        }
        if (iconPath == null) {
            iconPath = this.getDefaultIconPath();
        }
        return iconPath;
    }

    public Path getShortcutPath(NdiScriptOptions options) {
        NDefinition appDef = NSearchCmd.of().addId(options.getId()).setLatest(true).setDistinct(true).getResultDefinitions().findSingleton().get();
        String fileName = options.getLauncher().getCustomScriptPath();
        fileName = this.resolveShortcutFileName(appDef.getId(), appDef.getDescriptor(), fileName, null);
        return Paths.get(fileName, new String[0]);
    }

    public PathInfo[] createShortcut(NDesktopIntegrationItem nDesktopIntegrationItem, NdiScriptOptions options) {
        String cwd;
        String apiVersion = options.getNutsApiVersion().toString();
        NAssert.requireNonBlank(apiVersion, "nuts-api version to link to");
        NId apiId = NWorkspace.of().getApiId().builder().setVersion(apiVersion).build();
        NDefinition apiDefinition = NSearchCmd.of().addId(apiId).failFast().latest().distinct().getResultDefinitions().findSingleton().get();
        NId appId = NId.get(options.getId()).get();
        NDefinition appDef = this.loadIdDefinition(appId);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getNutsStart(options).path().toString());
        cmd.add("-y");
        cmd.add(appId.toString());
        if (options.getLauncher().getArgs() != null) {
            cmd.addAll(options.getLauncher().getArgs());
        }
        if ((cwd = options.getLauncher().getWorkingDirectory()) == null) {
            cwd = System.getProperty("user.home");
        }
        String iconPath = this.resolveIcon(options.getLauncher().getIcon(), appId);
        String shortcutName = options.getLauncher().getShortcutName();
        if (shortcutName == null && nDesktopIntegrationItem == NDesktopIntegrationItem.USER && (shortcutName = options.getLauncher().getCustomShortcutPath()) == null) {
            shortcutName = options.getLauncher().getCustomScriptPath();
        }
        if ((shortcutName = NameBuilder.extractPathName(shortcutName)).isEmpty()) {
            shortcutName = "%N";
        }
        shortcutName = shortcutName + "%s%v%s%h";
        shortcutName = NameBuilder.label(appDef.getId(), shortcutName, null, appDef.getDescriptor()).buildName();
        String execCmd = NCmdLine.of(cmd).toString();
        FreeDesktopEntry.Group sl = FreeDesktopEntry.Group.desktopEntry(shortcutName, execCmd, cwd);
        sl.setStartNotify(true);
        sl.setIcon(iconPath);
        sl.setGenericName(apiDefinition.getDescriptor().getGenericName());
        sl.setComment(appDef.getDescriptor().getDescription());
        sl.setTerminal(options.getLauncher().isOpenTerminal());
        if (options.getLauncher().getMenuCategory() != null) {
            sl.addCategory(options.getLauncher().getMenuCategory());
        } else {
            sl.setCategories(appDef.getDescriptor().getCategories());
        }
        String preferredPath = this.getShortcutPath(options).toString();
        return this.createShortcut(nDesktopIntegrationItem, appId, preferredPath, sl);
    }

    protected String getDefaultIconPath() {
        return "apper";
    }

    public PathInfo[] createLaunchTermShortcutGlobal(NDesktopIntegrationItem nDesktopIntegrationItem, NdiScriptOptions options) {
        String fileName = options.resolveNutsApiId().getShortName().replace(':', '-');
        String name = "Nuts Terminal";
        return this.createLaunchTermShortcut(nDesktopIntegrationItem, options, fileName, name);
    }

    public abstract boolean isShortcutFileNameUserFriendly();

    public String resolveShortcutFileName(NId id, NDescriptor descriptor, String fileName, String name) {
        if (NBlankable.isBlank(fileName)) {
            if (this.isShortcutFileNameUserFriendly()) {
                fileName = name;
            }
            if (NBlankable.isBlank(fileName)) {
                fileName = this.isShortcutFileNameUserFriendly() ? "%N%s%v%s%h" : "%g-%n-%v%s%h";
            }
        }
        fileName = (this.isShortcutFileNameUserFriendly() ? NameBuilder.label(id, fileName, null, descriptor) : NameBuilder.id(id, fileName, null, descriptor)).buildName();
        return fileName;
    }

    public PathInfo[] createLaunchTermShortcut(NDesktopIntegrationItem nDesktopIntegrationItem, NdiScriptOptions options, String fileName, String name) {
        String cmd = this.getNutsTerm(options)[0].path().toString();
        fileName = this.resolveShortcutFileName(options.resolveNutsApiId(), options.resolveNutsApiDef().getDescriptor(), fileName, name);
        if (name == null) {
            name = NameBuilder.label(options.resolveNutsApiId(), "Nuts Terminal%s%v%s%h", null, options.resolveNutsApiDef().getDescriptor()).buildName();
        }
        String execCmd = NCmdLine.of(new String[]{cmd}).toString();
        return this.createShortcut(nDesktopIntegrationItem, options.resolveNutsApiId(), fileName, FreeDesktopEntry.Group.desktopEntry(name, execCmd, System.getProperty("user.home")).setIcon(this.resolveIcon(null, options.resolveNutsApiId())).setStartNotify(true).addCategory("/Utility/Nuts").setGenericName(options.resolveNutsApiDef().getDescriptor().getGenericName()).setComment(options.resolveNutsApiDef().getDescriptor().getDescription()).setTerminal(true));
    }

    public ReplaceString getCommentLineConfigHeader() {
        return COMMENT_LINE_CONFIG_HEADER;
    }

    public abstract String getTemplateName(String var1, NShellFamily var2);

    private class RcNdiScriptInfo
    implements NdiScriptInfo {
        private final String bashrcName;
        private final NdiScriptOptions options;
        private final NShellFamily shellFamily;

        public RcNdiScriptInfo(String bashrcName, NdiScriptOptions options, NShellFamily shellFamily) {
            this.bashrcName = bashrcName;
            this.options = options;
            this.shellFamily = shellFamily;
        }

        @Override
        public NPath path() {
            if (this.bashrcName == null) {
                return null;
            }
            return NPath.of(System.getProperty("user.home")).resolve(this.bashrcName);
        }

        @Override
        public PathInfo create() {
            NPath apiConfigFile = this.path();
            if (apiConfigFile == null) {
                return null;
            }
            NShellHelper sh = NShellHelper.of(this.shellFamily);
            return BaseSystemNdi.this.addFileLine("sysrc", this.options.resolveNutsApiId(), apiConfigFile, BaseSystemNdi.this.getCommentLineConfigHeader(), sh.getCallScriptCommand(BaseSystemNdi.this.getIncludeNutsInit(this.options, this.shellFamily).path().toString(), new String[0]), sh.getShebanSh(), this.shellFamily);
        }
    }
}

