/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceBootConfig;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NLauncherOptions;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;

public class NdiScriptOptions
implements Cloneable {
    private String id;
    private boolean forceBoot;
    private boolean fetch;
    private boolean includeEnv;
    private boolean addNutsScript;
    private NLauncherOptions launcher = new NLauncherOptions();
    private String nutsVersion;
    private NId nutsApiId;
    private NPath nutsApiJarPath;
    private NPath nutsAppJarPath;
    private NWorkspaceBootConfig workspaceBootConfig;

    public NLauncherOptions getLauncher() {
        return this.launcher;
    }

    public NdiScriptOptions setLauncher(NLauncherOptions launcher) {
        this.launcher = launcher;
        return this;
    }

    public boolean isAddNutsScript() {
        return this.addNutsScript;
    }

    public NdiScriptOptions setAddNutsScript(boolean addNutsScript) {
        this.addNutsScript = addNutsScript;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public NdiScriptOptions setId(String id) {
        this.id = id;
        return this;
    }

    public boolean isForceBoot() {
        return this.forceBoot;
    }

    public NdiScriptOptions setForceBoot(boolean forceBoot) {
        this.forceBoot = forceBoot;
        return this;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public NdiScriptOptions setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public boolean isIncludeEnv() {
        return this.includeEnv;
    }

    public NdiScriptOptions setIncludeEnv(boolean includeEnv) {
        this.includeEnv = includeEnv;
        return this;
    }

    public NdiScriptOptions copy() {
        NdiScriptOptions c;
        try {
            c = (NdiScriptOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
        c.setLauncher(c.getLauncher() == null ? null : c.getLauncher().copy());
        return c;
    }

    public NPath resolveNutsApiJarPath() {
        if (this.nutsApiJarPath == null) {
            NId nid = this.resolveNutsApiId();
            if (this.getLauncher().getSwitchWorkspaceLocation() == null) {
                NDefinition apiDef = NSearchCmd.of().addId(nid).setDependencyFilter(NDependencyFilters.of().byRunnable()).setLatest(true).getResultDefinitions().findFirst().get();
                this.nutsApiJarPath = apiDef.getContent().orNull();
            } else {
                NWorkspaceBootConfig bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
                this.nutsApiJarPath = NPath.of(bootConfig.getStoreLocation(nid, NStoreType.LIB));
                NWorkspace.of().getDefaultIdFilename(nid);
            }
        }
        return this.nutsApiJarPath;
    }

    public NPath resolveNutsAppJarPath() {
        if (this.nutsAppJarPath == null) {
            NId nid = this.resolveNutsAppId();
            if (this.getLauncher().getSwitchWorkspaceLocation() == null) {
                NDefinition appDef = NSearchCmd.of().addId(nid).setDependencyFilter(NDependencyFilters.of().byRunnable()).setLatest(true).getResultDefinitions().findFirst().get();
                this.nutsAppJarPath = appDef.getContent().get();
            } else {
                NWorkspaceBootConfig bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
                this.nutsAppJarPath = NPath.of(bootConfig.getStoreLocation(nid, NStoreType.LIB));
                NWorkspace.of().getDefaultIdFilename(nid);
            }
        }
        return this.nutsAppJarPath;
    }

    public NPath resolveBinFolder() {
        return this.resolveNutsBinFolder().resolve("bin");
    }

    public NPath resolveIncFolder() {
        return this.resolveNutsBinFolder().resolve("inc");
    }

    public NPath resolveNutsBinFolder() {
        NWorkspaceBootConfig bootConfig = null;
        NId apiId = NWorkspace.of().getApiId();
        if (this.getLauncher().getSwitchWorkspaceLocation() != null) {
            bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
            return NPath.of(bootConfig.getStoreLocation(apiId, NStoreType.BIN));
        }
        return NPath.ofIdStore(apiId, NStoreType.BIN);
    }

    public NPath resolveNutsApiBinFolder() {
        NWorkspaceBootConfig bootConfig = null;
        NId apiId = NWorkspace.of().getApiId().builder().setVersion(this.nutsVersion).build();
        apiId = NSearchCmd.of().addId(apiId).latest().failFast().distinct().getResultDefinitions().findSingleton().get().getId();
        if (this.getLauncher().getSwitchWorkspaceLocation() != null) {
            bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
            return NPath.of(bootConfig.getStoreLocation(apiId, NStoreType.BIN));
        }
        return NPath.ofIdStore(apiId, NStoreType.BIN);
    }

    public NDefinition resolveNutsApiDef() {
        return NSearchCmd.of(this.resolveNutsApiId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).latest().failFast().distinct().getResultDefinitions().findSingleton().get();
    }

    public NId resolveNutsAppId() {
        NId r = this.resolveNutsApiId();
        return r.builder().setArtifactId("nuts-app").build();
    }

    public NId resolveNutsApiId() {
        if (this.nutsApiId == null) {
            NWorkspace workspace = NWorkspace.of();
            if (this.getLauncher().getSwitchWorkspaceLocation() == null) {
                this.nutsApiId = this.nutsVersion == null ? workspace.getApiId() : NSearchCmd.of().addId(workspace.getApiId().builder().setVersion(this.nutsVersion).build()).setLatest(true).setDistinct(true).getResultIds().findSingleton().get();
            } else {
                NWorkspaceBootConfig bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
                NVersion _latestVersion = null;
                try {
                    _latestVersion = Files.list(Paths.get(bootConfig.getStoreLocation(workspace.getApiId(), NStoreType.CONF), new String[0]).getParent()).filter(f -> NVersion.get(f.getFileName().toString()).flatMap(v -> v.getNumberLiteralAt(0)).flatMap(NLiteral::asLong).isPresent() && Files.exists(f.resolve("nuts-api-boot-config.json"), new LinkOption[0])).map(f -> NVersion.get(f.getFileName().toString()).get()).max(Comparator.naturalOrder()).orElse(null);
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
                NAssert.requireNonBlank(_latestVersion, "missing nuts-api version to link to");
                this.nutsApiId = workspace.getApiId().builder().setVersion(_latestVersion).build();
            }
        }
        return this.nutsApiId;
    }

    public NVersion getNutsApiVersion() {
        return this.resolveNutsApiId().getVersion();
    }

    public Path getWorkspaceLocation() {
        if (this.getLauncher().getSwitchWorkspaceLocation() != null) {
            NWorkspaceBootConfig bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
            return Paths.get(bootConfig.getEffectiveWorkspace(), new String[0]);
        }
        return NWorkspace.of().getWorkspaceLocation().toPath().get();
    }

    public NWorkspaceBootConfig loadSwitchWorkspaceLocationConfig(String switchWorkspaceLocation) {
        if (this.workspaceBootConfig == null) {
            this.workspaceBootConfig = NWorkspace.of().loadBootConfig(switchWorkspaceLocation, false, true);
            if (this.workspaceBootConfig == null) {
                throw new NIllegalArgumentException(NMsg.ofC("invalid workspace: %s", switchWorkspaceLocation));
            }
        }
        return this.workspaceBootConfig;
    }
}

