/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi;

import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.runtime.optional.mslink.OptionalMsLinkHelper;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNSettingsSubCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.SystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.unix.LinuxNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.unix.MacosNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.win.WindowsNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NSupportMode;

public class NSettingsNdiSubCommand
extends AbstractNSettingsSubCommand {
    public static SystemNdi createNdi() {
        BaseSystemNdi ndi = null;
        switch (NWorkspace.of().getOsFamily()) {
            case LINUX: 
            case UNIX: {
                ndi = new LinuxNdi();
                break;
            }
            case MACOS: {
                ndi = new MacosNdi();
                break;
            }
            case WINDOWS: {
                if (!OptionalMsLinkHelper.isSupported()) break;
                ndi = new WindowsNdi();
            }
        }
        return ndi;
    }

    public void runAddLauncher(NCmdLine cmdLine) {
        class Data {
            NdiScriptOptions options = new NdiScriptOptions();
            List<String> idsToInstall = new ArrayList<String>();
            boolean missingAnyArgument = true;
            boolean ignoreUnsupportedOs = false;

            Data() {
            }
        }
        Data d = new Data();
        cmdLine.setCommandName("settings add launcher");
        NSession session = NSession.of();
        block65: while (cmdLine.hasNext()) {
            switch (cmdLine.peek().get().key()) {
                case "-t": 
                case "--fetch": {
                    cmdLine.matcher().matchFlag(v -> d.options.setFetch(v.booleanValue())).anyMatch();
                    continue block65;
                }
                case "-d": 
                case "--workdir": {
                    cmdLine.matcher().matchEntry(v -> d.options.getLauncher().setWorkingDirectory(v.stringValue())).anyMatch();
                    continue block65;
                }
                case "--icon": {
                    cmdLine.matcher().matchEntry(v -> d.options.getLauncher().setIcon(v.stringValue())).anyMatch();
                    continue block65;
                }
                case "--menu": {
                    cmdLine.matcher().matchEntry(v -> d.options.getLauncher().setCreateMenuLauncher(this.parseCond(v.stringValue()))).anyMatch();
                    continue block65;
                }
                case "--menu-category": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.options.getLauncher().setMenuCategory(v.stringValue());
                        if (d.options.getLauncher().getMenuCategory() != null && !d.options.getLauncher().getMenuCategory().isEmpty() && d.options.getLauncher().getCreateMenuLauncher() == NSupportMode.NEVER) {
                            d.options.getLauncher().setCreateMenuLauncher(NSupportMode.PREFERRED);
                        }
                    }).anyMatch();
                    continue block65;
                }
                case "--desktop": {
                    cmdLine.matcher().matchEntry(v -> d.options.getLauncher().setCreateDesktopLauncher(this.parseCond(v.stringValue()))).anyMatch();
                    continue block65;
                }
                case "--desktop-name": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.options.getLauncher().setShortcutName(v.stringValue());
                        if (d.options.getLauncher().getCreateDesktopLauncher() == NSupportMode.NEVER) {
                            d.options.getLauncher().setCreateDesktopLauncher(NSupportMode.PREFERRED);
                        }
                    }).anyMatch();
                    continue block65;
                }
                case "--menu-name": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.options.getLauncher().setShortcutName(v.stringValue());
                        if (d.options.getLauncher().getCreateDesktopLauncher() == NSupportMode.NEVER) {
                            d.options.getLauncher().setCreateMenuLauncher(NSupportMode.PREFERRED);
                        }
                    }).anyMatch();
                    continue block65;
                }
                case "--shortcut-name": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.options.getLauncher().setShortcutName(v.stringValue());
                        if (d.options.getLauncher().getCreateUserLauncher() == NSupportMode.NEVER) {
                            d.options.getLauncher().setCreateUserLauncher(NSupportMode.PREFERRED);
                        }
                    }).anyMatch();
                    continue block65;
                }
                case "--shortcut-path": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.options.getLauncher().setCustomShortcutPath(v.stringValue());
                        if (d.options.getLauncher().getCreateUserLauncher() == NSupportMode.NEVER) {
                            d.options.getLauncher().setCreateUserLauncher(NSupportMode.PREFERRED);
                        }
                    }).anyMatch();
                    continue block65;
                }
                case "-x": 
                case "--external": 
                case "--spawn": {
                    cmdLine.matcher().matchTrueFlag(v -> d.options.getLauncher().getNutsOptions().add("--spawn")).anyMatch();
                    continue block65;
                }
                case "-b": 
                case "--embedded": {
                    cmdLine.matcher().matchTrueFlag(v -> d.options.getLauncher().getNutsOptions().add("--embedded")).anyMatch();
                    continue block65;
                }
                case "--terminal": {
                    cmdLine.matcher().matchFlag(v -> d.options.getLauncher().setOpenTerminal(v.booleanValue())).anyMatch();
                    continue block65;
                }
                case "-e": 
                case "--env": {
                    cmdLine.matcher().matchFlag(v -> d.options.setIncludeEnv(v.booleanValue())).anyMatch();
                    continue block65;
                }
                case "--system": {
                    cmdLine.matcher().matchTrueFlag(v -> d.options.getLauncher().getNutsOptions().add("--system")).anyMatch();
                    continue block65;
                }
                case "--current-user": {
                    cmdLine.matcher().matchTrueFlag(v -> d.options.getLauncher().getNutsOptions().add("--current-user")).anyMatch();
                    continue block65;
                }
                case "--as-root": {
                    cmdLine.matcher().matchTrueFlag(v -> d.options.getLauncher().getNutsOptions().add("--as-root")).anyMatch();
                    continue block65;
                }
                case "--run-as": {
                    cmdLine.matcher().matchEntry(v -> d.options.getLauncher().getNutsOptions().add("--run-as=" + v)).anyMatch();
                    continue block65;
                }
                case "-X": 
                case "--exec-options": {
                    cmdLine.matcher().matchEntry(v -> d.options.getLauncher().getNutsOptions().add("--exec-options=" + v)).anyMatch();
                    continue block65;
                }
                case "-i": 
                case "--installed": {
                    cmdLine.matcher().matchTrueFlag(v -> {
                        session.setConfirm(NConfirmationMode.YES);
                        for (NId resultId : NSearchCmd.of().setDefinitionFilter(NDefinitionFilters.of().byInstalled(true)).getResultIds()) {
                            d.idsToInstall.add(resultId.getLongName());
                            d.missingAnyArgument = false;
                        }
                    }).anyMatch();
                    continue block65;
                }
                case "-c": 
                case "--companions": {
                    cmdLine.matcher().matchTrueFlag(v -> {
                        session.setConfirm(NConfirmationMode.YES);
                        for (NId companion : NExtensions.of().getCompanionIds()) {
                            d.idsToInstall.add(NSearchCmd.of().addId(companion).setLatest(true).getResultIds().findFirst().get().getLongName());
                            d.missingAnyArgument = false;
                        }
                    }).anyMatch();
                    continue block65;
                }
                case "--switch": {
                    cmdLine.matcher().matchFlag(v -> d.options.getLauncher().setSwitchWorkspace(v.booleanValue())).anyMatch();
                    continue block65;
                }
                case "--ignore-unsupported-os": {
                    cmdLine.matcher().matchFlag(v -> {
                        d.ignoreUnsupportedOs = v.booleanValue();
                    }).anyMatch();
                    continue block65;
                }
                case "-w": 
                case "--workspace": {
                    cmdLine.matcher().matchEntry(v -> d.options.getLauncher().setSwitchWorkspaceLocation(v.stringValue())).anyMatch();
                    continue block65;
                }
                case "-n": 
                case "--name": {
                    cmdLine.matcher().matchEntry(v -> d.options.getLauncher().setCustomScriptPath(v.stringValue())).anyMatch();
                    continue block65;
                }
            }
            if (cmdLine.isNextOption()) {
                session.configureLast(cmdLine);
                continue;
            }
            d.idsToInstall.add((String)cmdLine.next().flatMap(NArg::asString).get());
            d.missingAnyArgument = false;
        }
        if (d.missingAnyArgument) {
            cmdLine.peek().get();
        }
        if (cmdLine.isExecMode()) {
            SystemNdi ndi = NSettingsNdiSubCommand.createNdi();
            if (ndi == null) {
                if (d.ignoreUnsupportedOs) {
                    return;
                }
                throw new NExecutionException(NMsg.ofC("platform not supported : %s", NWorkspace.of().getOs()), 2);
            }
            if (!d.idsToInstall.isEmpty()) {
                this.printResults(ndi.addScript(d.options, d.idsToInstall.toArray(new String[0])));
            }
        }
    }

    private NSupportMode parseCond(String s) {
        switch (s) {
            case "supported": {
                return NSupportMode.SUPPORTED;
            }
            case "never": {
                return NSupportMode.NEVER;
            }
            case "always": {
                return NSupportMode.ALWAYS;
            }
            case "preferred": 
            case "": {
                return NSupportMode.PREFERRED;
            }
        }
        if (NLiteral.of(s).asBoolean().get().booleanValue()) {
            return NSupportMode.PREFERRED;
        }
        return NSupportMode.NEVER;
    }

    public void runRemoveLauncher(NCmdLine cmdLine) {
        ArrayList<String> idsToUninstall = new ArrayList<String>();
        boolean forceAll = false;
        boolean missingAnyArgument = true;
        boolean ignoreUnsupportedOs = false;
        NSession session = NSession.of();
        while (cmdLine.hasNext()) {
            NArg a = cmdLine.nextEntry("--ignore-unsupported-os").orNull();
            if (a != null) {
                if (!a.isUncommented()) continue;
                ignoreUnsupportedOs = a.getBooleanValue().get();
                continue;
            }
            if (cmdLine.isNextOption()) {
                session.configureLast(cmdLine);
                continue;
            }
            idsToUninstall.add((String)cmdLine.next().flatMap(NArg::asString).get());
            missingAnyArgument = false;
        }
        if (missingAnyArgument) {
            cmdLine.peek().get();
        }
        if (cmdLine.isExecMode()) {
            SystemNdi ndi;
            if (forceAll) {
                session.setConfirm(NConfirmationMode.YES);
            }
            if ((ndi = NSettingsNdiSubCommand.createNdi()) == null) {
                if (ignoreUnsupportedOs) {
                    return;
                }
                throw new NExecutionException(NMsg.ofC("platform not supported : %s", NWorkspace.of().getOs()), 2);
            }
            boolean subTrace = session.isTrace();
            if (!session.isPlainTrace()) {
                subTrace = false;
            }
            if (!idsToUninstall.isEmpty()) {
                for (String id : idsToUninstall) {
                    try {
                        ndi.removeNutsScript(id, null);
                    }
                    catch (UncheckedIOException | NIOException e) {
                        throw new NExecutionException(NMsg.ofC("unable to run script %s : %s", id, e), (Throwable)e);
                    }
                }
            }
        }
    }

    public void runSwitch(NCmdLine cmdLine) {
        class Data {
            String switchWorkspaceLocation = null;
            String switchWorkspaceApi = null;
            boolean ignoreUnsupportedOs = false;
            NSupportMode createDesktop = NSupportMode.NEVER;
            NSupportMode createMenu = NSupportMode.NEVER;
            String menuCategory = null;
            String shortcutName = null;

            Data() {
            }
        }
        Data d = new Data();
        NSession session = NSession.of();
        block22: while (cmdLine.hasNext()) {
            switch (cmdLine.peek().get().key()) {
                case "--ignore-unsupported-os": {
                    cmdLine.matcher().matchFlag(v -> {
                        d.ignoreUnsupportedOs = v.booleanValue();
                    }).anyMatch();
                    continue block22;
                }
                case "-w": 
                case "--workspace": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.switchWorkspaceLocation = v.stringValue();
                    }).anyMatch();
                    continue block22;
                }
                case "-a": 
                case "--api": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.switchWorkspaceApi = v.stringValue();
                    }).anyMatch();
                    continue block22;
                }
                case "--menu": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.createMenu = this.parseCond(v.stringValue());
                    }).anyMatch();
                    continue block22;
                }
                case "--menu-category": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.menuCategory = v.stringValue();
                        if (d.menuCategory != null && !d.menuCategory.isEmpty() && d.createMenu == NSupportMode.NEVER) {
                            d.createMenu = NSupportMode.PREFERRED;
                        }
                    }).anyMatch();
                    continue block22;
                }
                case "--menu-name": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.shortcutName = v.stringValue();
                        if (d.shortcutName != null && !d.shortcutName.isEmpty() && d.createMenu == NSupportMode.NEVER) {
                            d.createMenu = NSupportMode.PREFERRED;
                        }
                    }).anyMatch();
                    continue block22;
                }
                case "--desktop-name": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.shortcutName = v.stringValue();
                        if (d.shortcutName != null && !d.shortcutName.isEmpty() && d.createDesktop == NSupportMode.NEVER) {
                            d.createDesktop = NSupportMode.PREFERRED;
                        }
                    }).anyMatch();
                    continue block22;
                }
                case "--desktop": {
                    cmdLine.matcher().matchEntry(v -> {
                        d.createDesktop = this.parseCond(v.stringValue());
                    }).anyMatch();
                    continue block22;
                }
            }
            if (cmdLine.isNextOption()) {
                cmdLine.throwUnexpectedArgument();
                continue;
            }
            if (d.switchWorkspaceLocation == null) {
                d.switchWorkspaceLocation = (String)cmdLine.next().flatMap(NArg::asString).get();
                continue;
            }
            if (d.switchWorkspaceApi == null) {
                d.switchWorkspaceApi = (String)cmdLine.next().flatMap(NArg::asString).get();
                continue;
            }
            if (cmdLine.isNextOption()) {
                session.configureLast(cmdLine);
                continue;
            }
            cmdLine.throwUnexpectedArgument();
        }
        if (cmdLine.isExecMode()) {
            SystemNdi ndi = NSettingsNdiSubCommand.createNdi();
            if (ndi == null) {
                if (d.ignoreUnsupportedOs) {
                    return;
                }
                throw new NExecutionException(NMsg.ofC("platform not supported : %s ", NWorkspace.of().getOs()), 2);
            }
            if (d.switchWorkspaceLocation != null || d.switchWorkspaceApi != null) {
                NdiScriptOptions oo = new NdiScriptOptions();
                oo.getLauncher().setSwitchWorkspaceLocation(d.switchWorkspaceLocation);
                oo.getLauncher().setCreateDesktopLauncher(d.createDesktop);
                oo.getLauncher().setMenuCategory(d.menuCategory);
                oo.getLauncher().setCreateMenuLauncher(d.createMenu);
                oo.getLauncher().setShortcutName(d.shortcutName);
                ndi.switchWorkspace(oo);
            }
        }
    }

    private void printResults(PathInfo[] result) {
        NSession session = NSession.of();
        if (session.isTrace()) {
            result = (PathInfo[])Arrays.stream(result).filter(x -> x.getStatus() != PathInfo.Status.DISCARDED).toArray(PathInfo[]::new);
            if (session.isPlainTrace()) {
                int namesSize = Arrays.stream(result).mapToInt(x -> x.getPath().getName().length()).max().orElse(1);
                for (PathInfo ndiScriptInfo : result) {
                    NTexts txt = NTexts.of();
                    NOut.resetLine().println(NMsg.ofC("%s script %-" + namesSize + "s for %s at %s", ndiScriptInfo.getStatus() == PathInfo.Status.OVERRIDDEN ? txt.ofStyled("re-install", NTextStyles.of(NTextStyle.success(), NTextStyle.underlined())) : txt.ofStyled("install", NTextStyle.success()), txt.ofStyled(ndiScriptInfo.getPath().getName(), NTextStyle.path()), ndiScriptInfo.getId(), txt.ofStyled(CoreIOUtils.betterPath(ndiScriptInfo.getPath().toString()), NTextStyle.path())));
                }
            } else {
                NOut.println(result);
            }
        }
    }

    @Override
    public boolean exec(NCmdLine cmdLine, Boolean autoSave) {
        if (cmdLine.next("add launcher", "lna").isPresent()) {
            this.runAddLauncher(cmdLine);
            return true;
        }
        if (cmdLine.next("remove launcher", "lnrm").isPresent()) {
            this.runRemoveLauncher(cmdLine);
            return true;
        }
        if (cmdLine.next("switch", "lnsw").isPresent()) {
            this.runSwitch(cmdLine);
            return true;
        }
        return false;
    }
}

