/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.clinfo;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.platform.NPlatformHome;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class NCliInfo {
    public static Map<String, String> loadConfigMap() {
        Path userConfig = NCliInfo.getConfigFile();
        Map m = null;
        if (Files.exists(userConfig, new LinkOption[0])) {
            try {
                m = NElementParser.ofJson().parse(userConfig, Map.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (m != null) {
                return m;
            }
        }
        return new LinkedHashMap<String, String>();
    }

    public static String loadVar(String name, Supplier<String> generator) {
        Map<String, String> m = NCliInfo.loadConfigMap();
        String _uuid = NStringUtils.trimToNull(m.get(name));
        if (!NBlankable.isBlank(_uuid)) {
            return _uuid;
        }
        String varVal = null;
        if (generator != null && (varVal = generator.get()) != null) {
            m.put(name, varVal);
            try {
                Path userConfig = NCliInfo.getConfigFile();
                NElementWriter.ofJson().write(m, userConfig);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return varVal;
    }

    public static String saveVar(String name, String value) {
        Map<String, String> m = NCliInfo.loadConfigMap();
        String old = NStringUtils.trimToNull(m.get(name));
        if (Objects.equals(old, value = NStringUtils.trimToNull(value))) {
            if (value == null) {
                m.remove(name);
            } else {
                m.put(name, value);
            }
            try {
                Path userConfig = NCliInfo.getConfigFile();
                NElementWriter.ofJson().write(m, userConfig);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return old;
    }

    public static String loadCliId() {
        return NCliInfo.loadCliId(true);
    }

    public static String loadCliId(boolean auto) {
        return NCliInfo.loadVar("user", auto ? () -> UUID.randomUUID().toString() : null);
    }

    public static String saveCliId(String value) {
        return NCliInfo.saveVar("user", value);
    }

    private static Path getConfigFile() {
        return Paths.get(NPlatformHome.USER.getHome(), new String[0]).resolve(".nuts-user-config");
    }
}

