/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.alias;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NCommandConfig;
import net.thevpc.nuts.command.NCustomCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNSettingsSubCommand;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPropertiesFormat;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NSettingsAliasSubCommand
extends AbstractNSettingsSubCommand {
    public NSettingsAliasSubCommand(NWorkspace workspace) {
    }

    @Override
    public boolean exec(NCmdLine cmdLine, Boolean autoSave) {
        if (cmdLine.next("list aliases", "list alias", "aliases list").isPresent()) {
            cmdLine.setCommandName("settings list aliases");
            final ArrayList<String> toList = new ArrayList<String>();
            NSession session = NSession.of();
            while (cmdLine.hasNext()) {
                if (!cmdLine.isNextOption()) {
                    NArg a = cmdLine.next().get();
                    toList.add(a.toString());
                    continue;
                }
                cmdLine.throwUnexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                List r = NWorkspace.of().findAllCommands().stream().filter(new Predicate<NCustomCmd>(){

                    @Override
                    public boolean test(NCustomCmd nutsWorkspaceCommandAlias) {
                        if (toList.isEmpty()) {
                            return true;
                        }
                        for (String s : toList) {
                            if (!(s.contains("*") ? Pattern.compile(s.replace("*", ".*")).matcher(nutsWorkspaceCommandAlias.getName()).matches() : s.equals(nutsWorkspaceCommandAlias.getName()))) continue;
                            return true;
                        }
                        return false;
                    }
                }).sorted((x, y) -> x.getName().compareTo(y.getName())).collect(Collectors.toList());
                if (NOut.isPlain()) {
                    NPropertiesFormat.of().setValue(r.stream().collect(Collectors.toMap(NCustomCmd::getName, x -> NCmdLine.of(x.getCommand()).toString(), (x, y) -> {
                        throw new NIllegalArgumentException(NMsg.ofC("duplicate %s", x));
                    }, LinkedHashMap::new))).println();
                } else {
                    NOut.println(r.stream().map(x -> new AliasInfo((NCustomCmd)x)).collect(Collectors.toList()));
                }
            }
            return true;
        }
        if (cmdLine.next("remove alias", "alias remove").isPresent()) {
            if (cmdLine.isExecMode()) {
                while (cmdLine.hasNext()) {
                    NWorkspace.of().removeCommand(cmdLine.next().get().toString());
                }
                NWorkspace.of().saveConfig();
            }
            return true;
        }
        if (cmdLine.next("add alias", "alias add").isPresent()) {
            if (cmdLine.isExecMode()) {
                String n = null;
                LinkedHashMap<String, AliasInfo> toAdd = new LinkedHashMap<String, AliasInfo>();
                while (cmdLine.hasNext()) {
                    if (!cmdLine.isNextOption()) {
                        String[] cmdAndArgs;
                        NArg a = cmdLine.next().get();
                        if (a.isKeyValue()) {
                            if (n != null) {
                                cmdLine.pushBack(a);
                                cmdLine.throwUnexpectedArgument();
                            }
                            cmdAndArgs = this.splitCmdAndExecArgs(a.getStringValue().get());
                            toAdd.put(a.key(), new AliasInfo(a.getKey().asString().get(), cmdAndArgs[0], null, null, cmdAndArgs[1]));
                            continue;
                        }
                        if (n == null) {
                            n = a.toString();
                            continue;
                        }
                        cmdAndArgs = this.splitCmdAndExecArgs(a.toString());
                        toAdd.put(n, new AliasInfo(n, cmdAndArgs[0], null, null, cmdAndArgs[1]));
                        n = null;
                        continue;
                    }
                    cmdLine.throwUnexpectedArgument();
                }
                if (toAdd.isEmpty()) {
                    cmdLine.next().get();
                }
                for (AliasInfo value : toAdd.values()) {
                    NWorkspace.of().addCommand(new NCommandConfig().setCommand(NCmdLine.of(value.command, NShellFamily.BASH).setExpandSimpleOptions(false).toStringArray()).setName(value.name).setExecutorOptions(NCmdLine.of(value.executionOptions, NShellFamily.BASH).setExpandSimpleOptions(false).toStringList()));
                }
                NWorkspace.of().saveConfig();
            }
            return true;
        }
        return false;
    }

    private String[] splitCmdAndExecArgs(String aliasValue) {
        NArg r;
        NCmdLine cmdLine2 = NCmdLine.of(aliasValue, NShellFamily.BASH).setExpandSimpleOptions(false);
        ArrayList<String> executionOptions = new ArrayList<String>();
        while (cmdLine2.hasNext() && (r = cmdLine2.peek().get()).isOption()) {
            executionOptions.add((String)cmdLine2.next().flatMap(NArg::asString).get());
        }
        if (executionOptions.isEmpty()) {
            return new String[]{aliasValue, null};
        }
        return new String[]{cmdLine2.toString(), NCmdLine.of(executionOptions.toArray(new String[0])).toString()};
    }

    public static class AliasInfo {
        public String name;
        public String command;
        public String factoryId;
        public NId owner;
        public String executionOptions;

        public AliasInfo(String name, String command, String factoryId, NId owner, String executionOptions) {
            this.name = name;
            this.command = command;
            this.factoryId = factoryId;
            this.owner = owner;
            this.executionOptions = executionOptions;
        }

        public AliasInfo(NCustomCmd a) {
            this.name = a.getName();
            this.command = NCmdLine.of(a.getCommand()).toString();
            this.executionOptions = NCmdLine.of(a.getExecutorOptions()).toString();
            this.factoryId = a.getFactoryId();
            this.owner = a.getOwner();
        }

        public String getName() {
            return this.name;
        }

        public String getCommand() {
            return this.command;
        }

        public String getFactoryId() {
            return this.factoryId;
        }

        public NId getOwner() {
            return this.owner;
        }

        public String getExecutionOptions() {
            return this.executionOptions;
        }
    }
}

