/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NErr;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.app.util.NAppUtils;
import net.thevpc.nuts.runtime.standalone.util.ExtraApiUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.internal.DefaultInternalNExecutableCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.NSettingsSubCommand;
import net.thevpc.nuts.text.NMsg;

public class DefaultNSettingsInternalExecutable
extends DefaultInternalNExecutableCommand {
    private List<NSettingsSubCommand> subCommands;

    public DefaultNSettingsInternalExecutable(String[] args, NExecCmd execCommand) {
        super("settings", args, execCommand);
    }

    @Override
    public int execute() {
        NArg a;
        boolean dry = ExtraApiUtils.asBoolean(this.getExecCommand().getDry());
        if (dry) {
            this.dryExecute();
            return 0;
        }
        if (NAppUtils.processHelpOptions(this.args)) {
            this.showDefaultHelp();
            return 0;
        }
        Boolean autoSave = true;
        NCmdLine cmd = NCmdLine.of(this.args);
        boolean empty = true;
        while ((a = cmd.peek().get()) != null) {
            boolean enabled = a.isUncommented();
            if (a.isOption() && (a.key().equals("-?") || a.key().equals("-h") || a.key().equals("-help"))) {
                cmd.skip();
                if (!enabled) break;
                if (cmd.isExecMode()) {
                    this.showDefaultHelp();
                }
                cmd.skipAll();
                throw new NExecutionException(NMsg.ofPlain("help"), 0);
            }
            NSettingsSubCommand selectedSubCommand = null;
            for (NSettingsSubCommand subCommand : this.getSubCommands()) {
                if (!subCommand.exec(cmd, autoSave)) continue;
                selectedSubCommand = subCommand;
                empty = false;
                break;
            }
            NSession session = NSession.of();
            if (selectedSubCommand != null) {
                if (!cmd.isExecMode()) {
                    return 0;
                }
                if (!cmd.hasNext()) break;
                NPrintStream out = session.err();
                out.println(NMsg.ofC("unexpected %s", cmd.peek()));
                out.println("type for more help : nuts settings -h");
                throw new NExecutionException(NMsg.ofC("unexpected %s", cmd.peek()), 1);
            }
            session.configureLast(cmd);
            if (cmd.hasNext()) continue;
        }
        if (empty) {
            NErr.println("missing settings command");
            NErr.println("type for more help : nuts settings -h");
            throw new NExecutionException(NMsg.ofPlain("missing settings command"), 1);
        }
        return 0;
    }

    public List<NSettingsSubCommand> getSubCommands() {
        if (this.subCommands == null) {
            this.subCommands = new ArrayList<NSettingsSubCommand>(NExtensions.of().createComponents(NSettingsSubCommand.class, this));
        }
        return this.subCommands;
    }
}

