/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NCommandConfig;
import net.thevpc.nuts.command.NCommandFactoryConfig;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.core.NWorkspaceCmdFactory;
import net.thevpc.nuts.platform.NShellFamily;

public class CommandNWorkspaceCommandFactory
implements NWorkspaceCmdFactory {
    private int priority = 10;
    private String factoryId;
    private String[] findCommand;
    private String[] execCommand;
    private String[] listCommand;

    @Override
    public void configure(NCommandFactoryConfig config) {
        Map<String, String> p;
        this.factoryId = config.getFactoryId();
        this.factoryId = "command";
        this.priority = config.getPriority();
        if (this.priority <= 0) {
            this.priority = 1;
        }
        if ((p = config.getParameters()) != null) {
            this.findCommand = this.validateCommand(p.get("find"));
            this.execCommand = this.validateCommand(p.get("exec"));
            String slistCommand = p.get("list");
            String[] stringArray = this.listCommand = slistCommand == null ? new String[]{} : NCmdLine.of(slistCommand, NShellFamily.BASH).setExpandSimpleOptions(false).toStringArray();
            if (this.listCommand.length > 0 && !this.listCommand[0].contains(":")) {
                this.listCommand = new String[0];
            }
        }
    }

    private String[] replaceParam(String[] command, String name) {
        String[] command2 = Arrays.copyOf(command, command.length);
        for (int i = 0; i < command2.length; ++i) {
            if (!command2[i].equals("%n")) continue;
            command2[i] = name;
        }
        return command2;
    }

    private String[] validateCommand(String command) {
        if (command == null) {
            return new String[0];
        }
        String[] commandArr = NCmdLine.of(command, NShellFamily.BASH).setExpandSimpleOptions(false).toStringArray();
        if (commandArr.length == 0) {
            return commandArr;
        }
        boolean found = false;
        for (String s : commandArr) {
            if (!s.equals("%n")) continue;
            found = true;
            break;
        }
        if (!found) {
            commandArr = Arrays.copyOf(commandArr, commandArr.length + 1);
            commandArr[commandArr.length - 1] = "%n";
        }
        if (commandArr.length > 0 && !commandArr[0].contains(":")) {
            commandArr = new String[]{};
        }
        return commandArr;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getFactoryId() {
        return this.factoryId;
    }

    @Override
    public NCommandConfig findCommand(String name) {
        if (this.findCommand.length > 0 && this.execCommand.length > 0) {
            String[] fc = this.replaceParam(this.findCommand, name);
            String[] ec = this.replaceParam(this.execCommand, name);
            NExecCmd exec = NExecCmd.of().addCommand(fc).grabAll().run();
            int r = exec.getResultCode();
            if (r == 0) {
                return new NCommandConfig().setFactoryId(this.getFactoryId()).setOwner(NId.get(ec[0]).get()).setName(name).setCommand(Arrays.copyOfRange(ec, 1, ec.length));
            }
        }
        return null;
    }

    @Override
    public List<NCommandConfig> findCommands() {
        NExecCmd b;
        int r;
        ArrayList<NCommandConfig> c = new ArrayList<NCommandConfig>();
        if (this.listCommand.length > 0 && (r = (b = NExecCmd.of().addCommand(this.listCommand).grabAll()).getResultCode()) == 0) {
            for (String s : b.getGrabbedOutString().split("\n")) {
                if ((s = s.trim()).length() <= 0) continue;
                c.add(new NCommandConfig().setName(s).setCommand("net.thevpc.nsh:nsh", s));
            }
        }
        return c;
    }
}

