/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionFilterUtils;
import net.thevpc.nuts.runtime.standalone.id.filter.NPatternIdFilter;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.DefaultNSearchCmd;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.DefaultNSearchInfo;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorUtils;

public class DefaultNSearchInfoBuilder {
    private DefaultNSearchCmd defaultNSearchCmd;

    public DefaultNSearchInfoBuilder(DefaultNSearchCmd defaultNSearchCmd) {
        this.defaultNSearchCmd = defaultNSearchCmd;
    }

    private boolean isIncludedShortName(NId id, Set<String> someIds) {
        NId c;
        for (String o : someIds) {
            if (!NBlankable.isBlank(o) || !(c = NId.of(o)).getShortName().equals(id.getShortName())) continue;
            return true;
        }
        for (String o : someIds) {
            if (!NBlankable.isBlank(o) || !NBlankable.isBlank((c = NId.of(o)).getGroupId()) || !c.getArtifactId().equals(id.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public DefaultNSearchInfo build() {
        NId nId;
        LinkedHashSet<String> someIds = new LinkedHashSet<String>();
        for (NId id : this.defaultNSearchCmd.getIds()) {
            someIds.add(id.toString());
        }
        if (this.defaultNSearchCmd.isCompanion()) {
            for (NId s : NExtensions.of().getCompanionIds()) {
                if (this.isIncludedShortName(s, someIds)) continue;
                someIds.add(s.toString());
            }
        }
        if (this.defaultNSearchCmd.isRuntime() && !this.isIncludedShortName(nId = NId.of("net.thevpc.nuts:nuts-runtime"), someIds)) {
            someIds.add(nId.toString());
        }
        LinkedHashSet<DefaultNSearchInfo.RegularId> regularIds = new LinkedHashSet<DefaultNSearchInfo.RegularId>();
        HashSet<String> wildcardIds = new HashSet<String>();
        for (String someId : someIds) {
            if (NPatternIdFilter.containsWildcard(someId)) {
                wildcardIds.add(someId);
                continue;
            }
            regularIds.add(new DefaultNSearchInfo.RegularId(NId.of(someId), this.expandRegularIdPossibilities(someId)));
        }
        regularIds.addAll(Arrays.stream(NDefinitionFilterUtils.asPatternDefinitionFilterOrList(this.defaultNSearchCmd.getDefinitionFilter())).filter(x -> !x.isWildcard()).map(x -> new DefaultNSearchInfo.RegularId(x.getId(), this.expandRegularIdPossibilities(x.getId().toString()))).collect(Collectors.toList()));
        NDefinitionFilters d = NDefinitionFilters.of();
        NDefinitionFilter _defFilter = ((NDefinitionFilter)d.always()).and(this.defaultNSearchCmd.getDefinitionFilter());
        if (this.defaultNSearchCmd.getExecType() != null) {
            switch (this.defaultNSearchCmd.getExecType()) {
                case LIB: {
                    _defFilter = _defFilter.and(d.byFlag(NDescriptorFlag.EXEC).neg());
                    break;
                }
                case EXEC: {
                    _defFilter = _defFilter.and(d.byFlag(NDescriptorFlag.EXEC));
                    break;
                }
                case NUTS_APPLICATION: {
                    _defFilter = _defFilter.and(d.byFlag(NDescriptorFlag.NUTS_APP));
                    break;
                }
                case PLATFORM_APPLICATION: {
                    _defFilter = _defFilter.and(d.byFlag(NDescriptorFlag.PLATFORM_APP));
                    break;
                }
                case EXTENSION: {
                    _defFilter = _defFilter.and(d.byExtension(this.defaultNSearchCmd.getTargetApiVersion()));
                    break;
                }
                case RUNTIME: {
                    _defFilter = _defFilter.and(d.byRuntime(this.defaultNSearchCmd.getTargetApiVersion()));
                    break;
                }
                case COMPANION: {
                    _defFilter = _defFilter.and(d.byCompanion(this.defaultNSearchCmd.getTargetApiVersion()));
                }
            }
        } else if (this.defaultNSearchCmd.getTargetApiVersion() != null) {
            _defFilter = _defFilter.and(d.byApiVersion(this.defaultNSearchCmd.getTargetApiVersion()));
        }
        return new DefaultNSearchInfo(regularIds.toArray(new DefaultNSearchInfo.RegularId[0]), ((NRepositoryFilter)NRepositoryFilters.of().always()).and(this.defaultNSearchCmd.getRepositoryFilter()).and(NDefinitionFilterUtils.toRepositoryFilter(_defFilter)), _defFilter);
    }

    private NId[] expandRegularIdPossibilities(String id) {
        NId nutsId = NId.get(id).get();
        LinkedHashSet<NId> nutsId2 = new LinkedHashSet<NId>();
        if (NBlankable.isBlank(nutsId.getGroupId())) {
            if (nutsId.getArtifactId().equals("nuts")) {
                nutsId2.add(nutsId.builder().setGroupId("net.thevpc.nuts").build());
            } else {
                List<Object> installedIds = Collections.emptyList();
                if (!nutsId.getArtifactId().contains("*")) {
                    NRepositorySPI repoSPI = NWorkspaceUtils.of().toRepositorySPI(NWorkspaceExt.of().getInstalledRepository());
                    NIterator<NId> it = repoSPI.search().setFetchMode(NFetchMode.LOCAL).setFilter(NDefinitionFilters.of().byName(nutsId.builder().setGroupId("").build().toString())).getResult();
                    installedIds = NIteratorUtils.toList(it);
                }
                if (!installedIds.isEmpty()) {
                    nutsId2.addAll(installedIds);
                } else {
                    for (String aImport : NWorkspace.of().getAllImports()) {
                        nutsId2.add(nutsId.builder().setGroupId(aImport + "." + nutsId.getArtifactId()).build());
                        nutsId2.add(nutsId.builder().setGroupId(aImport).build());
                    }
                }
            }
            nutsId2.add(nutsId.builder().setGroupId("").build());
        } else {
            nutsId2.add(nutsId);
        }
        return nutsId2.toArray(new NId[0]);
    }
}

