/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.runtime.standalone.format.desc.NEDescHelper;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NRepositoryAndFetchMode;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch.DefaultNFetchCmd;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.AbstractNSearchCmd;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.DefaultNSearchInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.DefaultNSearchInfoBuilder;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NIteratorUtils;
import net.thevpc.nuts.util.NPredicates;

public class DefaultNSearchCmd
extends AbstractNSearchCmd {
    @Override
    public NSearchCmd copy() {
        DefaultNSearchCmd b = new DefaultNSearchCmd();
        b.copyFrom(this);
        return b;
    }

    @Override
    public NFetchCmd toFetch() {
        NFetchCmd t = (NFetchCmd)new DefaultNFetchCmd().copyFromDefaultNQueryBaseOptions(this);
        t.setIgnoreCurrentEnvironment(this.isIgnoreCurrentEnvironment());
        DefaultNSearchInfo bs = new DefaultNSearchInfoBuilder(this).build();
        t.setRepositoryFilter(bs.getRepositoryFilter());
        return t;
    }

    @Override
    public NIterator<NId> getResultIdIteratorBase(Boolean forceInlineDependencies) {
        boolean inlineDependencies = forceInlineDependencies == null ? this.isInlineDependencies() : forceInlineDependencies.booleanValue();
        DefaultNSearchInfo search = new DefaultNSearchInfoBuilder(this).build();
        ArrayList allResults = new ArrayList();
        NSession session = NSession.of();
        NRepositoryFilter sRepositoryFilter = search.getRepositoryFilter();
        DefaultNSearchInfo.RegularId[] regularIds = search.getRegularIds();
        NFetchStrategy fetchMode = NWorkspaceHelper.validate(session.getFetchStrategy().orDefault());
        HashSet<NRepository> consideredRepos = new HashSet<NRepository>();
        NWorkspaceUtils wu = NWorkspaceUtils.of();
        if (regularIds.length > 0) {
            for (DefaultNSearchInfo.RegularId rid : regularIds) {
                ArrayList resultForEachAlternative = new ArrayList();
                for (NId nutsId1 : rid.expandedIds) {
                    if (NDependencyScope.parse(nutsId1.toDependency().getScope()).orNull() == NDependencyScope.SYSTEM) continue;
                    NId nutsIdNonLatest = nutsId1;
                    boolean latestVersion = false;
                    boolean releaseVersion = false;
                    if (nutsIdNonLatest.getVersion().isLatestVersion()) {
                        latestVersion = true;
                        nutsIdNonLatest = nutsIdNonLatest.builder().setVersion("").build();
                    } else if (nutsIdNonLatest.getVersion().isReleaseVersion()) {
                        releaseVersion = true;
                        nutsIdNonLatest = nutsIdNonLatest.builder().setVersion("").build();
                    }
                    NDefinitionFilters dd = NDefinitionFilters.of();
                    NDefinitionFilter filter = dd.byName(nutsIdNonLatest.getFullName()).and(dd.byEnv(nutsIdNonLatest.getProperties())).and(search.getDefinitionFilter());
                    List<NRepositoryAndFetchMode> repositoryAndFetchModes = wu.filterRepositoryAndFetchModes(NRepositorySupportedAction.SEARCH, nutsIdNonLatest, sRepositoryFilter, fetchMode);
                    ArrayList idLocal = new ArrayList();
                    ArrayList idRemote = new ArrayList();
                    for (NFetchMode fm : new NFetchMode[]{NFetchMode.LOCAL, NFetchMode.REMOTE}) {
                        ArrayList idLookup = fm == NFetchMode.LOCAL ? idLocal : idRemote;
                        for (NRepositoryAndFetchMode repoAndMode : repositoryAndFetchModes) {
                            if (repoAndMode.getFetchMode() != fm) continue;
                            consideredRepos.add(repoAndMode.getRepository());
                            NRepositorySPI repoSPI = wu.toRepositorySPI(repoAndMode.getRepository());
                            if (nutsIdNonLatest.getGroupId() != null) {
                                NIterator<NId> baseIter = repoSPI.searchVersions().setId(nutsIdNonLatest).setFilter(filter).setFetchMode(repoAndMode.getFetchMode()).getResult();
                                if (NIteratorUtils.isNullOrEmpty(baseIter)) continue;
                                NIterator<NId> z = NIteratorBuilder.of(baseIter).named(NElement.ofObjectBuilder().set("description", "searchVersions").set("repository", repoAndMode.getRepository().getName()).set("fetchMode", repoAndMode.getFetchMode().id()).set("filter", NElementDescribables.describeResolveOrDestruct(filter)).build()).safeIgnore().iterator();
                                z = this.filterLatestAndDuplicatesThenSort(z, this.isLatest() || latestVersion || releaseVersion, this.isDistinct(), false);
                                idLookup.add(z);
                                continue;
                            }
                            NDefinitionFilter restrictedFilter = (NDefinitionFilter)NDefinitionFilters.of().byName(nutsIdNonLatest.toString()).and(filter).simplify();
                            NIterator<NId> baseIter = repoSPI.search().setFilter(restrictedFilter).setFetchMode(repoAndMode.getFetchMode()).getResult();
                            if (NIteratorUtils.isNullOrEmpty(baseIter)) continue;
                            NIterator<NId> z = NIteratorBuilder.of(baseIter).named(NElement.ofObjectBuilder().set("description", "search").set("repository", repoAndMode.getRepository().getName()).set("fetchMode", repoAndMode.getFetchMode().id()).set("filter", NElementDescribables.describeResolveOrDestruct(restrictedFilter)).build()).safeIgnore().iterator();
                            z = this.filterLatestAndDuplicatesThenSort(z, this.isLatest() || latestVersion || releaseVersion, this.isDistinct(), false);
                            idLookup.add(z);
                        }
                    }
                    if (fetchMode.isStopFast()) {
                        NIterator loc2 = NIteratorUtils.concat(idLocal);
                        loc2 = (NIterator)loc2.redescribe(NElementDescribables.ofDesc(NEDescHelper.addProperty(loc2.describe(), "localSearchList", true)));
                        NIterator rem2 = NIteratorUtils.concat(idRemote);
                        rem2 = (NIterator)rem2.redescribe(NElementDescribables.ofDesc(NEDescHelper.addProperty(rem2.describe(), "remoteSearchList", true)));
                        resultForEachAlternative.add(NIteratorUtils.coalesce(loc2, rem2));
                        continue;
                    }
                    resultForEachAlternative.add(NIteratorUtils.concatLists(idLocal, idRemote));
                }
                allResults.add(NIteratorUtils.coalesce(resultForEachAlternative));
            }
        } else {
            NDefinitionFilter filter = search.getDefinitionFilter();
            ArrayList all = new ArrayList();
            for (NRepositoryAndFetchMode repoAndMode : wu.filterRepositoryAndFetchModes(NRepositorySupportedAction.SEARCH, null, sRepositoryFilter, fetchMode)) {
                consideredRepos.add(repoAndMode.getRepository());
                all.add(NIteratorBuilder.ofSupplier(() -> wu.toRepositorySPI(repoAndMode.getRepository()).search().setFilter(filter).setFetchMode(repoAndMode.getFetchMode()).getResult(), NElementDescribables.ofDesc(NElement.ofObjectBuilder().set("description", "searchRepository").set("repository", repoAndMode.getRepository().getName()).set("fetchMode", repoAndMode.getFetchMode().id()).set("filter", NElementDescribables.describeResolveOrDestruct(filter)).build())).safeIgnore().iterator());
            }
            allResults.add(fetchMode.isStopFast() ? NIteratorUtils.coalesce(all) : NIteratorUtils.concat(all));
        }
        NIterator<Object> baseIterator = NIteratorUtils.concat(allResults);
        if (inlineDependencies) {
            NIterator<Object> curr = baseIterator = this.filterLatestAndDuplicatesThenSort(baseIterator, this.isLatest(), this.isDistinct(), false);
            baseIterator = NIteratorBuilder.of(curr).flatMap(NFunction.of((T x) -> {
                NDefinition de = this.toFetch().setId((NId)x).getResultDefinition();
                if (de == null) {
                    return null;
                }
                return NIteratorBuilder.of(de.getDependencies().get().transitiveWithSource().iterator()).build();
            }).redescribe((Supplier)NElementDescribables.ofDesc("getDependencies"))).filter(NPredicates.nonNull()).map(NFunction.of(NDependency::toId).redescribe((Supplier)NElementDescribables.ofDesc("DependencyToId"))).build();
        }
        return this.filterLatestAndDuplicatesThenSort(baseIterator, this.isLatest(), this.isDistinct(), this.isSorted());
    }

    private NIterator<NId> filterLatestAndDuplicatesThenSort(NIterator<NId> baseIterator, boolean latest, boolean distinct, boolean sort) {
        NIterator<NId> r = !latest && !distinct ? baseIterator : (!latest && distinct ? NIteratorBuilder.of(baseIterator).distinct(NFunction.of((T nutsId) -> nutsId.getLongId().toString()).redescribe((Supplier)NElementDescribables.ofDesc("getLongId"))).iterator() : (latest && distinct ? NIteratorBuilder.ofSupplier(() -> {
            LinkedHashMap<String, NId> visited = new LinkedHashMap<String, NId>();
            while (baseIterator.hasNext()) {
                NId nutsId = (NId)baseIterator.next();
                String k = nutsId.getShortName();
                NId old = (NId)visited.get(k);
                if (old != null && !old.getVersion().isBlank() && old.getVersion().compareTo(nutsId.getVersion()) >= 0) continue;
                visited.put(k, nutsId);
            }
            return visited.values().iterator();
        }, () -> NElementDescribables.describeResolveOrDestructAsObject(baseIterator).builder().set("latest", true).set("distinct", true).build()).build() : NIteratorBuilder.ofSupplier(() -> {
            LinkedHashMap<String, ArrayList<NId>> visited = new LinkedHashMap<String, ArrayList<NId>>();
            while (baseIterator.hasNext()) {
                NId old;
                NId nutsId = (NId)baseIterator.next();
                String k = nutsId.getShortName();
                List oldList = (List)visited.get(k);
                NId nId = old = oldList == null ? null : (NId)oldList.get(0);
                if (old == null || old.getVersion().isBlank() || old.getVersion().compareTo(nutsId.getVersion()) < 0) {
                    visited.put(k, new ArrayList<NId>(Arrays.asList(nutsId)));
                    continue;
                }
                if (old.getVersion().compareTo(nutsId.getVersion()) != 0) continue;
                oldList.add(nutsId);
            }
            return NIteratorBuilder.ofFlatMap((NIterator)NIterator.of(visited.values().iterator()).redescribe(NElementDescribables.ofDesc("visited"))).build();
        }, () -> NElementDescribables.describeResolveOrDestructAsObject(baseIterator).builder().set("latest", true).set("duplicates", true).build()).build()));
        if (sort) {
            r = NIteratorUtils.sort(r, this.comparator, false);
        }
        return r;
    }
}

