/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.search;

import java.io.File;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyTreeNode;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionEntry;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NErr;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNDefinitionBuilder2;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionFilterUtils;
import net.thevpc.nuts.runtime.standalone.dependency.util.NClassLoaderUtils;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNClassLoader;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNExtensions;
import net.thevpc.nuts.runtime.standalone.format.NDisplayProperty;
import net.thevpc.nuts.runtime.standalone.format.NFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.NIdFormatHelper;
import net.thevpc.nuts.runtime.standalone.util.ValueSupplier;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamFromNIterator;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.DefaultNQueryBaseOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.SearchExecType;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NComparator;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public abstract class AbstractNSearchCmd
extends DefaultNQueryBaseOptions<NSearchCmd>
implements NSearchCmd {
    protected final List<NId> ids = new ArrayList<NId>();
    protected NComparator comparator;
    protected NDefinitionFilter definitionFilter;
    protected boolean latest = false;
    protected boolean distinct = false;
    protected boolean includeBasePackage = true;
    protected boolean sorted = false;
    protected boolean ignoreCurrentEnvironment;
    protected boolean describe;
    protected SearchExecType execType = null;
    protected NVersion targetApiVersion = null;

    public AbstractNSearchCmd() {
        super("search");
    }

    @Override
    public boolean isIgnoreCurrentEnvironment() {
        return this.ignoreCurrentEnvironment;
    }

    @Override
    public NSearchCmd setIgnoreCurrentEnvironment(boolean ignoreCurrentEnvironment) {
        this.ignoreCurrentEnvironment = ignoreCurrentEnvironment;
        return this;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NSearchCmd clearIds() {
        this.ids.clear();
        return this;
    }

    @Override
    public NSearchCmd addId(String id) {
        if (!NBlankable.isBlank(id)) {
            this.ids.add(NId.get(id).get());
        }
        return this;
    }

    @Override
    public NSearchCmd addId(NId id) {
        if (id != null) {
            this.ids.add(id);
        }
        return this;
    }

    @Override
    public NSearchCmd addIds(String ... values) {
        if (values != null) {
            for (String s : values) {
                if (NBlankable.isBlank(s)) continue;
                this.ids.add(NId.get(s).get());
            }
        }
        return this;
    }

    @Override
    public NSearchCmd addIds(NId ... value) {
        if (value != null) {
            for (NId s : value) {
                if (s == null) continue;
                this.ids.add(s);
            }
        }
        return this;
    }

    @Override
    public NSearchCmd removeId(String id) {
        this.ids.remove(NId.get(id).get());
        return this;
    }

    @Override
    public NSearchCmd removeId(NId id) {
        if (id != null) {
            this.removeId(id.toString());
        }
        return this;
    }

    @Override
    public boolean isRuntime() {
        return SearchExecType.RUNTIME == this.execType;
    }

    @Override
    public NSearchCmd setRuntime(boolean enable) {
        this.execType = enable ? SearchExecType.RUNTIME : null;
        return this;
    }

    @Override
    public boolean isCompanion() {
        return this.execType == SearchExecType.COMPANION;
    }

    @Override
    public NSearchCmd setCompanion(boolean enable) {
        this.execType = enable ? SearchExecType.COMPANION : null;
        return this;
    }

    @Override
    public boolean isExtension() {
        return SearchExecType.EXTENSION == this.execType;
    }

    @Override
    public NSearchCmd setExtension(boolean enable) {
        this.execType = enable ? SearchExecType.EXTENSION : null;
        return this;
    }

    @Override
    public boolean isExec() {
        return SearchExecType.EXEC == this.execType;
    }

    @Override
    public NSearchCmd setExec(boolean enable) {
        this.execType = enable ? SearchExecType.EXEC : null;
        return this;
    }

    @Override
    public boolean isNutsApplication() {
        return SearchExecType.NUTS_APPLICATION == this.execType;
    }

    @Override
    public NSearchCmd setNutsApplication(boolean enable) {
        this.execType = enable ? SearchExecType.NUTS_APPLICATION : null;
        return this;
    }

    @Override
    public boolean isPlatformApplication() {
        return SearchExecType.PLATFORM_APPLICATION == this.execType;
    }

    @Override
    public NSearchCmd setPlatformApplication(boolean enable) {
        this.execType = enable ? SearchExecType.PLATFORM_APPLICATION : null;
        return this;
    }

    @Override
    public boolean isLib() {
        return SearchExecType.LIB == this.execType;
    }

    @Override
    public NSearchCmd setLib(boolean enable) {
        this.execType = enable ? SearchExecType.LIB : null;
        return this;
    }

    @Override
    public NSearchCmd sort(Comparator<?> comparator) {
        this.comparator = NComparator.of(comparator);
        this.sorted = true;
        return this;
    }

    @Override
    public NSearchCmd copyFrom(NSearchCmd other) {
        super.copyFromDefaultNQueryBaseOptions((DefaultNQueryBaseOptions)((Object)other));
        if (other != null) {
            NSearchCmd o = other;
            this.ignoreCurrentEnvironment = o.isIgnoreCurrentEnvironment();
            this.comparator = o.getComparator();
            this.definitionFilter = o.getDefinitionFilter();
            this.latest = o.isLatest();
            this.distinct = o.isDistinct();
            this.includeBasePackage = o.isBasePackage();
            this.sorted = o.isSorted();
            this.ids.clear();
            this.ids.addAll(o.getIds());
        }
        return this;
    }

    @Override
    public NSearchCmd copyFrom(NFetchCmd other) {
        super.copyFromDefaultNQueryBaseOptions((DefaultNQueryBaseOptions)((Object)other));
        return this;
    }

    @Override
    public List<NId> getIds() {
        return this.ids;
    }

    @Override
    public NSearchCmd setIds(String ... ids) {
        this.clearIds();
        this.addIds(ids);
        return this;
    }

    @Override
    public NSearchCmd setIds(NId ... ids) {
        this.clearIds();
        this.addIds(ids);
        return this;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public NSearchCmd setSorted(boolean sort) {
        this.sorted = sort;
        return this;
    }

    @Override
    public NDefinitionFilter getDefinitionFilter() {
        return this.definitionFilter;
    }

    @Override
    public NSearchCmd setDefinitionFilter(NDefinitionFilter filter) {
        this.definitionFilter = filter;
        return this;
    }

    @Override
    public NSearchCmd addDefinitionFilter(NDefinitionFilter filter) {
        if (filter != null) {
            if (this.definitionFilter == null) {
                this.definitionFilter = filter;
            } else {
                this.definitionFilter.and(filter);
            }
        }
        return this;
    }

    public NComparator getComparator() {
        return this.comparator;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public NSearchCmd setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    public NSearchCmd distinct() {
        return this.setDistinct(true);
    }

    @Override
    public NVersion getTargetApiVersion() {
        return this.targetApiVersion;
    }

    @Override
    public NSearchCmd setTargetApiVersion(NVersion targetApiVersion) {
        this.targetApiVersion = targetApiVersion;
        return this;
    }

    @Override
    public boolean isBasePackage() {
        return this.includeBasePackage;
    }

    @Override
    public NSearchCmd setBasePackage(boolean includeBasePackage) {
        this.includeBasePackage = includeBasePackage;
        return this;
    }

    @Override
    public boolean isLatest() {
        return this.latest;
    }

    @Override
    public NSearchCmd setLatest(boolean enable) {
        this.latest = enable;
        return this;
    }

    @Override
    public NSearchCmd latest() {
        return this.setLatest(true);
    }

    @Override
    public NStream<NId> getResultIds() {
        return this.buildCollectionResult(this.getResultIdIteratorBase(null));
    }

    @Override
    public NStream<NDependencies> getResultDependencies() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).map(NFunction.of((T x) -> x.getDependencies().get()).redescribe((Supplier)NElementDescribables.ofDesc("getDependencies"))));
    }

    @Override
    public NStream<NDependency> getResultInlineDependencies() {
        return this.buildCollectionResult(NIteratorBuilder.of(this.getResultIdIteratorBase(true)).map(NFunction.of(NId::toDependency).redescribe((Supplier)NElementDescribables.ofDesc("Id->Dependency"))).build());
    }

    @Override
    public NStream<NDefinition> getResultDefinitions() {
        return this.buildCollectionResult(this.getResultDefinitionIteratorBase());
    }

    @Override
    public NStream<NDescriptor> getResultDescriptors() {
        return this.getResultDefinitions().map(NDefinition::getDescriptor);
    }

    @Override
    public ClassLoader getResultClassLoader() {
        return this.getResultClassLoader(null);
    }

    @Override
    public ClassLoader getResultClassLoader(ClassLoader parent) {
        List<NDefinition> nDefinitions = this.getResultDefinitions().toList();
        URL[] allURLs = new URL[nDefinitions.size()];
        NId[] allIds = new NId[nDefinitions.size()];
        for (int i = 0; i < allURLs.length; ++i) {
            NDefinition d = nDefinitions.get(i);
            allURLs[i] = (URL)d.getContent().flatMap(NPath::toURL).orNull();
            allIds[i] = d.getId();
        }
        DefaultNClassLoader cl = ((DefaultNExtensions)NExtensions.of()).getModel().getNutsURLClassLoader("SEARCH-" + UUID.randomUUID(), parent);
        for (NDefinition def : nDefinitions) {
            cl.add(NClassLoaderUtils.definitionToClassLoaderNode(def, this.getRepositoryFilter()));
        }
        return cl;
    }

    @Override
    public String getResultNutsPath() {
        return this.getResultIds().toList().stream().map(NId::getLongName).collect(Collectors.joining(";"));
    }

    @Override
    public String getResultClassPath() {
        StringBuilder sb = new StringBuilder();
        NIterator<NDefinition> it = this.getResultDefinitionIteratorBase();
        while (it.hasNext()) {
            NDefinition nDefinition = (NDefinition)it.next();
            if (!nDefinition.getContent().isPresent()) continue;
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(nDefinition.getContent().orNull());
        }
        return sb.toString();
    }

    @Override
    public NStream<String> getResultPaths() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).map(NFunction.of((T x) -> x.getContent().map(Object::toString).orNull()).redescribe((Supplier)NElementDescribables.ofDesc("getPath"))).notBlank());
    }

    @Override
    public NStream<String> getResultPathNames() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).map(NFunction.of((T x) -> x.getContent().map(NPath::getName).orNull()).redescribe((Supplier)NElementDescribables.ofDesc("getName"))).notBlank());
    }

    @Override
    public NStream<Instant> getResultInstallDates() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).map(NFunction.of((T x) -> x.getInstallInformation().map(NInstallInformation::getCreatedInstant).orNull()).redescribe((Supplier)NElementDescribables.ofDesc("getCreatedInstant"))).notNull());
    }

    @Override
    public NStream<String> getResultInstallUsers() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).map(NFunction.of((T x) -> x.getInstallInformation().map(NInstallInformation::getInstallUser).orNull()).redescribe((Supplier)NElementDescribables.ofDesc("getInstallUser"))).notBlank());
    }

    @Override
    public NStream<NPath> getResultInstallFolders() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).map(NFunction.of((T x) -> x.getInstallInformation().map(NInstallInformation::getInstallFolder).orNull()).redescribe((Supplier)NElementDescribables.ofDesc("getInstallFolder"))).notNull());
    }

    @Override
    public NStream<NPath> getResultStoreLocations(NStoreType location) {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).map(NFunction.of((T x) -> NPath.ofIdStore(x.getId(), location)).redescribe((Supplier)NElementDescribables.ofDesc("getStoreLocation(" + location.id() + ")"))).notNull());
    }

    @Override
    public NStream<String[]> getResultStrings(String[] columns) {
        NFetchDisplayOptions oo = new NFetchDisplayOptions();
        oo.addDisplay(columns);
        oo.setIdFormat(this.getDisplayOptions().getIdFormat());
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).map(NFunction.of((T x) -> NIdFormatHelper.of(x).buildLong().getMultiColumnRowStrings(oo)).redescribe((Supplier)NElementDescribables.ofDesc("getColumns"))));
    }

    @Override
    public NStream<String> getResultNames() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).mapMulti(NFunction.of((T x) -> Arrays.asList(x.getDescriptor().getName())).redescribe((Supplier)NElementDescribables.ofDesc("getDescriptorName"))).notBlank());
    }

    @Override
    public NStream<String> getResultOs() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).mapMulti(NFunction.of((T x) -> Arrays.asList(x.getDescriptor().getCondition().getOs())).redescribe((Supplier)NElementDescribables.ofDesc("getOs"))).notBlank().distinct());
    }

    @Override
    public NStream<NExecutionEntry> getResultExecutionEntries() {
        NIteratorBuilder<NDefinition> defIter = NIteratorBuilder.of(this.getResultDefinitionIteratorBase());
        return this.postProcessResult(defIter.mapMulti(NFunction.of((T x) -> x.getContent().map(NExecutionEntry::parse).orElse(Collections.emptyList())).redescribe((Supplier)NElementDescribables.ofDesc("getFile"))));
    }

    @Override
    public NStream<String> getResultOsDist() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).mapMulti(NFunction.of((T x) -> Arrays.asList(x.getDescriptor().getCondition().getOsDist())).redescribe((Supplier)NElementDescribables.ofDesc("getOsDist"))).notBlank().distinct());
    }

    @Override
    public NStream<String> getResultPackaging() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).mapMulti(NFunction.of((T x) -> Arrays.asList(x.getDescriptor().getPackaging())).redescribe((Supplier)NElementDescribables.ofDesc("getPackaging"))).notBlank().distinct());
    }

    @Override
    public NStream<String> getResultPlatform() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).mapMulti(NFunction.of((T x) -> Arrays.asList(x.getDescriptor().getCondition().getPlatform())).redescribe((Supplier)NElementDescribables.ofDesc("getPlatform"))).notBlank().distinct());
    }

    @Override
    public NStream<String> getResultProfile() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).mapMulti(NFunction.of((T x) -> Arrays.asList(x.getDescriptor().getCondition().getProfiles())).redescribe((Supplier)NElementDescribables.ofDesc("getProfile"))).notBlank().distinct());
    }

    @Override
    public NStream<String> getResultDesktopEnvironment() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).mapMulti(NFunction.of((T x) -> Arrays.asList(x.getDescriptor().getCondition().getDesktopEnvironment())).redescribe((Supplier)NElementDescribables.ofDesc("getDesktopEnvironment"))).notBlank().distinct());
    }

    @Override
    public NStream<String> getResultArch() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).mapMulti(NFunction.of((T x) -> Arrays.asList(x.getDescriptor().getCondition().getArch())).redescribe((Supplier)NElementDescribables.ofDesc("getArch"))).notBlank());
    }

    @Override
    public NSearchCmd setId(String id) {
        this.clearIds();
        this.addId(id);
        return this;
    }

    @Override
    public NSearchCmd setId(NId id) {
        this.clearIds();
        this.addId(id);
        return this;
    }

    public SearchExecType getExecType() {
        return this.execType;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().get();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isUncommented();
        switch (a.key()) {
            case "--inline-dependencies": {
                return cmdLine.matcher().matchFlag(v -> this.setInlineDependencies(v.booleanValue())).anyMatch();
            }
            case "--describe": {
                return cmdLine.matcher().matchFlag(v -> {
                    this.describe = v.booleanValue();
                }).anyMatch();
            }
            case "-L": 
            case "--latest": 
            case "--latest-versions": {
                return cmdLine.matcher().matchFlag(v -> this.setLatest(v.booleanValue())).anyMatch();
            }
            case "--repo": {
                return cmdLine.matcher().matchEntry(v -> this.setRepositoryFilter(NRepositoryFilters.of().bySelector(NStringUtils.split(v.stringValue(), ";,|", true, true).toArray(new String[0])))).anyMatch();
            }
            case "--distinct": {
                return cmdLine.matcher().matchFlag(v -> this.setDistinct(v.booleanValue())).anyMatch();
            }
            case "--default": 
            case "--default-versions": {
                return cmdLine.matcher().matchFlag(v -> this.addDefinitionFilter(NDefinitionFilters.of().byDefaultVersion(v.getBooleanValue().ifError(false).orElse(null)))).anyMatch();
            }
            case "--duplicates": {
                return cmdLine.matcher().matchFlag(v -> this.setDistinct(!v.booleanValue())).anyMatch();
            }
            case "-s": 
            case "--sort": {
                return cmdLine.matcher().matchFlag(v -> this.setSorted(v.booleanValue())).anyMatch();
            }
            case "--base": {
                return cmdLine.matcher().matchFlag(v -> {
                    this.includeBasePackage = v.booleanValue();
                }).anyMatch();
            }
            case "--lib": 
            case "--libs": {
                return cmdLine.matcher().matchFlag(v -> this.setLib(v.booleanValue())).anyMatch();
            }
            case "--app": 
            case "--apps": {
                return cmdLine.matcher().matchFlag(v -> this.setExec(v.booleanValue())).anyMatch();
            }
            case "--companion": 
            case "--companions": {
                return cmdLine.matcher().matchFlag(v -> this.setCompanion(v.booleanValue())).anyMatch();
            }
            case "--extension": 
            case "--extensions": {
                return cmdLine.matcher().matchFlag(v -> this.setExtension(v.booleanValue())).anyMatch();
            }
            case "--runtime": {
                return cmdLine.matcher().matchFlag(v -> this.setRuntime(v.booleanValue())).anyMatch();
            }
            case "--api-version": {
                return cmdLine.matcher().matchEntry(v -> this.setTargetApiVersion(NVersion.get(v.stringValue()).get())).anyMatch();
            }
            case "--nuts-app": 
            case "--nuts-apps": {
                return cmdLine.matcher().matchFlag(v -> this.setNutsApplication(v.booleanValue())).anyMatch();
            }
            case "--arch": {
                return cmdLine.matcher().matchEntry(v -> this.addDefinitionFilter(((NDefinitionFilter)NDefinitionFilters.of().nonnull(this.getDefinitionFilter())).and(NDefinitionFilters.of().byArch(v.stringValue())))).anyMatch();
            }
            case "--packaging": {
                return cmdLine.matcher().matchEntry(v -> this.addDefinitionFilter(((NDefinitionFilter)NDefinitionFilters.of().nonnull(this.getDefinitionFilter())).and(NDefinitionFilters.of().byPackaging(v.stringValue())))).anyMatch();
            }
            case "--id": {
                return cmdLine.matcher().matchEntry(v -> this.addId(v.stringValue())).anyMatch();
            }
            case "--locked-id": {
                return cmdLine.matcher().matchEntry(v -> this.setDefinitionFilter(NDefinitionFilterUtils.addLockedIds(this.getDefinitionFilter(), NId.of(v.stringValue())))).anyMatch();
            }
            case "--deployed": {
                return cmdLine.matcher().matchFlag(v -> this.addDefinitionFilter(NDefinitionFilters.of().byDeployed(a.booleanValue()).and(this.getDefinitionFilter()))).anyMatch();
            }
            case "-i": 
            case "--installed": {
                return cmdLine.matcher().matchFlag(v -> this.addDefinitionFilter(NDefinitionFilters.of().byInstalled(a.booleanValue()).and(this.getDefinitionFilter()))).anyMatch();
            }
            case "--required": {
                return cmdLine.matcher().matchFlag(v -> this.addDefinitionFilter(NDefinitionFilters.of().byRequired(a.booleanValue()).and(this.getDefinitionFilter()))).anyMatch();
            }
            case "--obsolete": {
                return cmdLine.matcher().matchFlag(v -> this.addDefinitionFilter(NDefinitionFilters.of().byObsolete(a.booleanValue()).and(this.getDefinitionFilter()))).anyMatch();
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (a.isOption()) {
            return false;
        }
        cmdLine.skip();
        this.addId(a.asString().get());
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{failFast=" + this.isFailFast() + ", inlineDependencies=" + this.isInlineDependencies() + ", displayOptions=" + this.getDisplayOptions() + ", comparator=" + this.getComparator() + ", dependencyFilter=" + this.getDependencyFilter() + ", descriptorFilter=" + this.getDefinitionFilter() + ", repositoryFilter=" + this.getRepositoryFilter() + ", latest=" + this.isLatest() + ", distinct=" + this.isDistinct() + ", includeMain=" + this.isBasePackage() + ", sorted=" + this.isSorted() + ", ids=" + this.getIds() + ", execType='" + this.getExecType() + '\'' + ", targetApiVersion='" + this.getTargetApiVersion() + '\'' + '}';
    }

    private Object dependenciesToElement(NDependencyTreeNode d) {
        List li;
        NId id = d.getDependency().toId();
        if (d.isPartial()) {
            id = id.builder().setProperty("partial", "true").build();
        }
        if ((li = d.getChildren().stream().map(x -> this.dependenciesToElement((NDependencyTreeNode)x)).collect(Collectors.toList())).isEmpty()) {
            return id;
        }
        HashMap o = new HashMap();
        o.put(id, li);
        return o;
    }

    public <T> NIterator<T> runIterator() {
        NDisplayProperty[] a = this.getDisplayOptions().getDisplayProperties();
        NStream<Object> r = null;
        if (!this.isInlineDependencies()) {
            NContentType of = this.getSearchSession().getOutputFormat().orDefault();
            if (of == null) {
                of = NContentType.TREE;
            }
            switch (of) {
                case JSON: 
                case TSON: 
                case XML: 
                case YAML: 
                case TREE: {
                    return NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).flatMap(NFunction.of((T x) -> x.getDependencies().get().transitiveNodes().iterator()).redescribe((Supplier)NElementDescribables.ofDesc("getDependencies"))).map(NFunction.of((T x) -> this.dependenciesToElement((NDependencyTreeNode)x)).redescribe((Supplier)NElementDescribables.ofDesc("dependenciesToElement"))).build();
                }
            }
            NStream<NDependency> rr = this.getResultInlineDependencies();
            return rr.iterator();
        }
        if (a.length == 0) {
            r = this.getResultIds();
        } else if (a.length == 1) {
            switch (a[0]) {
                case ARCH: {
                    r = this.getResultArch();
                    break;
                }
                case FILE: {
                    r = this.getResultPaths();
                    break;
                }
                case FILE_NAME: {
                    r = this.getResultPathNames();
                    break;
                }
                case NAME: {
                    r = this.getResultNames();
                    break;
                }
                case PACKAGING: {
                    r = this.getResultPackaging();
                    break;
                }
                case PLATFORM: {
                    r = this.getResultPlatform();
                    break;
                }
                case DESKTOP_ENVIRONMENT: {
                    r = this.getResultDesktopEnvironment();
                    break;
                }
                case EXEC_ENTRY: {
                    r = this.getResultExecutionEntries();
                    break;
                }
                case OS: {
                    r = this.getResultOs();
                    break;
                }
                case OSDIST: {
                    r = this.getResultOsDist();
                    break;
                }
                case ID: {
                    r = this.getResultIds();
                    break;
                }
                case INSTALL_DATE: {
                    r = this.getResultInstallDates();
                    break;
                }
                case INSTALL_USER: {
                    r = this.getResultInstallUsers();
                    break;
                }
                case INSTALL_FOLDER: {
                    r = this.getResultInstallFolders();
                    break;
                }
                case BIN_FOLDER: {
                    r = this.getResultStoreLocations(NStoreType.BIN);
                    break;
                }
                case CACHE_FOLDER: {
                    r = this.getResultStoreLocations(NStoreType.CACHE);
                    break;
                }
                case CONF_FOLDER: {
                    r = this.getResultStoreLocations(NStoreType.CONF);
                    break;
                }
                case LIB_FOLDER: {
                    r = this.getResultStoreLocations(NStoreType.LIB);
                    break;
                }
                case LOG_FOLDER: {
                    r = this.getResultStoreLocations(NStoreType.LOG);
                    break;
                }
                case TEMP_FOLDER: {
                    r = this.getResultStoreLocations(NStoreType.TEMP);
                    break;
                }
                case VAR_LOCATION: {
                    r = this.getResultStoreLocations(NStoreType.VAR);
                    break;
                }
                case STATUS: {
                    r = this.getResultStatuses();
                }
            }
        }
        if (r == null) {
            block32: for (NDisplayProperty display : this.getDisplayOptions().getDisplayProperties()) {
                switch (display) {
                    case ARCH: 
                    case NAME: 
                    case PACKAGING: 
                    case PLATFORM: 
                    case OS: 
                    case OSDIST: {
                        continue block32;
                    }
                    case FILE: 
                    case FILE_NAME: 
                    case EXEC_ENTRY: {
                        continue block32;
                    }
                    case INSTALL_DATE: 
                    case INSTALL_USER: {
                        continue block32;
                    }
                }
            }
            r = this.buildCollectionResult(this.getResultDefinitionIteratorBase());
        }
        return r.iterator();
    }

    @Override
    public NElement getResultQueryPlan() {
        return this.toQueryPlan(this.runIterator());
    }

    @Override
    public NSearchCmd run() {
        if (this.describe) {
            NOut.println(this.getResultQueryPlan());
            return this;
        }
        NIterator it = this.runIterator();
        NSession session = NSession.of();
        NIteratorBuilder.of(it).map(x -> x);
        if (session.isDry()) {
            this.displayDryQueryPlan(it);
        } else {
            it = NWorkspaceUtils.of().decoratePrint(it, this.getDisplayOptions());
            long count = 0L;
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            NErr.resetLine();
            if (count == 0L) {
                throw new NExecutionException(NMsg.ofC("No results found."), 1);
            }
        }
        return this;
    }

    private NElement toQueryPlan(NIterator it) {
        return NElement.ofObjectBuilder().set("SearchQueryPlan", NElementDescribables.describeResolveOrDestruct(it)).build();
    }

    private void displayDryQueryPlan(NIterator it) {
        NElement n = this.toQueryPlan(it);
        NSession session = NSession.of();
        NContentType f = session.getOutputFormat().orDefault();
        if (f == NContentType.PLAIN) {
            f = NContentType.TREE;
        }
        NSession session2 = session.copy().setOutputFormat(f);
        session2.out().resetLine().println(n);
    }

    private NDefinition loadedIdToDefinition(NId next) {
        NDefinition d;
        NDependency dep;
        NEnvCondition condition;
        block5: {
            NFetchCmd fetch = this.toFetch();
            condition = next.getCondition();
            dep = next.toDependency();
            d = null;
            try {
                d = fetch.setId(next).getResultDefinition();
            }
            catch (NArtifactNotFoundException e) {
                if (!dep.isOptional()) break block5;
                return null;
            }
        }
        if (d == null) {
            if (this.isFailFast()) {
                throw new NArtifactNotFoundException(next.getLongId());
            }
            return d;
        }
        if (!NBlankable.isBlank(d) && !NBlankable.isBlank(condition)) {
            DefaultNDefinitionBuilder2 db = new DefaultNDefinitionBuilder2(d);
            db.setDependency(new ValueSupplier<NDependency>(dep));
            d = db.build();
        }
        return d;
    }

    public NIterator<NDefinition> getResultDefinitionIteratorBase() {
        return NIteratorBuilder.of(this.getResultIdIteratorBase(null)).map(NFunction.of((T next) -> this.loadedIdToDefinition((NId)next)).redescribe((Supplier)NElementDescribables.ofDesc("Id->Definition"))).notNull().build();
    }

    protected <T> NStream<T> buildCollectionResult(NIterator<T> o) {
        return new NStreamFromNIterator<T>(this.resolveFindIdBase(), o);
    }

    protected String resolveFindIdBase() {
        return this.ids.isEmpty() ? null : (this.ids.get(0) == null ? null : this.ids.get(0).toString());
    }

    public NStream<String> getResultStatuses() {
        return this.postProcessResult(NIteratorBuilder.of(this.getResultDefinitionIteratorBase()).map(NFunction.of((T x) -> NIdFormatHelper.of(x).buildLong().getStatusString()).redescribe((Supplier)NElementDescribables.ofDesc("getStatusString"))).notBlank());
    }

    protected abstract NIterator<NId> getResultIdIteratorBase(Boolean var1);

    protected NStream<NId> getResultIdsBase(boolean sort) {
        return this.buildCollectionResult(this.getResultIdIteratorBase(null));
    }

    protected <T> NStream<T> postProcessResult(NIteratorBuilder<T> a) {
        if (this.isSorted()) {
            a = a.sort(null, this.isDistinct());
        }
        return this.buildCollectionResult(a.build());
    }

    protected NSession getSearchSession() {
        NSession session = NSession.of();
        return session;
    }

    protected NIterator<NId> applyPrintDecoratorIterOfNutsId(NIterator<NId> curr, boolean print) {
        return print ? NWorkspaceUtils.of().decoratePrint(curr, this.getDisplayOptions()) : curr;
    }

    private static /* synthetic */ NDescriptor lambda$loadedIdToDefinition$46(DefaultNDefinitionBuilder2 db, NEnvCondition condition) {
        NDescriptor oldDesc = db.getEffectiveDescriptor().get();
        NDescriptor newdesc = oldDesc.builder().setCondition(oldDesc.getCondition().builder().and(condition).build()).build();
        return newdesc;
    }

    private static /* synthetic */ NDescriptor lambda$loadedIdToDefinition$45(DefaultNDefinitionBuilder2 db, NEnvCondition condition) {
        NDescriptor oldDesc = db.getDescriptor().get();
        NDescriptor newdesc = oldDesc.builder().setCondition(oldDesc.getCondition().builder().and(condition).build()).build();
        return newdesc;
    }
}

