/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.push;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NPushCmd;
import net.thevpc.nuts.command.NPushException;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.push.AbstractDefaultNPushCmd;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNPushCmd
extends AbstractDefaultNPushCmd {
    public DefaultNPushCmd(NWorkspace workspace) {
        super(workspace);
    }

    @Override
    public NPushCmd run() {
        NRepositoryFilter repositoryFilter = null;
        LinkedHashMap<NId, NDefinition> toProcess = new LinkedHashMap<NId, NDefinition>();
        for (NId id : this.getIds()) {
            if (NStringUtils.trim(id.getVersion().getValue()).endsWith("-CHECKED-OUT")) {
                throw new NIllegalArgumentException(NMsg.ofC("invalid version %s", id.getVersion()));
            }
            NDefinition file = NFetchCmd.of(id).setDependencyFilter(NDependencyFilters.of().byRunnable()).setTransitive(false).getResultDefinition();
            NAssert.requireNonNull(file, "content to push");
            toProcess.put(id, file);
        }
        NWorkspaceExt dws = NWorkspaceExt.of();
        NAssert.requireNonBlank(toProcess, "package tp push");
        for (Map.Entry entry : toProcess.entrySet()) {
            NId id = (NId)entry.getKey();
            NDefinition file = (NDefinition)entry.getValue();
            NFetchMode fetchMode = this.isOffline() ? NFetchMode.LOCAL : NFetchMode.REMOTE;
            NWorkspaceUtils wu = NWorkspaceUtils.of();
            if (NBlankable.isBlank(this.getRepository())) {
                LinkedHashSet<String> errors = new LinkedHashSet<String>();
                boolean ok = false;
                for (NRepository repo : wu.filterRepositoriesDeploy(file.getId(), repositoryFilter)) {
                    NDescriptor descr = null;
                    NRepositorySPI repoSPI = wu.toRepositorySPI(repo);
                    try {
                        descr = repoSPI.fetchDescriptor().setFetchMode(fetchMode).setId(file.getId()).getResult();
                    }
                    catch (Exception e) {
                        errors.add(CoreStringUtils.exceptionToString(e));
                    }
                    if (descr == null || !repo.config().isSupportedMirroring()) continue;
                    NId id2 = CoreNIdUtils.createContentFaceId(dws.resolveEffectiveId(descr), descr);
                    try {
                        repoSPI.push().setId(id2).setOffline(this.offline).setRepository(this.getRepository()).setArgs(this.args.toArray(new String[0])).run();
                        ok = true;
                        break;
                    }
                    catch (Exception e) {
                        errors.add(CoreStringUtils.exceptionToString(e));
                    }
                }
                if (ok) continue;
                throw new NPushException(id, NMsg.ofC("unable to push %s to repository %s : %s", id == null ? "<null>" : id, this.getRepository(), String.join((CharSequence)"\n", errors)));
            }
            NRepository repo = NWorkspace.of().findRepository(this.getRepository()).get();
            if (!repo.config().isEnabled()) {
                throw new NIllegalArgumentException(NMsg.ofC("repository %s is disabled", repo.getName()));
            }
            NId effId = CoreNIdUtils.createContentFaceId(id.builder().setPropertiesQuery("").build(), file.getDescriptor());
            NRepositorySPI repoSPI = wu.toRepositorySPI(repo);
            repoSPI.deploy().setId(effId).setContent(file.getContent().orNull()).setDescriptor(file.getDescriptor()).run();
        }
        return this;
    }
}

