/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.prepare;

import java.util.HashSet;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NPrepareCmd;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.prepare.AbstractNPrepareCmd;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultNPrepareCmd
extends AbstractNPrepareCmd {
    public DefaultNPrepareCmd(NWorkspace workspace) {
        super(workspace);
    }

    private boolean isLocalhost() {
        String remoteServer = this.getTargetServer();
        return NBlankable.isBlank(remoteServer) || "localhost".equalsIgnoreCase(remoteServer) || remoteServer.startsWith("127.0.0.");
    }

    @Override
    public NPrepareCmd run() {
        NPath javaPath;
        String version = this.getVersion();
        this.getValidUser();
        NWorkspace workspace = NWorkspace.of();
        String currentVersion = workspace.getApiVersion().toString();
        if (version == null) {
            version = currentVersion;
        }
        this.mkdirs(this.remoteHomeFile("bin"));
        NId apiId = workspace.getApiId();
        if (NBlankable.isBlank(version)) {
            apiId = apiId.builder().setVersion(version).build();
        }
        if ((javaPath = this.remoteJavaCommand(apiId.getVersion())) == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("missing java"));
        }
        this.pushId(apiId, null);
        HashSet<NId> deps = new HashSet<NId>();
        deps.add(workspace.getRuntimeId());
        deps.addAll(NSearchCmd.of().addId("net.thevpc.nsh:nsh").setLatest(true).setTargetApiVersion(apiId.getVersion()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setBasePackage(true).getResultIds().toList());
        if (this.ids != null) {
            for (NId id : deps) {
                deps.addAll(NSearchCmd.of().addId(id).setLatest(true).setTargetApiVersion(apiId.getVersion()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setBasePackage(true).getResultIds().toList());
            }
        }
        for (NId dep : deps) {
            this.pushId(dep, apiId.getVersion());
        }
        this.runRemoteAsString(javaPath.toString(), "-jar", this.remoteIdMavenJar(apiId));
        return this;
    }

    private void pushId(NId pid, NVersion apiIdVersion) {
        NDefinition def = NSearchCmd.of().addId(pid).setLatest(true).setTargetApiVersion(apiIdVersion).getResultDefinitions().findFirst().get();
        NPath apiJar = def.getContent().get();
        if (!this.runRemoteAsStringNoFail("ls " + this.remoteIdMavenJar(def.getApiId()))) {
            if (!this.isLocalhost()) {
                String targetServer = this.getTargetServer();
                NExecCmd.of().addCommand("scp").addCommand(apiJar.toString()).addCommand(this.getValidUser() + "@" + targetServer + ":" + this.remoteIdMavenJar(def.getApiId())).failFast().getGrabbedAllString();
            } else {
                NPath to = NPath.of(this.remoteIdMavenJar(def.getApiId()));
                to.getParent().mkdirs();
                apiJar.copyTo(to, new NPathOption[0]);
            }
        }
    }

    private String remoteIdMavenJar(NId apiId) {
        return this.remoteHomeFile(".m2/repository/" + String.join((CharSequence)"/", apiId.getGroupId().split("[.]"))) + "/" + apiId.getArtifactId() + "/" + apiId.getVersion() + "/" + apiId.getArtifactId() + "-" + apiId.getVersion() + ".jar";
    }

    private NPath remoteJavaCommand(NVersion apiVersion) {
        return NPath.of("java");
    }

    private NPath remoteNutsCommand() {
        if (this.version == null) {
            this.version = NWorkspace.of().getApiVersion().toString();
        }
        NPath e = this.remoteHomeFile("bin/nuts-" + this.version);
        if (this.runRemoteAsStringNoFail("ls " + e)) {
            return e;
        }
        if (this.runRemoteAsStringNoFail("ls /bin/nuts-" + this.version)) {
            return e;
        }
        return null;
    }

    private NPath remoteHomeFile(String path) {
        if (NBlankable.isBlank(this.targetHome)) {
            String user = this.getValidUser();
            return NPath.of("/home/" + user + "/" + path);
        }
        if (this.targetHome.startsWith("/")) {
            return NPath.of(this.targetHome + "/" + path);
        }
        String user = this.getValidUser();
        return NPath.of("/home/" + user + "/" + this.targetHome + "/" + path);
    }

    private String getValidUser() {
        String user = this.getUserName();
        if (NBlankable.isBlank(user)) {
            user = System.getProperty("user.name");
        }
        return user;
    }

    private boolean runRemoteAsStringNoFail(String ... cmd) {
        try {
            this.runRemoteAsString(cmd);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void mkdirs(NPath path) {
        if (!this.isLocalhost()) {
            this.runRemoteAsString("mkdir", "-p", path.toString());
        } else {
            path.mkdirs();
        }
    }

    private String runRemoteAsString(String ... cmd) {
        String remoteUser = this.getValidUser();
        NExecCmd e = NExecCmd.of();
        if (!this.isLocalhost()) {
            String targetServer = this.getTargetServer();
            e.addCommand("ssh", remoteUser + "@" + targetServer);
        }
        return e.addCommand(cmd).failFast().getGrabbedAllString();
    }
}

