/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.install;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallCache;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallFlags;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallIdCacheItem;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallIdInfo;

public class InstallIdList {
    boolean emptyCommand = true;
    Map<String, InstallIdInfo> visited = new LinkedHashMap<String, InstallIdInfo>();
    InstallCache cache = new InstallCache();

    public boolean isVisited(NId id) {
        return this.visited.containsKey(InstallIdCacheItem.normalizeId(id).toString());
    }

    public List<NId> ids(Predicate<InstallIdInfo> filter) {
        return this.infos().stream().filter(filter).map(x -> x.id).collect(Collectors.toList());
    }

    public List<InstallIdInfo> infos(Predicate<InstallIdInfo> filter) {
        if (filter == null) {
            return this.infos();
        }
        return this.infos().stream().filter(filter).collect(Collectors.toList());
    }

    public List<InstallIdInfo> infos() {
        return new ArrayList<InstallIdInfo>(this.visited.values());
    }

    public InstallIdInfo addAsDeployed(NId id, InstallFlags flags) {
        flags = flags.copy();
        this.cache.get(id);
        String sid = InstallIdCacheItem.normalizeId(id).toString();
        InstallIdInfo old = this.visited.get(sid);
        if (old != null) {
            old.flags.merge(flags);
            old.flags.deployOnly = true;
            return old;
        }
        InstallIdInfo ii = new InstallIdInfo();
        ii.id = id;
        ii.sid = sid;
        ii.flags = flags;
        ii.flags.deployOnly = true;
        this.visited.put(ii.sid, ii);
        return ii;
    }

    public InstallIdInfo addAsRequired(NId id, NId forId, InstallFlags flags) {
        flags = flags.copy();
        this.cache.get(id);
        String sid = InstallIdCacheItem.normalizeId(id).toString();
        InstallIdInfo old = this.visited.get(sid);
        if (old != null) {
            old.flags.merge(flags);
            old.flags.require = true;
            old.requiredForIds.add(forId);
            return old;
        }
        InstallIdInfo ii = new InstallIdInfo();
        ii.id = id;
        ii.sid = sid;
        ii.flags = flags;
        ii.flags.require = true;
        ii.requiredForIds = new ArrayList<NId>();
        ii.requiredForIds.add(forId);
        this.visited.put(ii.sid, ii);
        return ii;
    }

    public InstallIdInfo addAsInstalled(NId id, InstallFlags flags) {
        flags = flags.copy();
        String sid = InstallIdCacheItem.normalizeId(id).toString();
        InstallIdInfo old = this.visited.get(sid);
        if (old != null) {
            old.flags.merge(flags);
            old.flags.install = true;
            return old;
        }
        this.cache.get(id);
        this.emptyCommand = false;
        InstallIdInfo ii = new InstallIdInfo();
        ii.id = id;
        ii.sid = sid;
        ii.flags = flags;
        ii.flags.install = true;
        this.visited.put(ii.sid, ii);
        return ii;
    }

    public InstallIdInfo addAsUninstalled(NId id, InstallFlags flags) {
        flags = flags.copy();
        String sid = InstallIdCacheItem.normalizeId(id).toString();
        InstallIdInfo old = this.visited.get(sid);
        if (old != null) {
            old.flags.merge(flags);
            return old;
        }
        this.cache.get(id);
        this.emptyCommand = false;
        InstallIdInfo ii = new InstallIdInfo();
        ii.id = id;
        ii.sid = sid;
        ii.flags = flags;
        this.visited.put(ii.sid, ii);
        return ii;
    }

    public InstallIdInfo get(NId id) {
        return this.visited.get(InstallIdCacheItem.normalizeId(id).toString());
    }
}

