/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.install;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NInstallCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NWorkspaceCmdBase;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.InstallFlags;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NScorableContext;

public abstract class AbstractNInstallCmd
extends NWorkspaceCmdBase<NInstallCmd>
implements NInstallCmd {
    protected boolean defaultVersion = true;
    protected InstallFlags companionsInstallFlags;
    protected InstallFlags installedInstallFlags;
    protected InstallFlags currentInstallFlags = new InstallFlags();
    protected List<String> args;
    protected List<ConditionalArguments> conditionalArguments = new ArrayList<ConditionalArguments>();
    protected final Map<NId, InstallFlags> ids = new LinkedHashMap<NId, InstallFlags>();
    protected NDefinition[] result;
    protected NId[] failed;

    public AbstractNInstallCmd(NWorkspace workspace) {
        super("install");
    }

    public boolean isForce() {
        return this.currentInstallFlags.force;
    }

    public NInstallCmd setForce(boolean force) {
        this.currentInstallFlags.force = force;
        return this;
    }

    public boolean isSwitchVersion() {
        return this.currentInstallFlags.switchVersion;
    }

    public NInstallCmd setSwitchVersion(boolean switchVersion) {
        this.currentInstallFlags.switchVersion = switchVersion;
        return this;
    }

    public boolean isRepair() {
        return this.currentInstallFlags.repair;
    }

    public NInstallCmd setRepair(boolean repair) {
        this.currentInstallFlags.repair = repair;
        return this;
    }

    public boolean isDeployOnly() {
        return this.currentInstallFlags.deployOnly;
    }

    public NInstallCmd setDeployOnly(boolean deployOnly) {
        this.currentInstallFlags.deployOnly = deployOnly;
        return this;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NInstallCmd addId(String id) {
        return this.addId(id == null ? null : NId.get(id).get());
    }

    @Override
    public NInstallCmd setId(NId id) {
        return this.clearIds().addId(id);
    }

    @Override
    public NInstallCmd setId(String id) {
        return this.clearIds().addId(id);
    }

    @Override
    public NInstallCmd setIds(NId ... ids) {
        return this.clearIds().addIds(ids);
    }

    @Override
    public NInstallCmd setIds(String ... ids) {
        return this.clearIds().addIds(ids);
    }

    @Override
    public NInstallCmd addId(NId id) {
        if (id == null) {
            throw new NArtifactNotFoundException(id);
        }
        this.ids.put(id, this.currentInstallFlags.copy());
        return this;
    }

    @Override
    public NInstallCmd addIds(String ... ids) {
        for (String id : ids) {
            this.addId(id);
        }
        return this;
    }

    @Override
    public NInstallCmd addIds(NId ... ids) {
        for (NId id : ids) {
            this.addId(id);
        }
        return this;
    }

    @Override
    public NInstallCmd removeId(NId id) {
        if (id != null) {
            this.ids.remove(id);
        }
        return this;
    }

    @Override
    public NInstallCmd removeId(String id) {
        if (id != null) {
            this.ids.remove(NId.get(id).get());
        }
        return this;
    }

    @Override
    public NInstallCmd clearIds() {
        this.ids.clear();
        return this;
    }

    @Override
    public NInstallCmd clearArgs() {
        this.args = null;
        return this;
    }

    @Override
    public List<String> getArgs() {
        return NCollections.unmodifiableList(this.args);
    }

    @Override
    public NInstallCmd addArg(String arg) {
        if (arg != null) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            this.args.add(arg);
        }
        return this;
    }

    @Override
    public NInstallCmd addArgs(String ... args) {
        return this.addArgs(args == null ? null : Arrays.asList(args));
    }

    @Override
    public NInstallCmd addConditionalArgs(Predicate<NDefinition> definition, String ... args) {
        this.conditionalArguments.add(new ConditionalArguments(definition, Arrays.asList(args)));
        return this;
    }

    @Override
    public NInstallCmd addArgs(Collection<String> args) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (args != null) {
            for (String arg : args) {
                if (arg == null) continue;
                this.args.add(arg);
            }
        }
        return this;
    }

    @Override
    public List<NId> getIds() {
        return NCollections.unmodifiableList(this.ids == null ? null : this.ids.keySet());
    }

    @Override
    public boolean isCompanions() {
        return this.companionsInstallFlags != null;
    }

    @Override
    public NInstallCmd setCompanions(boolean value) {
        this.companionsInstallFlags = value ? this.currentInstallFlags.copy() : null;
        return this;
    }

    @Override
    public boolean isInstalled() {
        return this.installedInstallFlags != null;
    }

    @Override
    public NInstallCmd setInstalled(boolean value) {
        this.installedInstallFlags = value ? this.currentInstallFlags.copy() : null;
        return this;
    }

    @Override
    public boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    @Override
    public NInstallCmd setDefaultVersion(boolean defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }

    @Override
    public NInstallCmd defaultVersion(boolean defaultVersion) {
        return this.setDefaultVersion(defaultVersion);
    }

    @Override
    public NInstallCmd defaultVersion() {
        return this.defaultVersion(true);
    }

    @Override
    public NInstallCmd companions(boolean value) {
        return this.setCompanions(value);
    }

    @Override
    public NInstallCmd companions() {
        return this.companions(true);
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg aa = cmdLine.peek().get();
        if (aa == null) {
            return false;
        }
        boolean enabled = aa.isUncommented();
        switch (aa.key()) {
            case "-c": 
            case "--companions": {
                return cmdLine.matcher().matchFlag(v -> this.setCompanions(v.booleanValue())).anyMatch();
            }
            case "-i": 
            case "--installed": {
                return cmdLine.matcher().matchFlag(v -> this.setInstalled(v.booleanValue())).anyMatch();
            }
            case "--reinstall": {
                return cmdLine.matcher().matchFlag(a -> this.setForce(a.booleanValue())).anyMatch();
            }
            case "--deploy-only": {
                return cmdLine.matcher().matchFlag(a -> this.setDeployOnly(a.booleanValue())).anyMatch();
            }
            case "--repair": {
                return cmdLine.matcher().matchTrueFlag(a -> this.setRepair(a.booleanValue())).anyMatch();
            }
            case "-g": 
            case "--args": {
                return cmdLine.matcher().matchAny(a -> this.addArgs(cmdLine.nextAllAsStringArray())).anyMatch();
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (aa.isOption()) {
            return false;
        }
        cmdLine.skip();
        this.addId(aa.asString().get());
        return true;
    }

    public static class ConditionalArguments {
        Predicate<NDefinition> predicate;
        List<String> args = new ArrayList<String>();

        public ConditionalArguments(Predicate<NDefinition> predicate, List<String> args) {
            this.predicate = predicate;
            this.args = args;
        }

        public Predicate<NDefinition> getPredicate() {
            return this.predicate;
        }

        public List<String> getArgs() {
            return this.args;
        }
    }
}

