/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.help;

import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutableInformation;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.internal.DefaultInternalNExecutableCommand;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;

public class DefaultNHelpInternalExecutable
extends DefaultInternalNExecutableCommand {
    public DefaultNHelpInternalExecutable(String[] args, NExecCmd execCommand) {
        super("help", args, execCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() {
        NSession session = NSession.of();
        if (session.isDry()) {
            this.dryExecute();
            return 0;
        }
        ArrayList<String> helpFor = new ArrayList<String>();
        NCmdLine cmdLine = NCmdLine.of(this.args);
        boolean helpColors = false;
        block15: while (cmdLine.hasNext()) {
            NArg a = cmdLine.peek().get();
            if (a.isOption()) {
                switch (a.key()) {
                    case "--color": 
                    case "--ntf": {
                        NArg c = cmdLine.nextFlag().get();
                        if (!c.isUncommented()) continue block15;
                        helpColors = c.getBooleanValue().get();
                        break;
                    }
                    case "-h": 
                    case "--help": {
                        cmdLine.skip();
                        break;
                    }
                    default: {
                        session.configureLast(cmdLine);
                        break;
                    }
                }
                continue;
            }
            cmdLine.skip();
            helpFor.add(a.asString().get());
            helpFor.addAll(Arrays.asList(cmdLine.toStringArray()));
            cmdLine.skipAll();
        }
        if (helpColors) {
            NTexts txt = NTexts.of();
            NText n = txt.parser().parse(NPath.of("classpath:/net/thevpc/nuts/runtime/ntf-help.ntf", this.getClass().getClassLoader()));
            session.getTerminal().out().print(n == null ? NText.ofStyled("no help found for " + this.name, NTextStyle.error()) : n);
        }
        NPrintStream out = session.out();
        if (!helpColors && helpFor.isEmpty()) {
            out.println(NWorkspaceExt.of().getHelpText());
            out.flush();
        }
        for (String arg : helpFor) {
            NExecutableInformation w = null;
            if (arg.equals("help")) {
                out.println(NMsg.ofC("%s :", arg));
                this.showDefaultHelp();
                out.flush();
                continue;
            }
            try {
                try {
                    w = NExecCmd.of().addCommand(arg).which();
                }
                catch (Exception ex) {
                    this.LOG().log(NMsg.ofC("failed to execute : %s", arg).asFine(ex));
                }
                if (w != null) {
                    out.println(NMsg.ofC("%s :", arg));
                    out.println(w.getHelpText());
                    out.flush();
                    continue;
                }
                session.getTerminal().err().println(NMsg.ofC("%s : not found", arg));
            }
            finally {
                if (w == null) continue;
                w.close();
            }
        }
        return 0;
    }

    @Override
    public void close() {
    }
}

