/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorEffectiveConfig;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NIdType;
import net.thevpc.nuts.command.NExecutionEntry;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.core.NLocationKey;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NDigest;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNDefinitionBuilder2;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNInstallInfo;
import net.thevpc.nuts.runtime.standalone.dependency.NDependencyScopes;
import net.thevpc.nuts.runtime.standalone.dependency.util.NDependencyUtils;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.log.NLogUtils;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.store.NWorkspaceStore;
import net.thevpc.nuts.runtime.standalone.util.ValueSupplier;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NRepositoryAndFetchMode;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NRepositoryAndFetchModeTracker;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch.AbstractNFetchCmd;
import net.thevpc.nuts.spi.NDependencySolver;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NNameFormat;

public class DefaultNFetchCmd
extends AbstractNFetchCmd {
    @Override
    public NPath getResultContent() {
        try {
            NDefinition def = this.fetchDefinition(this.getId());
            if (def.getDescriptor().isNoContent()) {
                return null;
            }
            if (!def.getContent().isPresent()) {
                if (!this.isFailFast()) {
                    return null;
                }
                throw new NArtifactNotFoundException(this.getId(), NMsg.ofC("missing content for %s", this.getId()));
            }
            return def.getContent().get();
        }
        catch (NArtifactNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public NId getResultId() {
        try {
            NDefinition def = this.fetchDefinition(this.getId());
            return def.getId();
        }
        catch (NArtifactNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public String getResultContentHash() {
        try {
            Path f = (Path)this.getResultDefinition().getContent().flatMap(NPath::toPath).get();
            return NDigest.of().setSource(f).computeString();
        }
        catch (NArtifactNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public String getResultDescriptorHash() {
        try {
            return NDigest.of().setSource(this.getResultDescriptor()).computeString();
        }
        catch (NArtifactNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public NDefinition getResultDefinition() {
        try {
            return this.fetchDefinition(this.getId());
        }
        catch (NArtifactNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public NDescriptor getResultDescriptor() {
        try {
            NDefinition def = this.fetchDefinition(this.getId());
            return def.getDescriptor();
        }
        catch (NArtifactNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public NDescriptor getResultEffectiveDescriptor() {
        try {
            NDefinition def = this.fetchDefinition(this.getId());
            return def.getEffectiveDescriptor().get();
        }
        catch (NArtifactNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public NInstallInformation getResultInstallInformation() {
        NWorkspaceExt dws = NWorkspaceExt.of();
        NInstallInformation ii = dws.getInstalledRepository().getInstallInformation(this.getId());
        if (ii != null) {
            return ii;
        }
        return DefaultNInstallInfo.notInstalled(this.getId());
    }

    @Override
    public NPath getResultPath() {
        try {
            NDefinition def = this.fetchDefinition(this.getId());
            return def.getContent().orNull();
        }
        catch (NArtifactNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public NFetchCmd copy() {
        DefaultNFetchCmd b = new DefaultNFetchCmd();
        b.copyFrom(this);
        return b;
    }

    @Override
    public NFetchCmd run() {
        this.getResultDefinition();
        return this;
    }

    public NDefinition fetchDefinition(NId id) {
        long startTime = System.currentTimeMillis();
        NWorkspace workspace = NWorkspace.of();
        NSession session = workspace.currentSession();
        NWorkspaceUtils wu = NWorkspaceUtils.of(workspace);
        CoreNIdUtils.checkLongId(id);
        if (NDependencyScope.parse(id.toDependency().getScope()).orNull() == NDependencyScope.SYSTEM) {
            throw new NArtifactNotFoundException(id.getLongId());
        }
        NWorkspaceExt dws = NWorkspaceExt.of();
        NFetchStrategy nutsFetchModes = NWorkspaceHelper.validate(session.getFetchStrategy().orDefault());
        NRepositoryFilter repositoryFilter = this.getRepositoryFilter();
        if (!NBlankable.isBlank(id.getRepository())) {
            NRepositoryFilter repositoryFilter2 = NRepositoryFilters.of().byName(id.getRepository());
            repositoryFilter = repositoryFilter2.and(repositoryFilter);
        }
        NRepositoryAndFetchModeTracker descTracker = new NRepositoryAndFetchModeTracker(wu.filterRepositoryAndFetchModes(NRepositorySupportedAction.SEARCH, id, repositoryFilter, nutsFetchModes));
        DefaultNDefinitionBuilder2 foundDefinitionBuilder = null;
        ArrayList<Exception> reasons = new ArrayList<Exception>();
        NRepositoryAndFetchMode successfulDescriptorLocation = null;
        try {
            id = wu.configureFetchEnv(id);
            DefaultNDefinitionBuilder2 result = null;
            for (NRepositoryAndFetchMode location : descTracker.available()) {
                try {
                    result = this.fetchDescriptorAsDefinition(id, nutsFetchModes, location.getFetchMode(), location.getRepository());
                    successfulDescriptorLocation = location;
                    break;
                }
                catch (NArtifactNotFoundException exc) {
                    descTracker.addFailure(location);
                }
                catch (Exception ex) {
                    this._LOG().log(NMsg.ofC("unexpected error while fetching descriptor for %s", id).asError(ex));
                    if (this._LOG().isLoggable(Level.FINEST)) {
                        NLogUtils.traceMessage(this._LOG(), nutsFetchModes, id.getLongId(), NMsgIntent.FAIL, "fetch def", startTime);
                    }
                    descTracker.addFailure(location);
                }
            }
            if ((foundDefinitionBuilder = result) != null) {
                foundDefinitionBuilder.setEffectiveDescriptor(new NDefEffectiveDescriptorSupplier(foundDefinitionBuilder, id));
                foundDefinitionBuilder.setDependencies(new NDefDependenciesSupplier(id, foundDefinitionBuilder, this.getRepositoryFilter(), this.getDependencyFilter(), this.isIgnoreCurrentEnvironment()));
                foundDefinitionBuilder.setContent(new NDefContentSupplier(foundDefinitionBuilder, successfulDescriptorLocation, descTracker, reasons, wu, nutsFetchModes, id, startTime));
                foundDefinitionBuilder.setInstallInformation(new NDefInstallInformationSupplier(dws, id));
                foundDefinitionBuilder.setEffectiveFlags(new NDefNDescriptorFlagSetSupplier(id, foundDefinitionBuilder));
            }
        }
        catch (NArtifactNotFoundException ex) {
            reasons.add(ex);
            NLogUtils.traceMessage(this._LOG(), nutsFetchModes, id.getLongId(), NMsgIntent.FAIL, "fetch definition", startTime);
            throw ex;
        }
        catch (RuntimeException ex) {
            NLogUtils.traceMessage(this._LOG(), nutsFetchModes, id.getLongId(), NMsgIntent.FAIL, "[unexpected] fetch definition", startTime);
            throw ex;
        }
        if (foundDefinitionBuilder != null) {
            return foundDefinitionBuilder.build();
        }
        throw new NArtifactNotFoundException(id.getLongId());
    }

    protected DefaultNDefinitionBuilder2 fetchDescriptorAsDefinition(NId id, NFetchStrategy nutsFetchModes, NFetchMode mode, NRepository repo) {
        NWorkspaceExt dws = NWorkspaceExt.of();
        NWorkspace workspace = NWorkspace.of();
        NWorkspaceUtils wu = NWorkspaceUtils.of(workspace);
        NWorkspaceStore wstore = ((NWorkspaceExt)((Object)workspace)).store();
        NRepositorySPI repoSPI = wu.toRepositorySPI(repo);
        NDescriptor descriptor = repoSPI.fetchDescriptor().setId(id).setFetchMode(mode).getResult();
        if (descriptor != null) {
            Map<String, String> q;
            String classifier;
            NId nutsId = dws.resolveEffectiveId(descriptor);
            NIdBuilder newIdBuilder = nutsId.builder();
            if (NBlankable.isBlank(newIdBuilder.getRepository())) {
                newIdBuilder.setRepository(repo.getName());
            }
            if (!NBlankable.isBlank(classifier = id.getClassifier())) {
                newIdBuilder.setClassifier(classifier);
            }
            if (!NDependencyScopes.isDefaultScope((q = id.getProperties()).get("scope"))) {
                newIdBuilder.setProperty("scope", q.get("scope"));
            }
            if (!NDependencyUtils.isDefaultOptional(q.get("optional"))) {
                newIdBuilder.setProperty("optional", q.get("optional"));
            }
            NId newId = newIdBuilder.build();
            NId apiId0 = null;
            NId apiId = null;
            if (!this.getId().getShortName().equals("net.thevpc.nuts:nuts")) {
                apiId = null;
                for (NDependency dependency : descriptor.getDependencies()) {
                    if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts") || !NDependencyScopes.isCompileScope(dependency.getScope())) continue;
                    apiId0 = dependency.toId().getLongId();
                }
                if (apiId0 != null) {
                    if (this.getId().getShortName().equals("net.thevpc.nuts:nuts-runtime")) {
                        apiId = apiId0;
                    } else if (descriptor.getIdType() == NIdType.RUNTIME) {
                        apiId = apiId0;
                    } else if (descriptor.getIdType() == NIdType.EXTENSION) {
                        apiId = apiId0;
                    } else if (descriptor.getIdType() == NIdType.COMPANION) {
                        apiId = apiId0;
                    }
                }
            }
            DefaultNDefinitionBuilder2 result = new DefaultNDefinitionBuilder2().setId(new ValueSupplier<NId>(newId.getLongId())).setDependency(new ValueSupplier<NDependency>(id.toDependency())).setRepositoryUuid(new ValueSupplier<String>(repo.getUuid())).setRepositoryName(new ValueSupplier<String>(repo.getName())).setDescriptor(new ValueSupplier<NDescriptor>(descriptor)).setApiId(new ValueSupplier<NId>(apiId));
            return result;
        }
        throw new NArtifactNotFoundException(id, new NArtifactNotFoundException.NIdInvalidDependency[0], new NArtifactNotFoundException.NIdInvalidLocation[]{new NArtifactNotFoundException.NIdInvalidLocation(repo.getName(), null, id + " not found")}, null);
    }

    private class NDefEffectiveDescriptorSupplier
    implements Supplier<NDescriptor> {
        private final DefaultNDefinitionBuilder2 foundDefinitionBuilder;
        private final NId id;

        public NDefEffectiveDescriptorSupplier(DefaultNDefinitionBuilder2 foundDefinitionBuilder, NId id) {
            this.foundDefinitionBuilder = foundDefinitionBuilder;
            this.id = id;
        }

        @Override
        public NDescriptor get() {
            try {
                return NWorkspace.of().resolveEffectiveDescriptor(this.foundDefinitionBuilder.getDescriptor().get(), new NDescriptorEffectiveConfig().setIgnoreCurrentEnvironment(DefaultNFetchCmd.this.isIgnoreCurrentEnvironment()));
            }
            catch (NArtifactNotFoundException ex) {
                DefaultNFetchCmd.this._LOG().log(NMsg.ofC("artifact descriptor found, but one of its parents or dependencies is not: %s : missing %s", this.id, ex.getId()).withLevel(Level.WARNING).withIntent(NMsgIntent.ALERT));
                return null;
            }
        }
    }

    private class NDefDependenciesSupplier
    implements Supplier<NDependencies> {
        private final NId id;
        private final DefaultNDefinitionBuilder2 foundDefinitionBuilder;
        private final NDependencyFilter dependencyFilter;
        private final NRepositoryFilter repositoryFilter;
        private final boolean ignoreCurrentEnvironment;

        public NDefDependenciesSupplier(NId id, DefaultNDefinitionBuilder2 foundDefinitionBuilder, NRepositoryFilter repositoryFilter, NDependencyFilter dependencyFilter, boolean ignoreCurrentEnvironment) {
            this.id = id;
            this.foundDefinitionBuilder = foundDefinitionBuilder;
            this.dependencyFilter = dependencyFilter;
            this.repositoryFilter = repositoryFilter;
            this.ignoreCurrentEnvironment = ignoreCurrentEnvironment;
        }

        @Override
        public NDependencies get() {
            return NDependencySolver.of().setIgnoreCurrentEnvironment(this.ignoreCurrentEnvironment).setDependencyFilter(this.dependencyFilter).add(this.id.toDependency(), this.foundDefinitionBuilder.build()).setRepositoryFilter(this.repositoryFilter).solve();
        }
    }

    private class NDefContentSupplier
    implements Supplier<NPath> {
        private final DefaultNDefinitionBuilder2 foundDefinitionBuilder;
        private final NRepositoryAndFetchMode successfulDescriptorLocation;
        private final NRepositoryAndFetchModeTracker descTracker;
        private final List<Exception> reasons;
        private NRepositoryAndFetchMode successfulContentLocation;
        private final NWorkspaceUtils wu;
        private final NFetchStrategy nutsFetchModes;
        private final NId id;
        private final long startTime;

        public NDefContentSupplier(DefaultNDefinitionBuilder2 foundDefinitionBuilder, NRepositoryAndFetchMode successfulDescriptorLocation, NRepositoryAndFetchModeTracker descTracker, List<Exception> reasons, NWorkspaceUtils wu, NFetchStrategy nutsFetchModes, NId id, long startTime) {
            this.foundDefinitionBuilder = foundDefinitionBuilder;
            this.successfulDescriptorLocation = successfulDescriptorLocation;
            this.descTracker = descTracker;
            this.reasons = reasons;
            this.wu = wu;
            this.nutsFetchModes = nutsFetchModes;
            this.id = id;
            this.startTime = startTime;
        }

        @Override
        public NPath get() {
            NPath fetchedPath = null;
            if (!this.foundDefinitionBuilder.getDescriptor().get().isNoContent()) {
                boolean loadedFromInstallRepo = "<main>".equals(this.successfulDescriptorLocation.getRepository().getUuid());
                NId id1 = CoreNIdUtils.createContentFaceId(this.foundDefinitionBuilder.getId().get(), this.foundDefinitionBuilder.getDescriptor().get());
                boolean contentSuccessful = false;
                NRepositoryAndFetchModeTracker contentTracker = new NRepositoryAndFetchModeTracker(this.descTracker.available());
                fetchedPath = this.fetchContent(id1, this.successfulDescriptorLocation, this.reasons);
                boolean bl = contentSuccessful = fetchedPath != null;
                if (contentSuccessful) {
                    this.successfulContentLocation = this.successfulDescriptorLocation;
                } else {
                    contentTracker.addFailure(this.successfulDescriptorLocation);
                }
                if (!contentSuccessful && !loadedFromInstallRepo && this.successfulDescriptorLocation.getFetchMode() == NFetchMode.LOCAL) {
                    NRepositoryAndFetchMode finalSuccessfulDescriptorLocation = this.successfulDescriptorLocation;
                    NRepositoryAndFetchMode n = contentTracker.available().stream().filter(x -> x.getRepository().getUuid().equals(finalSuccessfulDescriptorLocation.getRepository().getUuid()) && x.getFetchMode() == NFetchMode.REMOTE).findFirst().orElse(null);
                    if (n != null) {
                        fetchedPath = this.fetchContent(id1, n, this.reasons);
                        boolean bl2 = contentSuccessful = fetchedPath != null;
                        if (contentSuccessful) {
                            this.successfulContentLocation = n;
                        } else {
                            contentTracker.addFailure(n);
                        }
                    }
                }
                if (!contentSuccessful) {
                    for (NRepositoryAndFetchMode repoAndMode : contentTracker.available()) {
                        fetchedPath = this.fetchContent(id1, repoAndMode, this.reasons);
                        boolean bl3 = contentSuccessful = fetchedPath != null;
                        if (contentSuccessful) {
                            this.successfulContentLocation = repoAndMode;
                            break;
                        }
                        contentTracker.addFailure(repoAndMode);
                    }
                }
                if (contentSuccessful && loadedFromInstallRepo && this.successfulContentLocation != this.successfulDescriptorLocation) {
                    NInstalledRepository installedRepository = NWorkspaceExt.of().getInstalledRepository();
                    NRepositorySPI installedRepositorySPI = this.wu.toRepositorySPI(installedRepository);
                    NPath finalFetchedPath = fetchedPath;
                    NSession.of().copy().setConfirm(NConfirmationMode.YES).runWith(() -> installedRepositorySPI.deploy().setId(this.foundDefinitionBuilder.getId().get()).setDescriptor(this.foundDefinitionBuilder.getDescriptor().get()).setContent(finalFetchedPath).run());
                }
                if (!contentSuccessful) {
                    NLogUtils.traceMessage(DefaultNFetchCmd.this._LOG(), this.nutsFetchModes, this.id.getLongId(), NMsgIntent.FAIL, "fetched descriptor but failed to fetch artifact binaries", this.startTime);
                }
            }
            return fetchedPath;
        }

        protected NPath fetchContent(NId id1, NRepositoryAndFetchMode repo, List<Exception> reasons) {
            NRepositorySPI repoSPI = NWorkspaceUtils.of().toRepositorySPI(repo.getRepository());
            try {
                NDescriptor baseDescriptor = this.foundDefinitionBuilder.getDescriptor().get();
                return repoSPI.fetchContent().setId(id1).setDescriptor(baseDescriptor).setFetchMode(repo.getFetchMode()).getResult();
            }
            catch (NArtifactNotFoundException ex) {
                reasons.add(ex);
                return null;
            }
        }
    }

    private static class NDefInstallInformationSupplier
    implements Supplier<NInstallInformation> {
        private final NWorkspaceExt dws;
        private final NId id;

        public NDefInstallInformationSupplier(NWorkspaceExt dws, NId id) {
            this.dws = dws;
            this.id = id;
        }

        @Override
        public NInstallInformation get() {
            NInstalledRepository installedRepository = this.dws.getInstalledRepository();
            NInstallInformation ii = installedRepository.getInstallInformation(this.id);
            if (ii != null) {
                return ii;
            }
            return DefaultNInstallInfo.notInstalled(this.id);
        }
    }

    private class NDefNDescriptorFlagSetSupplier
    implements Supplier<Set<NDescriptorFlag>> {
        private final NId id;
        private final DefaultNDefinitionBuilder2 foundDefinitionBuilder;

        public NDefNDescriptorFlagSetSupplier(NId id, DefaultNDefinitionBuilder2 foundDefinitionBuilder) {
            this.id = id;
            this.foundDefinitionBuilder = foundDefinitionBuilder;
        }

        private Set<NDescriptorFlag> loadCache() {
            Map map = null;
            try {
                map = ((NWorkspaceExt)((Object)NWorkspace.of())).store().loadLocationKey(NLocationKey.ofCacheFaced(this.id, null, "info.cache"), Map.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (map != null) {
                HashSet<NDescriptorFlag> nb = new HashSet<NDescriptorFlag>();
                for (Map.Entry e : map.entrySet()) {
                    String k;
                    NDescriptorFlag kk;
                    String v = (String)e.getValue();
                    if (!NLiteral.of(v).asBoolean().orElse(false).booleanValue() || (kk = NDescriptorFlag.parse(k = (String)e.getKey()).orNull()) == null) continue;
                    nb.add(kk);
                }
                return nb;
            }
            return null;
        }

        private void storeCache(Set<NDescriptorFlag> nb) {
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                map = new LinkedHashMap();
                for (NDescriptorFlag n : nb) {
                    map.put(NNameFormat.VAR_NAME.format(n.name()), "true");
                }
                ((NWorkspaceExt)((Object)NWorkspace.of())).store().saveLocationKey(NLocationKey.ofCacheFaced(this.id, null, "info.cache"), map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public Set<NDescriptorFlag> get() {
            Set<NDescriptorFlag> cc = this.loadCache();
            if (cc != null) {
                return cc;
            }
            NPath jar = this.foundDefinitionBuilder.getContent().get();
            HashSet<NDescriptorFlag> nb = new HashSet<NDescriptorFlag>();
            if (jar != null && jar.getName().toLowerCase().endsWith(".jar") && jar.isRegularFile()) {
                try {
                    List<NExecutionEntry> t = NExecutionEntry.parse(jar);
                    if (t.size() > 0) {
                        nb.add(NDescriptorFlag.EXEC);
                        if (t.get(0).isApp()) {
                            nb.add(NDescriptorFlag.NUTS_APP);
                        }
                    }
                }
                catch (Exception t) {
                    // empty catch block
                }
            }
            Set<NDescriptorFlag> flags = this.foundDefinitionBuilder.getDescriptor().get().getFlags();
            nb.addAll(flags);
            if (nb.contains(NDescriptorFlag.NUTS_APP) || nb.contains(NDescriptorFlag.PLATFORM_APP)) {
                nb.add(NDescriptorFlag.EXEC);
            }
            this.storeCache(nb);
            return nb;
        }
    }

    public static class ScopePlusOptionsCache {
        public NDependencyScope[] scopes;
        public Boolean optional;

        public int keyHashCode() {
            int s = 0;
            if (this.scopes != null) {
                Arrays.sort(this.scopes);
                for (NDependencyScope element : this.scopes) {
                    s = 31 * s + (element == null ? 0 : element.id().hashCode());
                }
            }
            return s * 31 + (this.optional == null ? 0 : this.optional.hashCode());
        }
    }
}

