/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.open;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutableType;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.executor.system.NSysExecUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNExecutableInformationExt;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultNOpenExecutable
extends AbstractNExecutableInformationExt {
    String[] cmd;
    String[] executorOptions;
    private boolean showCommand = false;
    private String[] effectiveOpenExecutable;

    public DefaultNOpenExecutable(String[] cmd, String[] executorOptions, NExecCmd execCommand) {
        super(cmd[0], NCmdLine.of(cmd).toString(), NExecutableType.SYSTEM, execCommand);
        this.cmd = cmd;
        this.executorOptions = executorOptions == null ? new String[]{} : executorOptions;
        NCmdLine cmdLine = NCmdLine.of(this.executorOptions);
        block11: while (cmdLine.hasNext()) {
            NArg aa = cmdLine.peek().get();
            switch (aa.key()) {
                case "--show-command": {
                    cmdLine.matcher().matchFlag(v -> {
                        this.showCommand = v.booleanValue();
                    }).anyMatch();
                    continue block11;
                }
            }
            cmdLine.skip();
        }
        switch (NWorkspace.of().getOsFamily()) {
            case LINUX: {
                Path execPath = NSysExecUtils.sysWhich("xdg-open");
                if (execPath != null) {
                    this.effectiveOpenExecutable = new String[]{execPath.toString()};
                    break;
                }
                execPath = NSysExecUtils.sysWhich("gnome-open");
                if (execPath != null) {
                    this.effectiveOpenExecutable = new String[]{execPath.toString()};
                    break;
                }
                execPath = NSysExecUtils.sysWhich("cygstart");
                if (execPath == null) break;
                this.effectiveOpenExecutable = new String[]{execPath.toString()};
                break;
            }
            case WINDOWS: {
                this.effectiveOpenExecutable = new String[]{"cmd", "/c", "start"};
                break;
            }
            case MACOS: {
                Path execPath = NSysExecUtils.sysWhich("open");
                if (execPath == null) break;
                this.effectiveOpenExecutable = new String[]{execPath.toString()};
                break;
            }
        }
    }

    @Override
    public NId getId() {
        return null;
    }

    private NExecCmd resolveExecHelper() {
        if (this.effectiveOpenExecutable == null) {
            throw new NIllegalArgumentException(NMsg.ofC("unable to resolve viewer for %s", this.cmd[0]));
        }
        NExecCmd cc = this.getExecCommand().copy();
        cc.system();
        ArrayList<String> ss = new ArrayList<String>(Arrays.asList(this.effectiveOpenExecutable));
        ss.addAll(Arrays.asList(this.cmd));
        cc.setCommand(ss);
        return cc;
    }

    @Override
    public int execute() {
        return this.resolveExecHelper().run().getResultCode();
    }

    @Override
    public NText getHelpText() {
        switch (NWorkspace.of().getOsFamily()) {
            case WINDOWS: {
                return NText.ofStyled("No help available. Try " + this.getName() + " /help", NTextStyle.error());
            }
        }
        return NText.ofStyled("No help available. Try 'man " + this.getName() + "' or '" + this.getName() + " --help'", NTextStyle.error());
    }

    public String toString() {
        if (this.effectiveOpenExecutable == null) {
            return "open --fail " + NCmdLine.of(this.cmd);
        }
        return "open --with " + this.effectiveOpenExecutable[0] + " " + NCmdLine.of(this.cmd);
    }
}

