/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.internal;

import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutableType;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.app.util.NAppUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNExecutableInformationExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.local.internal.NInternalCommand;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultInternalNExecutableCommand
extends AbstractNExecutableInformationExt {
    protected String[] args;
    protected NInternalCommand impl;

    public DefaultInternalNExecutableCommand(String name, String[] args, NExecCmd execCommand) {
        super(name, name, NExecutableType.INTERNAL, execCommand);
        this.args = args;
    }

    public DefaultInternalNExecutableCommand(NInternalCommand impl, String[] args, NExecCmd execCommand) {
        super(impl.getName(), impl.getName(), NExecutableType.INTERNAL, execCommand);
        this.args = args;
        this.impl = impl;
    }

    @Override
    public int execute() {
        if (this.impl == null) {
            throw new NIllegalArgumentException(NMsg.ofC("impl is null"));
        }
        return this.impl.execute(this.args, this.getExecCommand());
    }

    @Override
    public NId getId() {
        return null;
    }

    protected void showDefaultHelp() {
        NOut.println(this.getHelpText());
    }

    @Override
    public NText getHelpText() {
        NTexts txt = NTexts.of();
        NPath path = NPath.of("classpath://net/thevpc/nuts/runtime/command/" + this.name + ".ntf", this.getClass().getClassLoader());
        NText n = txt.parser().parse(path);
        if (n == null) {
            return super.getHelpText();
        }
        return txt.transform(n, new NTextTransformConfig().setProcessAll(true).setRootLevel(1).setImportClassLoader(this.getClass().getClassLoader()).setCurrentDir(path.getParent()));
    }

    public void dryExecute() {
        if (NAppUtils.processHelpOptions(this.args)) {
            NOut.println("[dry] ==show-help==");
            return;
        }
        NTexts text = NTexts.of();
        if (NOut.isPlain()) {
            NOut.println(NMsg.ofC("[dry] %s%n", text.ofBuilder().append((Object)"internal", NTextStyle.pale()).append(" ").append((Object)this.getName(), NTextStyle.primary5()).append(" ").append(NCmdLine.of(this.args))));
        } else {
            NOut.println(NMsg.ofC("[dry] %s", text.ofBuilder().append((Object)"internal", NTextStyle.pale()).append(" ").append((Object)this.getName(), NTextStyle.primary5()).append(" ").append(NCmdLine.of(this.args))));
        }
    }

    public String toString() {
        return this.getName() + " " + NCmdLine.of(this.args).toString();
    }
}

