/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import java.util.List;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NExecTargetInfo;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.spi.NExecTargetInfoRunner;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class NExecTargetInfoImpl
implements NExecTargetInfo {
    private NConnectionString target;
    private NOsFamily osFamily;
    private NShellFamily shellFamily;
    private NId osId;
    private NId shellId;
    private String userName;
    private String rootUserName;
    private String userHome;
    private NExecTargetInfoRunner commandRunner;

    public NExecTargetInfoImpl(NConnectionString target, NExecTargetInfoRunner commandRunner) {
        this.target = target;
        this.commandRunner = commandRunner;
    }

    @Override
    public NOsFamily getOsFamily() {
        this.tryUpdate();
        return this.osFamily;
    }

    @Override
    public NId getOsId() {
        this.tryUpdate();
        return this.osId;
    }

    @Override
    public NId getShellId() {
        this.tryUpdate();
        return this.shellId;
    }

    @Override
    public NShellFamily getShellFamily() {
        this.tryUpdate();
        return this.shellFamily;
    }

    @Override
    public String getUserName() {
        this.tryUpdate();
        return this.userName;
    }

    @Override
    public String getUserHome() {
        this.tryUpdate();
        return this.userHome;
    }

    public synchronized boolean tryUpdate() {
        if (this.osFamily == null) {
            this.update();
            return true;
        }
        return false;
    }

    private synchronized void update() {
        String luname;
        List<String> cols;
        String result;
        String cmd2;
        boolean ok = false;
        try {
            cmd2 = "sh -c 'echo -n \"$(uname -s)|$(uname -r)|$(whoami)|${HOME}|$SHELL|\"; v=$($SHELL --version 2>/dev/null | head -n1 || $SHELL -version 2>/dev/null | head -n1 || $SHELL version 2>/dev/null | head -n1 || echo unknown); echo \"$v\"'";
            result = this.runOnceSystemGrab(cmd2);
            if (!NBlankable.isBlank(result) && (cols = NStringUtils.split(result, "|", false, false)).size() >= 6) {
                luname = cols.get(0).toLowerCase();
                this.osId = NId.of(null, cols.get(0), cols.get(1));
                if (luname.startsWith("linux")) {
                    this.osFamily = NOsFamily.LINUX;
                } else if (luname.startsWith("darwin")) {
                    this.osFamily = NOsFamily.MACOS;
                } else if (luname.startsWith("sunos")) {
                    this.osFamily = NOsFamily.UNIX;
                } else if (luname.startsWith("freebsd") || luname.startsWith("openbsd") || luname.startsWith("netbsd")) {
                    this.osFamily = NOsFamily.UNIX;
                }
                this.userName = cols.get(2);
                this.userHome = cols.get(3);
                this.shellFamily = NShellFamily.parse(cols.get(4)).orElse(NShellFamily.SH);
                this.shellId = NId.of(null, NStringUtils.firstNonBlank(cols.get(4), this.shellFamily.id()), cols.get(5));
                this.rootUserName = "root";
                ok = true;
            }
        }
        catch (Exception cmd2) {
            // empty catch block
        }
        if (!ok) {
            try {
                cmd2 = "powershell -NoProfile -Command \"& {$os='Windows'; $osver=[System.Environment]::OSVersion.Version.ToString(); $user=$env:USERNAME; $homedir=$env:USERPROFILE; $shell=(Get-Command pwsh -ErrorAction SilentlyContinue).Name; $shellver=$PSVersionTable.PSVersion.ToString(); Write-Output ($os+'|'+$osver+'|'+$user+'|'+$homedir+'|'+$shell+'|'+$shellver)}\"";
                result = this.runOnceSystemGrab(cmd2);
                if (!NBlankable.isBlank(result) && (cols = NStringUtils.split(result, "|", true, false)).size() >= 6) {
                    luname = cols.get(0).toLowerCase();
                    this.osId = NId.of(null, cols.get(0), cols.get(1));
                    this.resolveWindowsOfFamilyFromOsId(luname);
                    this.userName = cols.get(2);
                    this.userHome = cols.get(3);
                    this.shellFamily = NShellFamily.parse(cols.get(4)).orElse(NShellFamily.WIN_POWER_SHELL);
                    this.shellId = NId.of(null, NStringUtils.firstNonBlank(cols.get(4), this.shellFamily.id()), cols.get(5));
                    this.resolveWindowAdminName();
                    ok = true;
                }
            }
            catch (Exception cmd3) {
                // empty catch block
            }
        }
        if (!ok) {
            try {
                cmd2 = "cmd /c \"echo Windows|%OS%|%USERNAME%|%USERPROFILE%|cmd|unknown\"";
                result = this.runOnceSystemGrab(cmd2);
                if (!NBlankable.isBlank(result) && (cols = NStringUtils.split(result, "|", false, false)).size() >= 6) {
                    luname = cols.get(0).toLowerCase();
                    this.osId = NId.of(null, cols.get(0), cols.get(1));
                    this.resolveWindowsOfFamilyFromOsId(luname);
                    this.userName = cols.get(2);
                    this.userHome = cols.get(3);
                    this.shellFamily = NShellFamily.parse(cols.get(4)).orElse(NShellFamily.WIN_CMD);
                    this.shellId = NId.of(null, NStringUtils.firstNonBlank(cols.get(4), this.shellFamily.id()), cols.get(5));
                    this.resolveWindowAdminName();
                    ok = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!ok) {
            this.osFamily = NOsFamily.UNKNOWN;
            this.osId = NId.BLANK;
            this.shellFamily = NShellFamily.UNKNOWN;
            this.shellId = NId.BLANK;
            this.userHome = null;
            this.userName = null;
            this.rootUserName = "root";
        }
    }

    private void resolveWindowsOfFamilyFromOsId(String luname) {
        if (luname.startsWith("linux")) {
            this.osFamily = NOsFamily.LINUX;
        } else if (luname.startsWith("darwin")) {
            this.osFamily = NOsFamily.MACOS;
        } else if (luname.startsWith("sunos")) {
            this.osFamily = NOsFamily.UNIX;
        } else if (!(luname.startsWith("freebsd") || luname.startsWith("openbsd") || luname.startsWith("netbsd"))) {
            this.osFamily = luname.contains("windows") ? NOsFamily.WINDOWS : NOsFamily.WINDOWS;
        }
    }

    private void resolveWindowAdminName() {
        switch (NStringUtils.trim(this.target.getUserName()).toLowerCase()) {
            case "adminitrateur": {
                this.rootUserName = "Administrateur";
                break;
            }
            case "administrador": {
                this.rootUserName = "Administrador";
                break;
            }
            case "administrat\u00f6r": {
                this.rootUserName = "Administrat\u00f6r";
                break;
            }
            case "j\u00e4rjestelm\u00e4nvalvoja": {
                this.rootUserName = "J\u00e4rjestelm\u00e4nvalvoja";
                break;
            }
            case "rendszergazda": {
                this.rootUserName = "Rendszergazda";
                break;
            }
            case "\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440": {
                this.rootUserName = "\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440";
                break;
            }
            default: {
                this.rootUserName = "Administrator";
            }
        }
    }

    public String runOnceSystemGrab(String cmd) {
        return this.commandRunner.run(cmd, this.target);
    }

    @Override
    public String getRootUserName() {
        this.tryUpdate();
        return this.rootUserName;
    }
}

