/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NExecTargetInfo;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.util.NStringUtils;

class LocalNExecTargetInfo
implements NExecTargetInfo {
    public static final LocalNExecTargetInfo INSTANCE = new LocalNExecTargetInfo();

    LocalNExecTargetInfo() {
    }

    @Override
    public NOsFamily getOsFamily() {
        return NWorkspace.of().getOsFamily();
    }

    @Override
    public NId getOsId() {
        return NWorkspace.of().getOs();
    }

    @Override
    public NId getShellId() {
        return NId.of(null, NStringUtils.firstNonBlank(NWorkspace.of().getShellFamily().id()));
    }

    @Override
    public NShellFamily getShellFamily() {
        return NWorkspace.of().getShellFamily();
    }

    @Override
    public String getUserName() {
        return System.getProperty("user.name");
    }

    @Override
    public String getRootUserName() {
        switch (this.getOsFamily()) {
            case WINDOWS: {
                switch (NStringUtils.trim(this.getUserName()).toLowerCase()) {
                    case "adminitrateur": {
                        return "Administrateur";
                    }
                    case "administrador": {
                        return "Administrador";
                    }
                    case "administrat\u00f6r": {
                        return "Administrat\u00f6r";
                    }
                    case "j\u00e4rjestelm\u00e4nvalvoja": {
                        return "J\u00e4rjestelm\u00e4nvalvoja";
                    }
                    case "rendszergazda": {
                        return "Rendszergazda";
                    }
                    case "\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440": {
                        return "\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440";
                    }
                }
                return "Administrateur";
            }
        }
        return "root";
    }

    @Override
    public String getUserHome() {
        return System.getProperty("user.home");
    }
}

