/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.spi.NExecTargetCommandContext;

public class DefaultNExecTargetCommandContext
implements NExecTargetCommandContext,
Closeable {
    private NConnectionString connectionString;
    private String[] command;
    private NExecInput xin;
    private NExecOutput xout;
    private NExecOutput xerr;
    private InHolder hin;
    private OutHolder hout;
    private OutHolder herr;
    private NExecCmd execCommand;
    private boolean rawCommand;

    public DefaultNExecTargetCommandContext(NConnectionString connectionString, String[] command, NExecInput in, NExecOutput out, NExecOutput err, NExecCmd execCommand) {
        NPath temp;
        ByteArrayOutputStream grabbed;
        this.connectionString = connectionString;
        this.command = command;
        this.xin = in;
        this.xout = out;
        this.xerr = err;
        this.execCommand = execCommand;
        this.rawCommand = execCommand.isRawCommand();
        NSession session = NSession.of();
        switch (in.getType()) {
            case NULL: {
                this.hin = new MyInHolder(NIO.ofNullRawInputStream(), false, null);
                break;
            }
            case PATH: {
                this.hin = new MyInHolder(in.getPath().getInputStream(), true, null);
                break;
            }
            case INHERIT: 
            case PIPE: {
                this.hin = new MyInHolder(session.in(), false, null);
                break;
            }
            case STREAM: {
                this.hin = new MyInHolder(in.getStream(), false, null);
            }
        }
        switch (out.getType()) {
            case NULL: {
                this.hout = new MyOutHolder(NIO.ofNullRawOutputStream(), false, null);
                break;
            }
            case PATH: {
                this.hout = new MyOutHolder(in.getPath().getOutputStream(), true, null);
                break;
            }
            case INHERIT: 
            case PIPE: {
                this.hout = new MyOutHolder(NOut.asOutputStream(), false, null);
                break;
            }
            case STREAM: {
                this.hout = new MyOutHolder(out.getStream(), false, null);
                break;
            }
            case GRAB_STREAM: {
                grabbed = new ByteArrayOutputStream();
                this.hout = new MyOutHolder(grabbed, false, () -> out.setResult(NInputSource.of(grabbed.toByteArray())));
                break;
            }
            case GRAB_FILE: {
                temp = NPath.ofTempFile();
                temp.setDeleteOnDispose(true);
                temp.setUserTemporary(true);
                this.hout = new MyOutHolder(temp.getOutputStream(), true, () -> out.setResult(temp));
                break;
            }
        }
        switch (err.getType()) {
            case NULL: {
                this.herr = new MyOutHolder(NIO.ofNullRawOutputStream(), false, null);
                break;
            }
            case PATH: {
                this.herr = new MyOutHolder(in.getPath().getOutputStream(), true, null);
                break;
            }
            case INHERIT: 
            case PIPE: {
                this.herr = new MyOutHolder(session.err().asOutputStream(), false, null);
                break;
            }
            case STREAM: {
                this.herr = new MyOutHolder(err.getStream(), false, null);
                break;
            }
            case GRAB_STREAM: {
                grabbed = new ByteArrayOutputStream();
                this.herr = new MyOutHolder(grabbed, false, () -> err.setResult(NInputSource.of(grabbed.toByteArray())));
                break;
            }
            case GRAB_FILE: {
                temp = NPath.ofTempFile();
                temp.setDeleteOnDispose(true);
                temp.setUserTemporary(true);
                this.herr = new MyOutHolder(temp.getOutputStream(), true, () -> err.setResult(temp));
                break;
            }
            case REDIRECT: {
                this.herr = new OutHolder(){

                    @Override
                    public OutputStream get() {
                        return DefaultNExecTargetCommandContext.this.hout.get();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        }
    }

    @Override
    public boolean isRawCommand() {
        return this.rawCommand;
    }

    @Override
    public InputStream in() {
        return this.hin.get();
    }

    @Override
    public OutputStream out() {
        return this.hout.get();
    }

    @Override
    public OutputStream err() {
        return this.herr.get();
    }

    @Override
    public NConnectionString getConnectionString() {
        return this.connectionString;
    }

    @Override
    public String[] getCommand() {
        return this.command;
    }

    @Override
    public void close() throws IOException {
        this.hin.close();
        this.hout.close();
        this.herr.close();
    }

    @Override
    public NExecCmd getExecCommand() {
        return this.execCommand;
    }

    private static interface OutHolder
    extends Closeable {
        public OutputStream get();

        @Override
        public void close();
    }

    private static class MyInHolder
    implements InHolder {
        private final InputStream in;
        private final boolean close;
        private final Runnable onClose;

        public MyInHolder(InputStream in, boolean close, Runnable onClose) {
            this.in = in;
            this.close = close;
            this.onClose = onClose;
        }

        @Override
        public InputStream get() {
            return this.in;
        }

        @Override
        public void close() {
            if (this.close) {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.onClose != null) {
                this.onClose.run();
            }
        }
    }

    private static interface InHolder
    extends Closeable {
        public InputStream get();

        @Override
        public void close();
    }

    private static class MyOutHolder
    implements OutHolder {
        private final OutputStream out;
        private final boolean close;
        private final Runnable onClose;

        public MyOutHolder(OutputStream out, boolean close, Runnable onClose) {
            this.out = out;
            this.close = close;
            this.onClose = onClose;
        }

        @Override
        public OutputStream get() {
            return this.out;
        }

        @Override
        public void close() {
            if (this.close) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.onClose != null) {
                this.onClose.run();
            }
        }
    }
}

