/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecTargetInfo;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NRedirectType;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.net.NConnectionStringBuilder;
import net.thevpc.nuts.runtime.standalone.executor.system.ProcessBuilder2;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NWorkspaceCmdBase;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.LocalNExecTargetInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.NExecTargetInfoImpl;
import net.thevpc.nuts.spi.NExecTargetInfoContext;
import net.thevpc.nuts.spi.NExecTargetInfoRunner;
import net.thevpc.nuts.spi.NExecTargetSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public abstract class AbstractNExecCmd
extends NWorkspaceCmdBase<NExecCmd>
implements NExecCmd {
    protected NDefinition commandDefinition;
    protected List<String> command;
    protected List<String> executorOptions;
    protected List<String> workspaceOptions;
    protected Map<String, String> env;
    protected NExecutionException resultException;
    protected boolean executed;
    protected NDuration executionTime;
    protected boolean multipleRuns;
    protected long multipleRunsMinTimeMs;
    protected long multipleRunsSafeTimeMs;
    protected int multipleRunsMaxCount;
    protected String multipleRunsCron;
    protected NPath directory;
    protected NExecOutput out = NExecOutput.ofInherit();
    protected NExecOutput err = NExecOutput.ofInherit();
    protected NExecInput in = NExecInput.ofInherit();
    protected NExecutionType executionType = NExecutionType.SPAWN;
    protected NRunAs runAs = NRunAs.CURRENT_USER;
    protected Boolean dry = null;
    protected boolean failFast;
    protected Boolean bot;
    private long sleepMillis = 1000L;
    private NConnectionString connectionString;
    private boolean rawCommand;

    public AbstractNExecCmd() {
        super("exec");
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public boolean isFailFast() {
        return this.failFast;
    }

    @Override
    public NExecCmd setBot(Boolean bot) {
        this.bot = bot;
        return this;
    }

    @Override
    public Boolean getBot() {
        return this.bot;
    }

    @Override
    public NExecCmd setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public NExecCmd failFast() {
        return this.setFailFast(true);
    }

    @Override
    public List<String> getCommand() {
        return NCollections.unmodifiableList(this.command);
    }

    @Override
    public NExecCmd setCommand(String ... command) {
        this.command = null;
        return this.addCommand(command);
    }

    @Override
    public NExecCmd setCommand(Collection<String> command) {
        this.command = null;
        return this.addCommand(command);
    }

    @Override
    public NExecCmd setCommandDefinition(NDefinition definition) {
        this.commandDefinition = definition;
        if (this.commandDefinition != null) {
            // empty if block
        }
        return this;
    }

    @Override
    public NDefinition getCommandDefinition() {
        return this.commandDefinition;
    }

    @Override
    public NExecCmd addCommand(NPath path) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        if (path != null) {
            this.command.add(path.toString());
        }
        return this;
    }

    @Override
    public NExecCmd addCommand(String ... command) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        if (command != null) {
            for (String s : command) {
                if (s == null) continue;
                this.command.add(s);
            }
        }
        return this;
    }

    @Override
    public NExecCmd addCommand(Collection<String> command) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        if (command != null) {
            for (String s : command) {
                if (s == null) continue;
                this.command.add(s);
            }
        }
        return this;
    }

    @Override
    public NExecCmd clearCommand() {
        this.command = null;
        return this;
    }

    @Override
    public NExecCmd addExecutorOption(String executorOption) {
        if (executorOption != null) {
            if (this.executorOptions == null) {
                this.executorOptions = new ArrayList<String>();
            }
            this.executorOptions.add(executorOption);
        }
        return this;
    }

    @Override
    public NExecCmd addExecutorOptions(String ... executorOptions) {
        if (executorOptions != null) {
            for (String executorOption : executorOptions) {
                this.addExecutorOption(executorOption);
            }
        }
        return this;
    }

    @Override
    public NExecCmd setExecutorOptions(Collection<String> executorOptions) {
        this.executorOptions = new ArrayList<String>();
        if (executorOptions != null) {
            for (String executorOption : executorOptions) {
                this.addExecutorOption(executorOption);
            }
        }
        return this;
    }

    @Override
    public NExecCmd addExecutorOptions(Collection<String> executorOptions) {
        if (executorOptions != null) {
            for (String executorOption : executorOptions) {
                this.addExecutorOption(executorOption);
            }
        }
        return this;
    }

    @Override
    public NExecCmd clearExecutorOptions() {
        this.executorOptions = null;
        return this;
    }

    @Override
    public List<String> getWorkspaceOptions() {
        return NCollections.unmodifiableList(this.workspaceOptions);
    }

    @Override
    public NExecCmd clearWorkspaceOptions(String workspaceOptions) {
        this.workspaceOptions = null;
        return this;
    }

    @Override
    public NExecCmd addWorkspaceOptions(NWorkspaceOptions workspaceOptions) {
        if (workspaceOptions != null) {
            this.addWorkspaceOptions(workspaceOptions.toCmdLine().toString());
        }
        return this;
    }

    @Override
    public NExecCmd addWorkspaceOptions(String workspaceOptions) {
        if (workspaceOptions != null) {
            if (this.workspaceOptions == null) {
                this.workspaceOptions = new ArrayList<String>();
            }
            this.workspaceOptions.add(workspaceOptions);
        }
        return this;
    }

    @Override
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Override
    public NExecCmd setEnv(Map<String, String> env) {
        this.clearEnv();
        this.addEnv(env);
        return this;
    }

    @Override
    public NExecCmd addEnv(Map<String, String> env) {
        if (env != null) {
            for (Map.Entry<String, String> entry : env.entrySet()) {
                this.setEnv(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public NExecCmd setEnv(String key, String value) {
        if (value == null) {
            if (this.env != null) {
                this.env.remove(key);
            }
        } else {
            if (this.env == null) {
                this.env = new LinkedHashMap<String, String>();
            }
            this.env.put(key, value);
        }
        return this;
    }

    @Override
    public NExecCmd clearEnv() {
        this.env = null;
        return this;
    }

    @Override
    public NPath getDirectory() {
        return this.directory;
    }

    @Override
    public NExecCmd setDirectory(NPath directory) {
        this.directory = directory;
        return this;
    }

    @Override
    public NExecInput getIn() {
        return this.in;
    }

    @Override
    public NExecCmd setIn(NExecInput in) {
        this.in = in == null ? NExecInput.ofInherit() : in;
        return this;
    }

    @Override
    public NExecOutput getOut() {
        return this.out;
    }

    @Override
    public NExecCmd setOut(NExecOutput out) {
        this.out = out == null ? NExecOutput.ofInherit() : out;
        return this;
    }

    @Override
    public NExecCmd grabOut() {
        this.out = NExecOutput.ofGrabMem();
        return this;
    }

    @Override
    public NExecCmd grabAll() {
        return this.grabOut().redirectErr();
    }

    @Override
    public NExecCmd grabOutOnly() {
        return this.grabOut().setErr(NExecOutput.ofNull());
    }

    @Override
    public NExecCmd grabErr() {
        this.setErr(NExecOutput.ofGrabMem());
        return this;
    }

    @Override
    public String getGrabbedAllString() {
        if (!this.executed) {
            this.grabAll();
        }
        return this.getGrabbedOutString();
    }

    @Override
    public String getGrabbedOutOnlyString() {
        if (!this.executed && this.out.getType() != NRedirectType.GRAB_STREAM) {
            this.grabOutOnly();
        }
        return this.getGrabbedOutString();
    }

    @Override
    public String getGrabbedOutString() {
        if (!this.executed) {
            if (this.out.getType() != NRedirectType.GRAB_STREAM) {
                this.grabOut();
            }
            this.run();
        }
        if (this.getOut() == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("no buffer was configured; should call grabOut"));
        }
        if (this.getOut().getResultSource().isNotPresent() && (this.getOut().getType() == NRedirectType.GRAB_FILE || this.getOut().getType() == NRedirectType.GRAB_STREAM) && this.getResultException().isPresent()) {
            throw this.getResultException().get();
        }
        return this.getOut().getResultString();
    }

    @Override
    public String getGrabbedErrString() {
        if (!this.executed) {
            if (this.err.getType() != NRedirectType.GRAB_STREAM) {
                this.grabErr();
            }
            this.run();
        }
        if (this.getErr() == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("no buffer was configured; should call grabErr"));
        }
        if (this.getErr().getType() == NRedirectType.REDIRECT) {
            return this.getGrabbedOutString();
        }
        if (this.getErr().getResultSource().isNotPresent() && (this.getErr().getType() == NRedirectType.GRAB_FILE || this.getErr().getType() == NRedirectType.GRAB_STREAM) && this.getResultException().isPresent()) {
            throw this.getResultException().get();
        }
        return this.getErr().getResultString();
    }

    @Override
    public NExecOutput getErr() {
        return this.err;
    }

    @Override
    public NExecCmd setErr(NExecOutput err) {
        this.err = err;
        return this;
    }

    @Override
    public NExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    public NExecCmd setExecutionType(NExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    @Override
    public NExecCmd system() {
        return this.setExecutionType(NExecutionType.SYSTEM);
    }

    @Override
    public NExecCmd embedded() {
        return this.setExecutionType(NExecutionType.EMBEDDED);
    }

    @Override
    public NExecCmd spawn() {
        return this.setExecutionType(NExecutionType.SPAWN);
    }

    @Override
    public NExecCmd open() {
        return this.setExecutionType(NExecutionType.OPEN);
    }

    @Override
    public NRunAs getRunAs() {
        return this.runAs;
    }

    @Override
    public NExecCmd sudo() {
        return this.setRunAs(NRunAs.SUDO);
    }

    @Override
    public NExecCmd root() {
        return this.setRunAs(NRunAs.ROOT);
    }

    @Override
    public NExecCmd currentUser() {
        return this.setRunAs(NRunAs.CURRENT_USER);
    }

    @Override
    public NExecCmd setRunAs(NRunAs runAs) {
        this.runAs = runAs == null ? NRunAs.currentUser() : runAs;
        return this;
    }

    @Override
    public Boolean getDry() {
        return this.dry;
    }

    @Override
    public NExecCmd setDry(Boolean dry) {
        this.dry = dry;
        return this;
    }

    @Override
    public NExecCmd copyFrom(NExecCmd other) {
        if (other == null) {
            return this;
        }
        super.copyFromWorkspaceCommandBase((NWorkspaceCmdBase)((Object)other));
        this.addCommand(other.getCommand());
        this.addEnv(other.getEnv());
        this.addExecutorOptions(other.getExecutorOptions());
        this.setDirectory(other.getDirectory());
        this.setIn(other.getIn());
        this.setOut(other.getOut());
        this.setErr(other.getErr());
        this.setFailFast(other.isFailFast());
        this.setExecutionType(other.getExecutionType());
        this.setRunAs(other.getRunAs());
        this.setConnectionString(other.getConnectionString());
        this.setDry(other.getDry());
        this.setBot(other.getBot());
        this.setRawCommand(other.isRawCommand());
        return this;
    }

    @Override
    public NExecCmd copy() {
        return NExecCmd.of().copyFrom(this);
    }

    @Override
    public int getResultCode() {
        if (!this.executed) {
            this.run();
        }
        if (this.resultException != null && this.resultException.getExitCode() != 0 && this.failFast) {
            throw this.resultException;
        }
        return this.resultException == null ? 0 : this.resultException.getExitCode();
    }

    @Override
    public List<String> getExecutorOptions() {
        return NCollections.unmodifiableList(this.executorOptions);
    }

    @Override
    public NOptional<NExecutionException> getResultException() {
        if (!this.executed) {
            this.run();
        }
        return NOptional.ofNamed(this.resultException, "result-exception");
    }

    @Override
    public long getSleepMillis() {
        return this.sleepMillis;
    }

    @Override
    public NExecCmd setSleepMillis(long sleepMillis) {
        this.sleepMillis = sleepMillis;
        return this;
    }

    protected String getExtraErrorMessage() {
        if (this.getErr().getType() == NRedirectType.REDIRECT) {
            if ((this.getOut().getType() == NRedirectType.GRAB_FILE || this.getOut().getType() == NRedirectType.GRAB_STREAM) && this.getOut() != null && this.getOut().getResultSource().isPresent()) {
                return this.getGrabbedOutString();
            }
        } else {
            if ((this.getErr().getType() == NRedirectType.GRAB_FILE || this.getErr().getType() == NRedirectType.GRAB_STREAM) && this.getErr() != null && this.getErr().getResultSource().isPresent()) {
                return this.getGrabbedErrString();
            }
            if ((this.getOut().getType() == NRedirectType.GRAB_FILE || this.getOut().getType() == NRedirectType.GRAB_STREAM) && this.getOut() != null && this.getOut().getResultSource().isPresent()) {
                return this.getGrabbedOutString();
            }
        }
        return null;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().orNull();
        if (a == null) {
            return false;
        }
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        if (!this.command.isEmpty()) {
            cmdLine.next();
            this.command.add(a.asString().get());
            return true;
        }
        boolean enabled = a.isUncommented();
        switch (a.key()) {
            case "--external": 
            case "--spawn": 
            case "-x": {
                cmdLine.skip();
                if (enabled) {
                    this.setExecutionType(NExecutionType.SPAWN);
                }
                return true;
            }
            case "--embedded": 
            case "-b": {
                cmdLine.skip();
                if (enabled) {
                    this.setExecutionType(NExecutionType.EMBEDDED);
                }
                return true;
            }
            case "--open-file": {
                cmdLine.skip();
                if (enabled) {
                    this.setExecutionType(NExecutionType.OPEN);
                }
                return true;
            }
            case "--user-cmd": 
            case "--system": {
                cmdLine.skip();
                if (enabled) {
                    this.system();
                }
                return true;
            }
            case "--current-user": {
                cmdLine.skip();
                if (enabled) {
                    this.setRunAs(NRunAs.currentUser());
                }
                return true;
            }
            case "--as-root": {
                cmdLine.skip();
                if (enabled) {
                    this.setRunAs(NRunAs.ROOT);
                }
                return true;
            }
            case "--run-as": {
                NArg s = cmdLine.nextEntry().get();
                if (enabled) {
                    this.setRunAs(NRunAs.user(s.getStringValue().ifBlankEmpty().get()));
                }
                return true;
            }
            case "--sudo": {
                cmdLine.skip();
                if (enabled) {
                    this.setRunAs(NRunAs.sudo());
                }
                return true;
            }
            case "--dry": 
            case "-d": {
                return cmdLine.matcher().matchFlag(v -> this.setDry(v.booleanValue())).anyMatch();
            }
            case "--target": {
                return cmdLine.matcher().matchEntry(v -> this.setConnectionString(v.stringValue())).anyMatch();
            }
            case "--rerun": {
                return cmdLine.matcher().matchFlag(v -> {
                    this.multipleRuns = v.booleanValue();
                }).anyMatch();
            }
            case "--rerun-min-time": {
                return cmdLine.matcher().matchEntry(v -> {
                    this.multipleRunsMinTimeMs = NLiteral.of(v).asLong().get();
                }).anyMatch();
            }
            case "--rerun-safe-time": {
                return cmdLine.matcher().matchEntry(v -> {
                    this.multipleRunsSafeTimeMs = NLiteral.of(v).asLong().get();
                }).anyMatch();
            }
            case "--rerun-max-count": {
                return cmdLine.matcher().matchEntry(v -> {
                    this.multipleRunsMaxCount = NLiteral.of(v).asInt().get();
                }).anyMatch();
            }
            case "--cron": {
                return cmdLine.matcher().matchEntry(v -> {
                    this.multipleRunsCron = v.stringValue();
                }).anyMatch();
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        cmdLine.skip();
        if (a.isOption()) {
            this.addExecutorOption(a.asString().get());
        } else {
            this.addCommand(a.asString().get());
            this.addCommand(cmdLine.toStringArray());
            cmdLine.skipAll();
        }
        return true;
    }

    public String getCommandString() {
        return this.getCommandString(null);
    }

    public String getCommandString(ProcessBuilder2.CommandStringFormat f) {
        NDefinition d;
        StringBuilder sb = new StringBuilder();
        if (this.env != null) {
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (k == null) {
                    k = "";
                }
                if (v == null) {
                    v = "";
                }
                if (f != null) {
                    String v2;
                    if (!f.acceptEnvName(k, v)) continue;
                    String k2 = f.replaceEnvName(k, v);
                    if (k2 != null) {
                        k = k2;
                    }
                    if ((v2 = f.replaceEnvValue(k, v)) != null) {
                        v = v2;
                    }
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(NStringUtils.formatStringLiteral(k)).append("=").append(NStringUtils.formatStringLiteral(v));
            }
        }
        if ((d = this.getCommandDefinition()) != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(NStringUtils.formatStringLiteral(d.getId().toString()));
        }
        for (int i = 0; i < this.command.size(); ++i) {
            String s = this.command.get(i);
            if (f != null) {
                if (!f.acceptArgument(i, s)) continue;
                String k2 = f.replaceArgument(i, s);
                if (k2 != null) {
                    s = k2;
                }
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(NStringUtils.formatStringLiteral(s));
        }
        switch (this.getOut().getType()) {
            case PATH: {
                if (Arrays.stream(this.getOut().getOptions()).anyMatch(x -> x == NPathOption.APPEND)) {
                    sb.append(" >> ");
                } else {
                    sb.append(" > ");
                }
                sb.append(this.getOut().getPath());
                break;
            }
            case NULL: {
                sb.append(" > /dev/null ");
            }
        }
        switch (this.getErr().getType()) {
            case PATH: {
                if (Arrays.stream(this.getOut().getOptions()).anyMatch(x -> x == NPathOption.APPEND)) {
                    sb.append(" 2>> ");
                } else {
                    sb.append(" 2> ");
                }
                sb.append(this.getOut().getPath());
                break;
            }
            case REDIRECT: {
                sb.append(" 2>&1 ");
                break;
            }
            case NULL: {
                sb.append(" 2> /dev/null ");
            }
        }
        switch (this.getIn().getType()) {
            case PATH: {
                sb.append(" < ");
                sb.append(this.getOut().getPath());
                break;
            }
            case NULL: {
                sb.append(" < /dev/null");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getCommandString();
    }

    @Override
    public NConnectionString getConnectionString() {
        return this.connectionString;
    }

    @Override
    public NExecCmd setConnectionString(String connectionString) {
        this.connectionString = NBlankable.isBlank(connectionString) ? null : NConnectionString.of(connectionString);
        return this;
    }

    @Override
    public NExecCmd at(String connectionString) {
        return this.setConnectionString(connectionString);
    }

    @Override
    public NExecCmd at(NConnectionString connectionString) {
        return this.setConnectionString(connectionString);
    }

    @Override
    public NExecCmd setConnectionString(NConnectionString connectionString) {
        this.connectionString = !NBlankable.isBlank(connectionString) ? connectionString : null;
        return this;
    }

    @Override
    public NExecCmd redirectErr() {
        return this.setErr(NExecOutput.ofRedirect());
    }

    @Override
    public boolean isRawCommand() {
        return this.rawCommand;
    }

    @Override
    public NExecCmd setRawCommand(boolean rawCommand) {
        this.rawCommand = rawCommand;
        return this;
    }

    @Override
    public NExecTargetInfo probeTarget() {
        if (NBlankable.isBlank(this.connectionString)) {
            return LocalNExecTargetInfo.INSTANCE;
        }
        NWorkspace ws = NWorkspace.of();
        NConnectionStringBuilder connectionStringBuilder = this.connectionString.builder().setPath(null);
        NConnectionString normalizedConnectionStringWithUse = this.connectionString.normalize();
        NConnectionString normalizedConnectionStringWithoutUse = connectionStringBuilder.setQueryParam("use", null).build();
        Map cache = ws.getOrComputeProperty(NExecCmd.class + "::osProbe", () -> new ConcurrentHashMap());
        NExecTargetInfo found = cache.computeIfAbsent(normalizedConnectionStringWithoutUse, kk -> {
            NExecTargetSPI u = NExtensions.of().createComponent(NExecTargetSPI.class, normalizedConnectionStringWithUse).orElseThrow(() -> new NIllegalArgumentException(NMsg.ofC("invalid execution target string : %s", normalizedConnectionStringWithUse)));
            return u.getTargetInfo(new MyNExecTargetInfoContext(this, normalizedConnectionStringWithUse));
        });
        return found;
    }

    private class MyNExecTargetInfoContext
    implements NExecTargetInfoContext {
        private final NConnectionString normalizedConnectionString;
        private final AbstractNExecCmd abstractNExecCmd;

        public MyNExecTargetInfoContext(AbstractNExecCmd abstractNExecCmd2, NConnectionString normalizedConnectionString) {
            this.abstractNExecCmd = abstractNExecCmd2;
            this.normalizedConnectionString = normalizedConnectionString;
        }

        @Override
        public NConnectionString getConnectionString() {
            return this.normalizedConnectionString;
        }

        @Override
        public NExecCmd getExecCommand() {
            return this.abstractNExecCmd;
        }

        @Override
        public NExecTargetInfo createDefaultTargetInfo(NExecTargetInfoRunner runner) {
            return new NExecTargetInfoImpl(this.normalizedConnectionString, runner);
        }
    }
}

