/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NDeployCmd;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryDisabledException;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NRepositoryNotFoundException;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NDigest;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.runtime.standalone.descriptor.parser.NDescriptorContentResolver;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.ZipOptions;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy.AbstractNDeployCmd;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy.CharacterizedDeployFile;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNDeployCmd
extends AbstractNDeployCmd {
    public DefaultNDeployCmd(NWorkspace workspace) {
    }

    private static CharacterizedDeployFile characterizeForDeploy(NInputSource contentFile, List<String> parseOptions) {
        CharacterizedDeployFile c;
        block16: {
            if (parseOptions == null) {
                parseOptions = new ArrayList<String>();
            }
            c = new CharacterizedDeployFile();
            try {
                Comparable<Path> ext;
                NInputSource p;
                c.setBaseFile(CoreIOUtils.toPathInputSource(contentFile, c.getTemps(), true));
                c.setContentStreamOrPath(contentFile);
                if (!Files.exists(c.getBaseFile(), new LinkOption[0])) {
                    throw new NIllegalArgumentException(NMsg.ofC("file does not exists %s", c.getBaseFile()));
                }
                if (c.getDescriptor() == null && (p = c.getContentStreamOrPath()) instanceof NPath) {
                    NPath pp = (NPath)p;
                    try {
                        c.setDescriptor(NDescriptorParser.of().parse(pp.resolve("nuts.json")).get());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Files.isDirectory(c.getBaseFile(), new LinkOption[0])) {
                    if (c.getDescriptor() == null) {
                        ext = c.getBaseFile().resolve("nuts.json");
                        if (Files.exists((Path)ext, new LinkOption[0])) {
                            c.setDescriptor(NDescriptorParser.of().parse((Path)ext).get());
                        } else {
                            c.setDescriptor(NDescriptorContentResolver.resolveNutsDescriptorFromFileContent(c.getBaseFile(), parseOptions));
                        }
                    }
                    if (c.getDescriptor() == null) break block16;
                    if ("zip".equals(c.getDescriptor().getPackaging())) {
                        Path zipFilePath = Paths.get(NPath.of(c.getBaseFile().toString() + ".zip").toAbsolute().toString(), new String[0]);
                        ZipUtils.zip(c.getBaseFile().toString(), new ZipOptions(), zipFilePath.toString());
                        c.setContentStreamOrPath(NPath.of(zipFilePath));
                        c.addTemp(zipFilePath);
                        break block16;
                    }
                    throw new NIllegalArgumentException(NMsg.ofPlain("invalid Nut Folder source. expected 'zip' ext in descriptor"));
                }
                if (Files.isRegularFile(c.getBaseFile(), new LinkOption[0])) {
                    if (c.getDescriptor() == null) {
                        ext = NPath.of(c.getBaseFile().toString() + "." + "nuts.json").toAbsolute();
                        if (ext.exists()) {
                            c.setDescriptor(NDescriptorParser.of().parse((NPath)ext).get());
                        } else {
                            c.setDescriptor(NDescriptorContentResolver.resolveNutsDescriptorFromFileContent(c.getBaseFile(), parseOptions));
                        }
                    }
                    break block16;
                }
                throw new NIllegalArgumentException(NMsg.ofC("path does not denote a valid file or folder %s", c.getContentStreamOrPath()));
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
        return c;
    }

    @Override
    public NDeployCmd run() {
        NSession session = NSession.of();
        if (this.getContent() != null || this.getDescriptor() != null || this.getSha1() != null || this.getDescSha1() != null) {
            this.runDeployFile();
        }
        if (!this.ids.isEmpty()) {
            for (NId nutsId : NSearchCmd.of().addIds(this.ids.toArray(new NId[0])).setLatest(true).setRepositoryFilter(NRepositoryFilters.of().bySelector(this.fromRepository)).getResultIds()) {
                NDefinition fetched = NFetchCmd.of(nutsId).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition();
                if (!fetched.getContent().isPresent()) continue;
                this.runDeployFile(fetched.getContent().get(), fetched.getDescriptor(), null);
            }
        }
        NAssert.requireNonBlank(this.result, "package to deploy");
        if (session.isTrace()) {
            switch (session.getOutputFormat().orDefault()) {
                case PLAIN: {
                    for (AbstractNDeployCmd.Result nid : this.result) {
                        NOut.resetLine().println(NMsg.ofC("%s deployed successfully as %s to %s", nid.source, nid.id, NText.ofStyled(nid.repository, NTextStyle.primary3())));
                    }
                    break;
                }
                default: {
                    NOut.println(this.result);
                }
            }
        }
        return this;
    }

    private NDeployCmd runDeployFile() {
        return this.runDeployFile(this.getContent(), this.getDescriptor(), this.getDescSha1());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NDeployCmd runDeployFile(NInputSource content, Object descriptor0, String descSHA1) {
        block30: {
            dws = NWorkspaceExt.of();
            wu = NWorkspaceUtils.of();
            wu.checkReadOnly();
            tempFile = null;
            contentSource = NInputSource.ofMultiRead(content);
            descriptor = this.buildDescriptor(descriptor0, descSHA1);
            characterizedFile = null;
            contentFile2 = null;
            try {
                block29: {
                    if (descriptor == null) {
                        characterizedFile = DefaultNDeployCmd.characterizeForDeploy(contentSource, this.getParseOptions());
                        NAssert.requireNonBlank(characterizedFile.getDescriptor(), "descriptor");
                        descriptor = characterizedFile.getDescriptor();
                    }
                    name = NWorkspace.of().getDefaultIdFilename(descriptor.getId().builder().setFaceDescriptor().build());
                    tempFile = NPath.ofTempFile(name).toPath().get();
                    NCp.of().from(contentSource.getInputStream()).to(tempFile).addOptions(new NPathOption[]{NPathOption.SAFE}).run();
                    contentFile0 = contentFile2 = tempFile;
                    repository = this.getTargetRepository();
                    wu.checkReadOnly();
                    contentFile = contentFile0;
                    tempFile2 = null;
                    try {
                        block32: {
                            block31: {
                                if (!Files.isDirectory(contentFile, new LinkOption[0])) break block31;
                                descFile = contentFile.resolve("nuts.json");
                                descriptor2 = Files.exists(descFile, new LinkOption[0]) != false ? NDescriptorParser.of().parse(descFile).get() : NDescriptorContentResolver.resolveNutsDescriptorFromFileContent(contentFile, this.getParseOptions());
                                if (descriptor == null) {
                                    descriptor = descriptor2;
                                } else if (descriptor2 != null && !descriptor2.equals(descriptor)) {
                                    NDescriptorFormat.of(descriptor).print(descFile);
                                }
                                if (descriptor != null) {
                                    if ("zip".equals(descriptor.getPackaging()) == false) throw new NIllegalArgumentException(NMsg.ofPlain("invalid nuts folder source; expected 'zip' ext in descriptor"));
                                    zipFilePath = Paths.get(NPath.of(contentFile.toString() + ".zip").toAbsolute().toString(), new String[0]);
                                    try {
                                        ZipUtils.zip(contentFile.toString(), new ZipOptions(), new String[]{zipFilePath.toString()});
                                    }
                                    catch (IOException ex) {
                                        throw new NIOException(ex);
                                    }
                                    tempFile2 = contentFile = zipFilePath;
                                }
                                break block32;
                            }
                            if (descriptor == null) {
                                descriptor = NDescriptorContentResolver.resolveNutsDescriptorFromFileContent(contentFile, this.getParseOptions());
                            }
                        }
                        if (descriptor == null) {
                            throw new NArtifactNotFoundException(null, NMsg.ofC("artifact not found at %s", new Object[]{contentFile}));
                        }
                        if (NStringUtils.trim((descriptor = descriptor.builder().setId(descriptor.getId().builder().setRepository(null).build()).build()).getId().getVersion().getValue()).endsWith("-CHECKED-OUT")) {
                            throw new NIllegalArgumentException(NMsg.ofC("invalid version %s", new Object[]{descriptor.getId().getVersion()}));
                        }
                        effId = dws.resolveEffectiveId(descriptor);
                        CorePlatformUtils.checkAcceptCondition(descriptor.getCondition(), false);
                        if (!NBlankable.isBlank(repository)) ** GOTO lbl-1000
                        descriptor2 = wu.filterRepositoriesDeploy(effId = CoreNIdUtils.createContentFaceId(effId.builder().setPropertiesQuery("").build(), descriptor), null).stream().filter((Predicate<NRepository>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$runDeployFile$0(net.thevpc.nuts.core.NRepository ), (Lnet/thevpc/nuts/core/NRepository;)Z)()).sorted(Comparator.comparingInt((ToIntFunction<NRepository>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$runDeployFile$1(net.thevpc.nuts.core.NRepository ), (Lnet/thevpc/nuts/core/NRepository;)I)())).collect(Collectors.toList()).iterator();
                        if (descriptor2.hasNext()) {
                            repo = (NRepository)descriptor2.next();
                            deployOrder = repo.config().getDeployWeight();
                            repoSPI = wu.toRepositorySPI(repo);
                            repoSPI.deploy().setId(effId).setContent(contentFile).setDescriptor(descriptor).run();
                            this.addResult(effId, repo.getName(), NText.of(content));
                            var21_24 = this;
                            if (tempFile2 == null) break block29;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var23_26) {
                        if (tempFile2 == null) throw var23_26;
                        try {
                            Files.delete(tempFile2);
                            throw var23_26;
                        }
                        catch (IOException ex) {
                            throw new NIOException(ex);
                        }
                    }
                    try {
                        Files.delete(tempFile2);
                    }
                    catch (IOException ex) {
                        throw new NIOException(ex);
                    }
                }
                if (characterizedFile != null) {
                    characterizedFile.close();
                }
                if (tempFile == null) return var21_24;
            }
            catch (Throwable var25_28) {
                if (characterizedFile != null) {
                    characterizedFile.close();
                }
                if (tempFile == null) throw var25_28;
                NIOUtils.delete(tempFile);
                throw var25_28;
            }
            NIOUtils.delete(tempFile);
            return var21_24;
lbl-1000:
            // 1 sources

            {
                repo = NWorkspace.of().findRepository(repository).get();
                if (!repo.isEnabled()) {
                    throw new NRepositoryDisabledException(repository);
                }
                effId = CoreNIdUtils.createContentFaceId(effId.builder().setPropertiesQuery("").build(), descriptor);
                repoSPI = wu.toRepositorySPI(repo);
                repoSPI.deploy().setId(effId).setContent(contentFile).setDescriptor(descriptor).run();
                this.addResult(effId, repo.getName(), NText.of(content));
                var19_21 = this;
                if (tempFile2 == null) break block30;
            }
            try {
                Files.delete(tempFile2);
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
        if (characterizedFile != null) {
            characterizedFile.close();
        }
        if (tempFile == null) return var19_21;
        NIOUtils.delete(tempFile);
        return var19_21;
lbl-1000:
        // 1 sources

        {
            throw new NRepositoryNotFoundException(repository);
        }
    }

    protected NDescriptor buildDescriptor(Object descriptor, String descSHA1) {
        if (descriptor == null) {
            return null;
        }
        NDescriptor mdescriptor = null;
        if (descriptor instanceof NDescriptor) {
            mdescriptor = (NDescriptor)descriptor;
            if (descSHA1 != null && !NDigest.of().sha1().setSource(mdescriptor).computeString().equalsIgnoreCase(descSHA1)) {
                throw new NIllegalArgumentException(NMsg.ofPlain("invalid content Hash"));
            }
            return mdescriptor;
        }
        InputStream inputStream = (InputStream)descriptor;
        NInputSource nutsStreamOrPath = NInputSource.of(inputStream);
        if (nutsStreamOrPath != null) {
            NInputSource d = NInputSource.ofMultiRead(nutsStreamOrPath);
            try {
                NDescriptor nDescriptor;
                block27: {
                    InputStream is;
                    if (descSHA1 != null) {
                        try {
                            is = d.getInputStream();
                            try {
                                if (!NDigest.of().sha1().setSource(is).computeString().equalsIgnoreCase(descSHA1)) {
                                    throw new NIllegalArgumentException(NMsg.ofPlain("invalid content Hash"));
                                }
                            }
                            finally {
                                if (is != null) {
                                    is.close();
                                }
                            }
                        }
                        catch (IOException ex) {
                            throw new NIOException(ex);
                        }
                    }
                    is = d.getInputStream();
                    try {
                        nDescriptor = NDescriptorParser.of().parse(is).get();
                        if (is == null) break block27;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new NIOException(ex);
                        }
                    }
                    is.close();
                }
                return nDescriptor;
            }
            finally {
                d.dispose();
            }
        }
        throw new NException(NMsg.ofC("unexpected type %s", descriptor.getClass().getName()));
    }

    @Override
    public NDeployCmd addIds(String ... values) {
        if (values != null) {
            for (String s : values) {
                if (NBlankable.isBlank(s)) continue;
                this.ids.add(NId.get(s).get());
            }
        }
        return this;
    }

    @Override
    public NDeployCmd addIds(NId ... value) {
        if (value != null) {
            for (NId s : value) {
                if (s == null) continue;
                this.ids.add(s);
            }
        }
        return this;
    }

    @Override
    public NDeployCmd clearIds() {
        this.ids.clear();
        return this;
    }

    @Override
    public NDeployCmd addId(NId id) {
        if (id != null) {
            this.addId(id.toString());
        }
        return this;
    }

    private static /* synthetic */ int lambda$runDeployFile$1(NRepository x) {
        return x.config().getDeployWeight();
    }

    private static /* synthetic */ boolean lambda$runDeployFile$0(NRepository x) {
        return x.config().getDeployWeight() > 0;
    }
}

