/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;

class CharacterizedDeployFile
implements AutoCloseable {
    private Path baseFile;
    private NInputSource contentStreamOrPath;
    private List<Path> temps = new ArrayList<Path>();
    private NDescriptor descriptor;

    public void addTemp(Path f) {
        this.temps.add(f);
    }

    public Path getBaseFile() {
        return this.baseFile;
    }

    public CharacterizedDeployFile setBaseFile(Path baseFile) {
        this.baseFile = baseFile;
        return this;
    }

    public NInputSource getContentStreamOrPath() {
        return this.contentStreamOrPath;
    }

    public CharacterizedDeployFile setContentStreamOrPath(NInputSource contentStreamOrPath) {
        this.contentStreamOrPath = contentStreamOrPath;
        return this;
    }

    public List<Path> getTemps() {
        return this.temps;
    }

    public CharacterizedDeployFile setTemps(List<Path> temps) {
        this.temps = temps;
        return this;
    }

    public NDescriptor getDescriptor() {
        return this.descriptor;
    }

    public CharacterizedDeployFile setDescriptor(NDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    @Override
    public void close() {
        Iterator<Path> it = this.temps.iterator();
        while (it.hasNext()) {
            Path temp = it.next();
            try {
                Files.delete(temp);
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
            it.remove();
        }
    }
}

