/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NDeployCmd;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NWorkspaceCmdBase;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;

public abstract class AbstractNDeployCmd
extends NWorkspaceCmdBase<NDeployCmd>
implements NDeployCmd {
    protected List<Result> result;
    protected NInputSource content;
    protected Object descriptor;
    protected String sha1;
    protected String descSha1;
    protected String fromRepository;
    protected String toRepository;
    protected List<String> parseOptions;
    protected final List<NId> ids = new ArrayList<NId>();

    public AbstractNDeployCmd() {
        super("deploy");
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    public List<String> getParseOptions() {
        return this.parseOptions;
    }

    public NDeployCmd setParseOptions(String[] parseOptions) {
        this.parseOptions = new ArrayList<String>(Arrays.asList(parseOptions));
        return this;
    }

    public NDeployCmd parseOptions(String[] parseOptions) {
        this.parseOptions = new ArrayList<String>(Arrays.asList(parseOptions));
        return this;
    }

    @Override
    public NDeployCmd setContent(InputStream stream) {
        this.content = stream == null ? null : NInputSource.of(stream);
        return this;
    }

    @Override
    public NDeployCmd setContent(NPath path) {
        this.content = path;
        return this;
    }

    @Override
    public NDeployCmd setContent(byte[] content) {
        this.content = content == null ? null : NInputSource.of(content);
        return this;
    }

    @Override
    public NDeployCmd setContent(File file) {
        this.content = file == null ? null : NPath.of(file);
        this.invalidateResult();
        return this;
    }

    @Override
    public NDeployCmd setContent(Path file) {
        this.content = file == null ? null : NPath.of(file);
        this.invalidateResult();
        return this;
    }

    @Override
    public NDeployCmd setDescriptor(InputStream stream) {
        this.descriptor = stream;
        this.invalidateResult();
        return this;
    }

    @Override
    public NDeployCmd setDescriptor(String path) {
        this.descriptor = path;
        this.invalidateResult();
        return this;
    }

    @Override
    public NDeployCmd setDescriptor(File file) {
        this.descriptor = file;
        this.invalidateResult();
        return this;
    }

    @Override
    public NDeployCmd setDescriptor(URL url) {
        this.descriptor = url;
        this.invalidateResult();
        return this;
    }

    @Override
    public String getSha1() {
        return this.sha1;
    }

    @Override
    public NDeployCmd setSha1(String sha1) {
        this.sha1 = sha1;
        this.invalidateResult();
        return this;
    }

    public String getDescSha1() {
        return this.descSha1;
    }

    @Override
    public NDeployCmd setDescSha1(String descSha1) {
        this.descSha1 = descSha1;
        this.invalidateResult();
        return this;
    }

    @Override
    public NInputSource getContent() {
        return this.content;
    }

    @Override
    public NDeployCmd setContent(NInputSource content) {
        this.content = content;
        return this;
    }

    @Override
    public NDeployCmd setContent(URL url) {
        this.content = url == null ? null : NPath.of(url);
        this.invalidateResult();
        return this;
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    @Override
    public NDeployCmd setDescriptor(NDescriptor descriptor) {
        this.descriptor = descriptor;
        this.invalidateResult();
        return this;
    }

    @Override
    public String getTargetRepository() {
        return this.toRepository;
    }

    @Override
    public NDeployCmd to(String repository) {
        return this.setTargetRepository(repository);
    }

    @Override
    public NDeployCmd setRepository(String repository) {
        return this.setTargetRepository(repository);
    }

    @Override
    public NDeployCmd setTargetRepository(String repository) {
        this.toRepository = repository;
        this.invalidateResult();
        return this;
    }

    @Override
    public NDeployCmd from(String repository) {
        return this.setSourceRepository(repository);
    }

    @Override
    public NDeployCmd setSourceRepository(String repository) {
        this.fromRepository = repository;
        this.invalidateResult();
        return this;
    }

    @Override
    public NDeployCmd setDescriptor(Path path) {
        this.descriptor = path;
        this.invalidateResult();
        return this;
    }

    @Override
    public List<NId> getResult() {
        if (this.result == null) {
            this.run();
        }
        return this.result.stream().map(x -> x.id).collect(Collectors.toList());
    }

    @Override
    protected void invalidateResult() {
        this.result = null;
    }

    protected void addResult(NId nid, String repository, NText source) {
        if (this.result == null) {
            this.result = new ArrayList<Result>();
        }
        this.result.add(new Result(nid, repository, source));
    }

    @Override
    public NDeployCmd addIds(String ... values) {
        if (values != null) {
            for (String s : values) {
                if (NBlankable.isBlank(s)) continue;
                this.ids.add(NId.get(s).get());
            }
        }
        return this;
    }

    @Override
    public NDeployCmd addIds(NId ... value) {
        if (value != null) {
            for (NId s : value) {
                if (s == null) continue;
                this.ids.add(s);
            }
        }
        return this;
    }

    @Override
    public NDeployCmd clearIds() {
        this.ids.clear();
        return this;
    }

    @Override
    public NDeployCmd addId(NId id) {
        if (id != null) {
            this.addId(id.toString());
        }
        return this;
    }

    @Override
    public NDeployCmd removeId(NId id) {
        if (id != null) {
            this.removeId(id.toString());
        }
        return this;
    }

    @Override
    public NDeployCmd removeId(String id) {
        this.ids.remove(NId.get(id).get());
        return this;
    }

    @Override
    public NDeployCmd addId(String id) {
        if (!NBlankable.isBlank(id)) {
            this.ids.add(NId.get(id).get());
        }
        return this;
    }

    @Override
    public List<NId> getIds() {
        return this.ids;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().get();
        if (a == null) {
            return false;
        }
        switch (a.key()) {
            case "-d": 
            case "--desc": {
                return cmdLine.matcher().matchEntry(v -> this.setDescriptor(v.stringValue())).anyMatch();
            }
            case "-s": 
            case "--source": 
            case "--from": {
                return cmdLine.matcher().matchEntry(v -> this.from(v.stringValue())).anyMatch();
            }
            case "-r": 
            case "--target": 
            case "--to": {
                return cmdLine.matcher().matchEntry(v -> this.to(v.stringValue())).anyMatch();
            }
            case "--desc-sha1": {
                return cmdLine.matcher().matchEntry(v -> this.setDescSha1(v.stringValue())).anyMatch();
            }
            case "--desc-sha1-file": {
                return cmdLine.matcher().matchEntry(v -> this.setDescSha1(NPath.of(v.stringValue()).readString())).anyMatch();
            }
            case "--sha1": {
                return cmdLine.matcher().matchEntry(v -> this.setSha1(v.stringValue())).anyMatch();
            }
            case "--sha1-file": {
                return cmdLine.matcher().matchEntry(v -> this.setSha1(NPath.of(v.stringValue()).readString())).anyMatch();
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (!a.isOption()) {
            cmdLine.skip();
            String idOrPath = a.asString().get();
            if (idOrPath.indexOf(47) >= 0 || idOrPath.indexOf(92) >= 0) {
                this.setContent(NPath.of(idOrPath));
            } else {
                this.addId(idOrPath);
            }
            return true;
        }
        cmdLine.throwUnexpectedArgument();
        return false;
    }

    protected static class Result {
        NText source;
        String repository;
        NId id;

        public Result(NId nid, String repository, NText source) {
            this.id = nid.getLongId();
            this.source = source;
            this.repository = repository;
        }
    }
}

