/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.bundle;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.util.NBlankable;

class ResultingIds {
    LinkedHashMap<NId, NDefinition> classPath = new LinkedHashMap();
    Set<NId> executableAppIds = new LinkedHashSet<NId>();
    Set<NId> baseIds = new LinkedHashSet<NId>();

    ResultingIds() {
    }

    private NId findNutsApiId() {
        for (NId resultId : this.classPath.keySet()) {
            if (!resultId.getShortName().equals("net.thevpc.nuts:nuts")) continue;
            return resultId;
        }
        return null;
    }

    NId findNutsAppId() {
        for (NId resultId : this.classPath.keySet()) {
            if (!resultId.getShortName().equals("net.thevpc.nuts:nuts-app")) continue;
            return resultId;
        }
        return null;
    }

    private NId findNutsRuntimeId() {
        for (NId resultId : this.classPath.keySet()) {
            if (!resultId.getShortName().equals("net.thevpc.nuts:nuts-runtime")) continue;
            return resultId;
        }
        return null;
    }

    public ResultingIds add(String ids) {
        if (!NBlankable.isBlank(ids)) {
            for (NId id : NId.ofList(ids)) {
                this.add(id);
            }
        }
        return this;
    }

    private ResultingIds addBomId(NId id) {
        if (!NBlankable.isBlank(id)) {
            if (this.classPath.containsKey(id.getLongId())) {
                return this;
            }
            NDefinition imdef = NFetchCmd.of(id).setDependencyFilter(NDependencyFilters.of().byRunnable(false, true)).getResultDefinition();
            if (!this.classPath.containsKey(imdef.getId().getLongId())) {
                NId resultId = imdef.getId();
                if ((imdef.getDescriptor().isPlatformApplication() || imdef.getDescriptor().isNutsApplication()) && this.isBaseId(resultId)) {
                    this.executableAppIds.add(resultId);
                }
                this.classPath.put(resultId.getLongId(), imdef);
            }
            for (NId parent : imdef.getDescriptor().getParents()) {
                this.add(parent);
            }
            for (NDependency standardDependency : imdef.getEffectiveDescriptor().get().getStandardDependencies()) {
                if (NDependencyScope.parse(standardDependency.getScope()).orElse(NDependencyScope.API) != NDependencyScope.IMPORT) continue;
                this.addBomId(standardDependency.toId());
            }
        }
        return this;
    }

    public ResultingIds add(NId id) {
        if (!NBlankable.isBlank(id)) {
            if (this.classPath.containsKey(id.getLongId())) {
                return this;
            }
            List<NDefinition> list = NSearchCmd.of(id).setLatest(true).setDistinct(true).setDependencyFilter(NDependencyFilters.of().byRunnable(false, true)).setInlineDependencies(true).setIgnoreCurrentEnvironment(true).getResultDefinitions().toList();
            if (list.isEmpty()) {
                throw new NArtifactNotFoundException(id.getLongId());
            }
            for (NDefinition def : list) {
                if (!this.classPath.containsKey(def.getId().getLongId())) {
                    NId resultId = def.getId();
                    if ((def.getDescriptor().isPlatformApplication() || def.getDescriptor().isNutsApplication()) && this.isBaseId(resultId)) {
                        this.executableAppIds.add(resultId);
                    }
                    this.classPath.put(resultId.getLongId(), def);
                }
                for (NId parent : def.getDescriptor().getParents()) {
                    this.add(parent);
                }
                for (NDependency standardDependency : def.getEffectiveDescriptor().get().getStandardDependencies()) {
                    if (NDependencyScope.parse(standardDependency.getScope()).orElse(NDependencyScope.API) != NDependencyScope.IMPORT) continue;
                    this.addBomId(standardDependency.toId());
                }
            }
        }
        return this;
    }

    public boolean isBaseId(NId resultId) {
        for (NId baseId : this.baseIds) {
            if (!baseId.getLongName().equals(resultId.getShortName())) continue;
            return true;
        }
        for (NId baseId : this.baseIds) {
            if (!baseId.getShortName().equals(resultId.getShortName())) continue;
            return true;
        }
        for (NId baseId : this.baseIds) {
            if (!NBlankable.isBlank(baseId.getGroupId()) || !baseId.getArtifactId().equals(resultId.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public ResultingIds addAllId(String[] ids) {
        for (String id : ids) {
            if (NBlankable.isBlank(id)) continue;
            this.baseIds.add(NId.of(id));
        }
        for (String id : ids) {
            this.add(id);
        }
        return this;
    }

    public ResultingIds addAllLibs(String[] ids) {
        for (String id : ids) {
            this.add(id);
        }
        return this;
    }

    public void build() {
        NSession session = NSession.of();
        if (this.findNutsRuntimeId() == null) {
            for (NDefinition resultIdDef : new ArrayList<NDefinition>(this.classPath.values())) {
                if (!resultIdDef.getId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
                if (resultIdDef.getId().getLongName().equals(session.getWorkspace().getAppId().getLongName())) {
                    this.add(session.getWorkspace().getRuntimeId());
                    break;
                }
                this.add(session.getWorkspace().getRuntimeId().builder().setVersion(resultIdDef.getId().getVersion() + ".0").build());
                break;
            }
        }
        if (this.findNutsRuntimeId() == null) {
            this.add(session.getWorkspace().getRuntimeId());
        }
        if (this.findNutsAppId() == null) {
            for (NDefinition resultIdDef : new ArrayList<NDefinition>(this.classPath.values())) {
                if (!resultIdDef.getId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
                if (resultIdDef.getId().getLongName().equals(session.getWorkspace().getAppId().getLongName())) {
                    this.add(session.getWorkspace().getAppId());
                    break;
                }
                NVersion v = resultIdDef.getId().getVersion();
                if (v.compareTo("0.8.5") < 0) break;
                NId appId = NWorkspace.of().getAppId();
                this.add(appId.builder().setVersion(resultIdDef.getId().getVersion()).build());
                break;
            }
        }
        if (this.findNutsRuntimeId() == null) {
            this.add(session.getWorkspace().getAppId());
        }
    }
}

