/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.DefaultNExecutionContext;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NExecutionContextBuilder;
import net.thevpc.nuts.util.NCollections;

public class DefaultNExecutionContextBuilder
implements NExecutionContextBuilder {
    private NDefinition definition;
    private Map<String, String> env;
    private List<String> executorOptions = new ArrayList<String>();
    private List<String> workspaceOptions = new ArrayList<String>();
    private List<String> arguments;
    private NArtifactCall executorDescriptor;
    private NPath cwd;
    private String commandName;
    private boolean failFast;
    private boolean temporary;
    private long sleepMillis = 1000L;
    private NExecutionType executionType;
    private NRunAs runAs = NRunAs.currentUser();
    private NExecInput in;
    private NExecOutput out;
    private NExecOutput err;
    private boolean dry;
    private boolean bot;

    public DefaultNExecutionContextBuilder() {
    }

    public DefaultNExecutionContextBuilder(NDefinition definition, List<String> arguments, List<String> executorArgs, Map<String, String> env, NPath cwd, boolean failFast, boolean temporary, NExecutionType executionType, String commandName, long sleepMillis, NExecInput in, NExecOutput out, NExecOutput err, boolean dry, boolean bot) {
        this.commandName = commandName;
        this.definition = definition;
        this.arguments = NCollections.nonNullList(arguments);
        this.executorOptions = NCollections.nonNullList(executorArgs);
        this.sleepMillis = sleepMillis;
        this.cwd = cwd;
        if (env == null) {
            env = new LinkedHashMap<String, String>();
        }
        this.env = env;
        this.failFast = failFast;
        this.temporary = temporary;
        this.executionType = executionType;
        this.executorDescriptor = definition.getDescriptor().getExecutor();
        this.in = in;
        this.out = out;
        this.err = err;
        this.dry = dry;
        this.bot = bot;
    }

    public DefaultNExecutionContextBuilder(NExecutionContext other) {
        this.commandName = other.getCommandName();
        this.definition = other.getDefinition();
        this.arguments = NCollections.nonNullList(other.getArguments());
        this.executorOptions.addAll(NCollections.nonNullList(other.getExecutorOptions()));
        this.cwd = other.getDirectory();
        this.env = other.getEnv();
        this.failFast = other.isFailFast();
        this.temporary = other.isTemporary();
        this.executionType = other.getExecutionType();
        this.executorDescriptor = other.getExecutorDescriptor();
        this.sleepMillis = other.getSleepMillis();
        this.in = other.getIn();
        this.out = other.getOut();
        this.err = other.getErr();
        this.dry = other.isDry();
        this.bot = other.isBot();
    }

    @Override
    public boolean isDry() {
        return this.dry;
    }

    @Override
    public NExecutionContextBuilder setDry(boolean dry) {
        this.dry = dry;
        return this;
    }

    @Override
    public boolean isBot() {
        return this.bot;
    }

    @Override
    public NExecutionContextBuilder setBot(boolean bot) {
        this.bot = bot;
        return this;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public long getSleepMillis() {
        return this.sleepMillis;
    }

    @Override
    public String[] getExecutorOptions() {
        return this.executorOptions.toArray(new String[0]);
    }

    @Override
    public NDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public NArtifactCall getExecutorDescriptor() {
        return this.executorDescriptor;
    }

    @Override
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Override
    public NPath getDirectory() {
        return this.cwd;
    }

    @Override
    public boolean isFailFast() {
        return this.failFast;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public NExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    public NRunAs getRunAs() {
        return this.runAs;
    }

    @Override
    public NExecutionContextBuilder setDefinition(NDefinition definition) {
        this.definition = definition;
        return this;
    }

    @Override
    public NExecutionContextBuilder setSleepMillis(long sleepMillis) {
        this.sleepMillis = sleepMillis;
        return this;
    }

    @Override
    public NExecutionContextBuilder setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    @Override
    public NExecutionContextBuilder setExecutorOptions(List<String> executorOptions) {
        this.executorOptions.clear();
        if (executorOptions != null) {
            this.executorOptions.addAll(NCollections.nonNullList(executorOptions));
        }
        return this;
    }

    @Override
    public NExecutionContextBuilder setWorkspaceOptions(List<String> workspaceOptions) {
        this.workspaceOptions.clear();
        if (workspaceOptions != null) {
            this.workspaceOptions.addAll(NCollections.nonNullList(workspaceOptions));
        }
        return this;
    }

    @Override
    public NExecutionContextBuilder setExecutorOptions(String[] executorOptions) {
        this.executorOptions.clear();
        if (executorOptions != null) {
            this.executorOptions.addAll(Arrays.asList(executorOptions));
        }
        return this;
    }

    @Override
    public NExecutionContextBuilder addExecutorOptions(List<String> executorOptions) {
        if (executorOptions != null) {
            this.executorOptions.addAll(executorOptions);
        }
        return this;
    }

    @Override
    public NExecutionContextBuilder addExecutorOptions(String[] executorOptions) {
        if (executorOptions != null) {
            this.executorOptions.addAll(Arrays.asList(executorOptions));
        }
        return this;
    }

    @Override
    public NExecutionContextBuilder setArguments(String[] arguments) {
        this.arguments = NCollections.nonNullList(Arrays.asList(arguments));
        return this;
    }

    @Override
    public NExecutionContextBuilder setExecutorDescriptor(NArtifactCall executorDescriptor) {
        this.executorDescriptor = executorDescriptor;
        return this;
    }

    @Override
    public NExecutionContextBuilder setDirectory(NPath cwd) {
        this.cwd = cwd;
        return this;
    }

    @Override
    public NExecutionContextBuilder setCommandName(String commandName) {
        this.commandName = commandName;
        return this;
    }

    @Override
    public NExecutionContextBuilder setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public NExecutionContextBuilder setTemporary(boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    @Override
    public NExecutionContextBuilder failFast() {
        return this.setFailFast(true);
    }

    @Override
    public NExecutionContextBuilder temporary() {
        return this.setTemporary(true);
    }

    @Override
    public NExecutionContextBuilder setExecutionType(NExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    @Override
    public NExecutionContextBuilder setRunAs(NRunAs runAs) {
        this.runAs = runAs == null ? NRunAs.currentUser() : runAs;
        return this;
    }

    @Override
    public NExecutionContext build() {
        return new DefaultNExecutionContext(this.definition, this.arguments, this.executorOptions, this.workspaceOptions, this.env, this.cwd, this.failFast, this.temporary, this.executionType, this.commandName, this.sleepMillis, this.in, this.out, this.err, this.dry, this.bot).setSession(NSession.of());
    }

    @Override
    public NExecutionContextBuilder copyFrom(NExecutionContext other) {
        this.commandName = other.getCommandName();
        this.definition = other.getDefinition();
        this.arguments = other.getArguments();
        this.executorOptions.clear();
        this.executorOptions.addAll(other.getExecutorOptions());
        this.workspaceOptions.clear();
        this.workspaceOptions.addAll(other.getWorkspaceOptions());
        this.cwd = other.getDirectory();
        this.env = other.getEnv();
        this.failFast = other.isFailFast();
        this.temporary = other.isTemporary();
        this.executionType = other.getExecutionType();
        this.executorDescriptor = other.getExecutorDescriptor();
        this.sleepMillis = other.getSleepMillis();
        this.in = other.getIn();
        this.out = other.getOut();
        this.err = other.getErr();
        this.dry = other.isDry();
        return this;
    }

    public NExecInput getIn() {
        return this.in;
    }

    @Override
    public NExecutionContextBuilder setIn(NExecInput in) {
        this.in = in;
        return this;
    }

    public NExecOutput getOut() {
        return this.out;
    }

    @Override
    public NExecutionContextBuilder setOut(NExecOutput out) {
        this.out = out;
        return this;
    }

    public NExecOutput getErr() {
        return this.err;
    }

    @Override
    public NExecutionContextBuilder setErr(NExecOutput err) {
        this.err = err;
        return this;
    }
}

