/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.util.NCollections;

public class DefaultNExecutionContext
implements NExecutionContext {
    private NDefinition definition;
    private Map<String, String> env;
    private List<String> executorOptions;
    private List<String> workspaceOptions;
    private List<String> arguments;
    private NSession session;
    private NArtifactCall executorDescriptor;
    private NPath cwd;
    private String commandName;
    private boolean failFast;
    private boolean temporary;
    private long sleepMillis;
    private NExecutionType executionType;
    private NRunAs runAs;
    private NExecInput in;
    private NExecOutput out;
    private NExecOutput err;
    private boolean dry;
    private boolean bot;

    public DefaultNExecutionContext(NDefinition definition, List<String> arguments, List<String> executorArgs, List<String> workspaceOptions, Map<String, String> env, NPath cwd, boolean failFast, boolean temporary, NExecutionType executionType, String commandName, long sleepMillis, NExecInput in, NExecOutput out, NExecOutput err, boolean dry, boolean bot) {
        this.commandName = commandName;
        this.definition = definition;
        this.arguments = NCollections.unmodifiableList(arguments);
        this.executorOptions = NCollections.unmodifiableList(executorArgs);
        this.workspaceOptions = NCollections.unmodifiableList(workspaceOptions);
        this.sleepMillis = sleepMillis;
        this.cwd = cwd;
        if (env == null) {
            env = new LinkedHashMap<String, String>();
        }
        this.env = env;
        this.failFast = failFast;
        this.temporary = temporary;
        this.executionType = executionType;
        this.executorDescriptor = definition.getDescriptor().getExecutor();
        this.in = in;
        this.out = out;
        this.err = err;
        this.dry = dry;
        this.bot = bot;
    }

    public DefaultNExecutionContext(NExecutionContext other) {
        this.commandName = other.getCommandName();
        this.definition = other.getDefinition();
        this.arguments = other.getArguments();
        this.session = other.getSession();
        this.executorOptions = other.getExecutorOptions();
        this.workspaceOptions = other.getWorkspaceOptions();
        this.cwd = other.getDirectory();
        this.env = other.getEnv();
        this.failFast = other.isFailFast();
        this.temporary = other.isTemporary();
        this.executionType = other.getExecutionType();
        this.executorDescriptor = other.getExecutorDescriptor();
        this.sleepMillis = other.getSleepMillis();
        this.in = other.getIn();
        this.out = other.getOut();
        this.err = other.getErr();
        this.dry = other.isDry();
        this.bot = other.isBot();
    }

    @Override
    public boolean isDry() {
        return this.dry;
    }

    @Override
    public NExecutionContext setDry(boolean dry) {
        this.dry = dry;
        return this;
    }

    @Override
    public boolean isBot() {
        return this.bot;
    }

    @Override
    public NExecInput getIn() {
        return this.in;
    }

    @Override
    public DefaultNExecutionContext setIn(NExecInput in) {
        this.in = in;
        return this;
    }

    @Override
    public NExecOutput getOut() {
        return this.out;
    }

    @Override
    public DefaultNExecutionContext setOut(NExecOutput out) {
        this.out = out;
        return this;
    }

    @Override
    public NExecOutput getErr() {
        return this.err;
    }

    @Override
    public DefaultNExecutionContext setErr(NExecOutput err) {
        this.err = err;
        return this;
    }

    @Override
    public long getSleepMillis() {
        return this.sleepMillis;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public List<String> getExecutorOptions() {
        return this.executorOptions;
    }

    @Override
    public List<String> getWorkspaceOptions() {
        return this.workspaceOptions;
    }

    @Override
    public NDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public NArtifactCall getExecutorDescriptor() {
        return this.executorDescriptor;
    }

    @Override
    public NSession getSession() {
        return this.session;
    }

    @Override
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Override
    public NPath getDirectory() {
        return this.cwd;
    }

    @Override
    public boolean isFailFast() {
        return this.failFast;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public NExecutionType getExecutionType() {
        return this.executionType;
    }

    public DefaultNExecutionContext setDefinition(NDefinition definition) {
        this.definition = definition;
        return this;
    }

    public DefaultNExecutionContext setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public DefaultNExecutionContext setExecutorOptions(String[] executorOptions) {
        this.executorOptions = NCollections.unmodifiableList(Arrays.asList(executorOptions));
        return this;
    }

    public DefaultNExecutionContext setArguments(String[] arguments) {
        this.arguments = NCollections.unmodifiableList(Arrays.asList(arguments));
        return this;
    }

    public DefaultNExecutionContext setSession(NSession session) {
        this.session = session;
        return this;
    }

    public DefaultNExecutionContext setExecutorDescriptor(NArtifactCall executorDescriptor) {
        this.executorDescriptor = executorDescriptor;
        return this;
    }

    public DefaultNExecutionContext setCwd(NPath cwd) {
        this.cwd = cwd;
        return this;
    }

    public DefaultNExecutionContext setCommandName(String commandName) {
        this.commandName = commandName;
        return this;
    }

    public DefaultNExecutionContext setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public DefaultNExecutionContext setTemporary(boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    public DefaultNExecutionContext setExecutionType(NExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    @Override
    public NRunAs getRunAs() {
        return this.runAs;
    }

    public DefaultNExecutionContext setRunAs(NRunAs runAs) {
        this.runAs = runAs;
        return this;
    }
}

