/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.archetype;

import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.security.NUpdateUserCmd;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.spi.NWorkspaceArchetypeComponent;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.WORKSPACE)
public class MinimalNWorkspaceArchetypeComponent
implements NWorkspaceArchetypeComponent {
    @Override
    public String getName() {
        return "minimal";
    }

    @Override
    public void initializeWorkspace() {
        NRepositoryLocation[] br = NWorkspaceExt.of().getConfigModel().resolveBootRepositoriesList().resolve(new NRepositoryLocation[0], NRepositoryDB.of());
        NWorkspace workspace = NWorkspace.of();
        for (NRepositoryLocation s : br) {
            workspace.addRepository(s.toString());
        }
        NUpdateUserCmd uu = NWorkspaceSecurityManager.of().updateUser("anonymous");
        uu.run();
    }

    @Override
    public void startWorkspace() {
        NId api;
        NWorkspace workspace = NWorkspace.of();
        boolean initializeScripts = workspace.getBootOptions().getInitScripts().ifEmpty(true).get();
        boolean initializeLaunchers = workspace.getBootOptions().getInitLaunchers().ifEmpty(true).get();
        Boolean installCompanions = workspace.getBootOptions().getInstallCompanions().orElse(false);
        if ((initializeScripts || initializeLaunchers || installCompanions.booleanValue()) && (api = NFetchCmd.of().setId(workspace.getApiId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setFailFast(false).getResultId()) != null) {
            if (initializeScripts || initializeLaunchers) {
                NWorkspaceUtils.of(workspace).installScriptsAndLaunchers(initializeLaunchers);
            }
            if (installCompanions.booleanValue() && api != null) {
                NWorkspaceUtils.of(workspace).installCompanions();
            }
        }
    }

    @Override
    public int getScore(NScorableContext criteria) {
        return 11;
    }
}

